<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// SVG Mask
function na_mask($type, $mask, $fill='#fff', $color='#cd2122') {

	if(!$mask || $mask == 'none') 
		return;

	$rev = ($type == "head") ? ' na-mask-rev' : '';

	if($mask == "border") {

echo <<<HTMLCODE
<div class="border-top"></div>
HTMLCODE;

	} if($mask == "line1") {

echo <<<HTMLCODE
<div class="na-mask-line1 mask-zone mask-height"></div>
<div class="na-mask na-mask-line1$rev"><div class="mask-fill" style="background-color: $fill;"></div></div>
HTMLCODE;

	} else if($mask == "line2") {

echo <<<HTMLCODE
<div class="na-mask-line2 mask-zone mask-height"></div>
<div class="na-mask na-mask-line2$rev"><div class="mask-fill" style="background-color: $fill;"></div></div>
HTMLCODE;

	} else if($mask == "bubble1" || $mask == "bubble3" || $mask == "bubble5") {
		$bb = '';
		if($mask == "bubble3") {
			$bb = ' mask-left';
		} if($mask == "bubble5") {
			$bb = ' mask-right';
		}

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-bubble1 mask-zone mask-height"></div>
<div class="na-mask na-mask-bubble1$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="mask-svg$bb" viewBox="0 0 5000 27" width="5000px" height="27px" version="1.1">
		<defs>
			<filter id="$id" x="-50%" y="-50%" width="200%" height="200%" filterUnits="objectBoundingBox">
				<feOffset result="shadowOffsetInner" in="SourceAlpha" dx="0" dy="2" />
				<feGaussianBlur result="shadowBlurInner" in="shadowOffsetInner" stdDeviation="1.5" />
				<feComposite result="shadowInnerInner" in="shadowBlurInner" in2="SourceAlpha" operator="arithmetic" k2="-1" k3="1" />
				<feColorMatrix result="shadowMatrixInner" in="shadowInnerInner" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.35 0" />
				<feMerge>
					<feMergeNode in="SourceGraphic" />
					<feMergeNode in="shadowMatrixInner1" />
				</feMerge>
			</filter>
		</defs>
		<path filter="url(&quot;#$id&quot;)" fill="$fill" d="M 3.63976e-012 -0.007 L 2418 -0.007 L 2434 -0.007 C 2434 -0.007 2441.89 0.742 2448 2.976 C 2454.11 5.21 2479 15 2479 15 L 2492 21 C 2492 21 2495.12 23.038 2500 23 C 2505.27 23.03 2508 21 2508 21 L 2521 15 C 2521 15 2545.89 5.21 2552 2.976 C 2558.11 0.742 2566 -0.007 2566 -0.007 L 2582 -0.007 L 5000 -0.007 L 5000 27 L 2500 27 L 3.63976e-012 27 L 3.63976e-012 -0.007 Z" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "bubble2" || $mask == "bubble4" || $mask == "bubble6") {
		$bb = '';
		if($mask == "bubble4") {
			$bb = ' mask-left';
		} if($mask == "bubble6") {
			$bb = ' mask-right';
		}

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-bubble2 mask-zone mask-height"></div>
<div class="na-mask na-mask-bubble2$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="mask-svg$bb" viewBox="0 0 5000 57" width="5000px" height="57px" version="1.1">
		<defs>
			<filter id="$id" x="-50%" y="-50%" width="200%" height="200%" filterUnits="objectBoundingBox">
				<feOffset result="shadowOffsetInner1" in="SourceAlpha" dx="0" dy="3" />
				<feGaussianBlur result="shadowBlurInner1" in="shadowOffsetInner1" stdDeviation="2" />
				<feComposite result="shadowInnerInner1" in="shadowBlurInner1" in2="SourceAlpha" operator="arithmetic" k2="-1" k3="1" />
				<feColorMatrix result="shadowMatrixInner1" in="shadowInnerInner1" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
				<feMerge>
					<feMergeNode in="SourceGraphic" />
					<feMergeNode in="shadowMatrixInner1" />
				</feMerge>
			</filter>
		</defs>
	    <path filter="url(&quot;#$id&quot;)" fill="$fill" d="M 9.09384e-013 57.0005 L 9.09384e-013 34.0075 L 2418 34.0075 L 2434 34.0075 C 2434 34.0075 2441.89 33.2585 2448 31.0245 C 2454.11 28.7905 2479 11.0005 2479 11.0005 L 2492 2.00052 C 2492 2.00052 2495.12 -0.0374751 2500 0.000524874 C 2505.27 -0.0294751 2508 2.00052 2508 2.00052 L 2521 11.0005 C 2521 11.0005 2545.89 28.7905 2552 31.0245 C 2558.11 33.2585 2566 34.0075 2566 34.0075 L 2582 34.0075 L 5000 34.0075 L 5000 57.0005 L 2500 57.0005 L 1148 57.0005 L 9.09384e-013 57.0005 Z" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "wave1") {

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-wave1 mask-zone mask-height"></div>
<div class="na-mask na-mask-wave1$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="mask-svg" viewBox="0 0 2560 40" width="2560px" height="40px" version="1.1">
		<defs> 
			<pattern id="$id" patternUnits="userSpaceOnUse" x="0" y="0" width="2560px" height="40px">
				<path fill="$fill" d="M 2240 40 h 320 V 20 C 2440 30 2320 40 2240 40 Z M 0 20 v 20 h 960 C 800 40 480 0 320 0 C 240 0 120 10 0 20 Z M 1280 20 c -120 10 -240 20 -320 20 h 1280 c -160 0 -480 -40 -640 -40 C 1520 0 1400 10 1280 20 Z" /> 
			</pattern>
		</defs>
		<rect fill="url(#$id)" x="0" y="0" width="100%" height="40px" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "wave2") {

echo <<<HTMLCODE
<div class="na-mask-wave2 mask-zone mask-height"></div>
<div class="na-mask na-mask-wave2$rev">
<svg id="clouds" xmlns="https://www.w3.org/2000/svg" version="1.1" width="100%" height="100px" viewBox="0 0 100 100" preserveAspectRatio="none">
				<path d="M-5 100 Q 0 20 5 100 Z
						 M0 100 Q 5 0 10 100
						 M5 100 Q 10 30 15 100
						 M10 100 Q 15 10 20 100
						 M15 100 Q 20 30 25 100
						 M20 100 Q 25 -10 30 100
						 M25 100 Q 30 10 35 100
						 M30 100 Q 35 30 40 100
						 M35 100 Q 40 10 45 100
						 M40 100 Q 45 50 50 100
						 M45 100 Q 50 20 55 100
						 M50 100 Q 55 40 60 100
						 M55 100 Q 60 60 65 100
						 M60 100 Q 65 50 70 100
						 M65 100 Q 70 20 75 100
						 M70 100 Q 75 45 80 100
						 M75 100 Q 80 30 85 100
						 M80 100 Q 85 20 90 100
						 M85 100 Q 90 50 95 100
						 M90 100 Q 95 25 100 100
						 M95 100 Q 100 15 105 100 Z" fill="$fill">
				</path>
			</svg>
</div>
HTMLCODE;

	} else if($mask == "wave3") {

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-wave3 mask-zone mask-height"></div>
<div class="na-mask na-mask-wave3$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 2560 30" width="2560px" height="30px" version="1.1">
		<defs>
			<pattern id="$id" patternUnits="userSpaceOnUse" x="0" y="0" width="1280px" height="30px">
				<polygon fill="$fill" points="1139,8 1059,20 645,0 478,19 267,11 0,21 0,30 1280,30 1280,21" />
			</pattern>
		</defs>
		<rect fill="url(#$id)" x="0" y="0" width="100%" height="30px" />
	</svg>	
</div>
HTMLCODE;

	} else if($mask == "wave4") {

echo <<<HTMLCODE
<div class="na-mask-wave4 mask-zone mask-height"></div>
<div class="na-mask na-mask-wave4$rev">
	<svg xmlns="https://www.w3.org/2000/svg" enable-background="new 0 0 1920 27" viewBox="0 0 1920 27" preserveAspectRatio="none meet" width="103%" height="20px">
		<path fill="$fill" d="M 1906.69 12.029 c -1.653 -1.78 -3.943 -0.347 -5.823 -0.883 c -0.623 0.442 -0.879 1.208 -1.873 1.044 c -1.992 -1.974 -5.01 -1.6 -7.448 -2.713 c -0.417 0.074 -0.441 0.997 -1.238 0.33 c -0.103 -0.113 -0.323 -0.356 -1.033 -1.142 c -0.492 0.938 -0.948 1.805 -1.409 2.683 c -2.1 -2.389 -5.174 0.159 -7.012 -2.03 c -0.991 1.465 -3.179 0.306 -4.117 1.874 c -0.5 -0.379 -0.778 -1.019 -1.599 -0.989 c -3.682 0.135 -6.783 2.202 -10.129 2.986 c -2.646 -2.246 -6.298 0.391 -8.975 -2.322 c -1.84 3.085 -5.408 -0.125 -7.492 2.352 c -2.784 -1.202 -5.6 -0.211 -7.657 1.15 c -2.544 1.684 -5.658 -0.525 -7.617 2.049 c -0.711 -0.49 -1.225 -0.845 -1.762 -1.215 c -1.235 0.125 -2.3 1.9 -3.511 0.95 c -1.499 -1.176 -3.069 -1.008 -4.633 -0.888 c -1.598 0.122 -2.832 -0.717 -3.89 -1.47 c -1.507 -1.073 -2.629 -2.676 -4.531 -0.757 c -2.571 -1.628 -5.022 1.022 -7.607 0.219 c -0.723 -0.225 -1.504 -0.072 -2.258 0.563 c -1.085 0.914 -2.433 0.347 -4.001 0.191 c -0.359 -0.553 -0.792 -1.217 -1.557 -2.392 c -0.742 1.224 -1.258 2.076 -1.313 2.166 c -2.294 1.216 -3.012 -0.829 -4.299 -0.584 c -2.297 1.75 -4.521 1.209 -6.864 -0.046 c -0.324 0.259 -0.688 0.799 -1.059 0.804 c -4.448 0.06 -8.899 0.038 -13.98 0.038 c -0.24 -0.405 -0.749 -1.262 -1.173 -1.976 c -2.149 1.008 -3.842 2.035 -5.738 0.538 c -1.279 -1.01 -3.3 0.474 -4.443 -1.4 c -0.961 -1.577 -3.543 -0.592 -4.438 -2.496 c -3.05 -0.142 -5.799 -2.602 -9.159 -0.84 c -1.687 0.884 -4.072 1.045 -5.593 -0.089 c -1.931 -1.44 -2.974 0.217 -4.092 0.435 c -1.995 -0.727 -3.73 -1.358 -5.471 -1.992 c -1.57 1.758 -3.127 1.162 -4.602 -0.068 c -1.607 1.257 -3.317 1.732 -4.943 0.605 c -0.969 -0.671 -1.885 -0.5 -2.809 -0.466 c -3.405 0.126 -6.516 -1.034 -9.699 -2.036 c -0.351 0.323 -0.711 0.655 -1.266 1.166 c -0.591 -0.759 -1.198 -1.538 -1.725 -2.212 c -2.557 0 -4.875 0 -8.18 0 c -0.132 -0.319 -0.531 -1.282 -0.687 -1.656 c -1.575 -0.655 -1.718 0.829 -2.71 0.698 c -0.934 0.347 -1.032 -1.229 -2.004 -0.986 c -0.555 -0.477 -1.205 -0.576 -1.831 -0.262 c -4.749 2.376 -9.568 1.722 -14.54 0.734 c -3.522 -0.699 -7.345 -0.937 -10.771 -0.021 c -8.529 2.281 -14.354 -0.386 -22.609 -1.185 c -0.667 0 -3.228 0.765 -3.895 0.765 c -0.269 1.448 -2.103 0.853 -2.87 2.04 c -2.285 -0.507 -4.856 0.825 -6.996 -1.004 c -0.521 0.312 -0.772 1.039 -1.604 0.942 c -2.775 -0.322 -5.41 0.34 -7.854 1.536 c -1.457 0.712 -3.183 0.871 -4.261 0.345 c -3.696 -1.805 -7.167 -0.856 -10.271 0.122 c -1.912 -0.04 -2.112 -2.065 -3.931 -2.006 c -1.694 -0.765 -1.941 1.694 -3.332 1.995 c -1.699 0 -3.39 0.18 -5.024 -0.049 c -1.732 -0.243 -2.798 1.396 -4.604 1.124 c -2.718 -0.409 -5.469 -0.152 -7.379 2.128 c -2.17 -1.577 -4.005 0.289 -5.965 -0.134 c -2.103 -0.454 -4.128 0.208 -5.64 1.813 c -3.357 0.918 -6.184 -1.798 -9.276 -0.846 c -0.445 -0.925 -0.152 -1.714 -0.918 -2.031 c -0.971 -0.401 -1.309 0.68 -2.029 0.883 c -0.604 -1.118 -1.666 -0.873 -2.634 -0.885 c -1.143 -0.013 -2.285 -0.003 -3.268 -0.003 c -1.106 -1.114 -2.044 -2.06 -2.726 -2.746 c -1.358 -0.58 -2.729 0.321 -3.578 -0.645 c -1.388 -1.575 -3.174 0.984 -4.441 -0.609 c -4.224 1.665 -8.423 1.515 -12.691 0.062 c -0.804 -0.273 -1.865 -0.181 -2.867 0.204 c -3.121 1.199 -6.329 2.133 -10.131 1.631 c -0.475 0.7 -1.028 1.521 -1.345 1.989 c -2.119 0.122 -3.817 -0.032 -5.385 0.352 c -9.312 2.279 -14.828 3.395 -21.018 2.769 c -0.495 -0.05 -1.111 -0.196 -1.481 0.024 c -2.459 1.461 -5.34 1.699 -7.979 2.411 c -2.833 0.764 -5.061 2.335 -7.593 3.466 c -0.969 0.433 -1.489 1.215 -2.317 1.644 c -3.614 1.874 -8.017 1.064 -11.524 3.343 c -3.526 -2.029 -7.422 -0.189 -11.06 -1.061 c -0.589 -0.589 -1.179 -1.178 -1.834 -1.834 c -3.257 0 -6.584 -0.095 -9.903 0.026 c -3.349 0.123 -5.717 -2.383 -8.814 -3.184 c -0.867 0.785 -1.689 1.528 -2.857 2.584 c -0.712 -1.586 -2.597 -1.038 -3.396 -2.375 c -4.875 -0.261 -9.631 -0.244 -13.903 2.711 c -0.939 0.65 -2.543 0.629 -3.646 -0.316 c -1.049 -0.897 -2.626 -0.786 -3.243 -0.338 c -1.525 1.113 -3.112 1.029 -4.655 0.83 c -1.742 -0.225 -3.054 1.255 -4.583 1.003 c -2.853 -0.469 -5.448 0.766 -8.049 1.29 c -1.847 0.371 -3.941 0.443 -5.849 1.488 c -2.252 1.235 -4.988 2.07 -7.542 2.143 c -2.824 0.081 -5.771 1.03 -8.669 -0.719 c -1.008 -0.608 -3.135 -0.79 -4.648 0.541 c -0.876 0.771 -2.188 0.289 -3.313 0.232 c -0.589 -0.591 -1.179 -1.181 -1.768 -1.771 c -1.306 -0.537 -3.041 0.573 -4.061 -1.059 c -3.901 -0.564 -7.618 -2.124 -11.633 -2.111 c -1.087 0.004 -2.119 0.145 -3.253 -0.631 c -1.381 -0.944 -2.94 -0.271 -4.455 0.588 c -1.642 0.931 -3.068 -1.93 -4.954 -0.711 c -0.273 0.178 -0.443 0.617 -0.717 0.676 c -2.816 0.599 -5.678 1.731 -8.461 1.572 c -4.614 -0.264 -9.223 -1.017 -13.843 -1.456 c -5.847 -0.556 -11.815 1.072 -17.592 -0.986 c -0.592 -0.211 -1.58 -0.312 -1.946 0.02 c -1.806 1.633 -4.211 1.089 -6.27 1.794 c -2.087 0.716 -4.611 0.158 -6.944 0.158 c -1.503 -0.432 -2.372 -2.113 -4.172 -2.019 c -1.662 0.087 -3.478 -0.396 -4.961 0.126 c -1.763 0.62 -3.121 -2.656 -4.758 -0.227 c -1.436 -2.093 -2.76 0.089 -4.118 0.178 c -5.541 0.364 -10.891 -0.694 -16.074 -2.332 c -1.263 -0.398 -2.465 -0.812 -3.678 -0.678 c -2.656 0.294 -5.127 -0.484 -7.456 -1.379 c -2.272 -0.874 -4.205 -0.792 -6.463 -0.06 c -7.844 2.541 -6.753 3.244 -15.267 0.626 c -3.086 -0.949 -5.96 -2.991 -9.862 -2.097 c -0.385 -0.789 -0.739 -1.516 -1.019 -2.087 c -2.055 1.425 -3.956 1.311 -5.706 0.346 c -1.307 -0.72 -2.924 -0.75 -3.775 -0.278 c -2.287 1.266 -4.743 0.539 -6.987 1.041 c -0.512 2.917 -2.846 3.626 -4.926 3.726 c -2.612 0.124 -5.023 0.659 -7.318 1.736 c -0.653 0.306 -1.226 0.383 -1.847 0.363 c -2.501 -0.082 -4.068 1.571 -5.756 3.013 c -2.233 0.087 -4.569 -0.512 -6.791 1.418 c -0.471 -1.835 -1.769 -1.304 -2.878 -1.432 c -1.256 -0.146 -2.88 0.903 -3.375 0.583 c -1.313 -0.849 -2.553 -0.435 -3.8 -0.543 c -1.323 -0.114 -2.667 -0.082 -3.997 -0.014 c -3.085 0.157 -5.937 -1.626 -9.063 -1.063 c -1.444 -1.706 -3.651 -1.35 -5.054 -0.812 c -3.057 1.172 -6.092 0.68 -9.137 0.865 c -0.644 0.039 -1.326 -0.01 -1.922 0.189 c -3.33 1.112 -6.717 1.99 -10.247 1.782 c -4.751 -0.28 -9.317 1.747 -14.083 1.016 c -0.645 -0.099 -0.807 0.622 -1.214 0.686 c -2.856 0.444 -5.156 2.096 -8.292 3.524 c -2.365 -0.867 -6.328 -2.242 -7.198 -2.998 c -2.773 -1.573 -5.327 2.088 -8.085 0.087 c -2.148 1.771 -5.14 -0.317 -7.36 1.629 c -0.443 0.388 -1.774 0.116 -2.783 -0.26 c -3.272 -1.218 -6.678 -0.943 -10.029 -0.181 c -1.969 0.448 -3.911 1.011 -5.864 1.521 c -2.057 -2.154 -4.113 -0.146 -6.17 0 c -3.287 -1.954 -6.9 -2.259 -10.441 -1.98 c -1.35 -1.258 -2.661 -1.43 -4.34 -1.475 c -1.521 -0.041 -3.323 -1.036 -4.664 -1.791 c -1.818 -1.022 -3.526 -0.294 -5.167 -0.868 c -0.98 -1.14 -2.457 -1.3 -3.7 -1.961 c -0.413 0.362 -0.778 0.682 -1.144 1.002 c -0.575 -0.178 -0.733 -1.094 -2.059 -0.819 c -2.482 2.394 -6.367 2.596 -10.038 3.972 c -0.554 -0.703 -1.166 -1.48 -1.646 -2.09 c -1.979 0 -4.188 0.655 -5.173 -0.163 c -1.275 -1.062 -3.067 -0.118 -3.902 -1.604 c -1.041 0.813 -2.247 0.834 -3.494 0.791 c -1.498 -0.051 -2.998 -0.007 -4.497 -0.014 c -0.628 -0.003 -0.699 1.07 -1.693 0.694 c -0.168 -0.025 -0.191 -0.975 -0.831 -0.406 c -0.595 0.832 0.337 2.039 -1.103 2.948 c -4.826 -1.897 -10.075 -3.35 -15.699 -3.981 c -1.394 1.522 -3.377 0.406 -5.231 0.826 c -0.671 -0.881 -1.173 -1.539 -1.694 -2.225 c -3.583 1.016 -6.671 -1.573 -10.036 -0.792 c -0.321 -0.779 -0.555 -1.348 -0.792 -1.918 c -0.626 -0.23 -1.209 -0.299 -1.579 0.402 c 0.392 0.502 1.087 0.815 0.885 1.839 c -0.179 0.216 -0.486 0.574 -0.78 0.944 c -1.035 1.3 -2.845 0.007 -3.629 0.784 c -1.345 1.334 -2.823 0.95 -4.168 0.8 c -1.271 -0.141 -2.348 1.22 -3.343 0.52 c -1.493 -1.049 -2.836 0.617 -3.76 0.188 c -3.873 -1.803 -7.05 0.221 -10.776 1.511 c -0.034 -1.703 -1.615 -1.113 -2.562 -1.535 c -1.959 -0.873 -4.205 -1.103 -6.333 -1.597 c -2.651 2.137 -5.744 0.481 -8.584 0.997 c -1.03 0.187 -1.323 -1.671 -2.58 -0.931 c -0.573 0.574 -1.162 1.163 -1.979 1.98 c -3.573 -0.473 -7.454 0.813 -11.184 -0.814 c -0.588 0.588 -1.178 1.177 -1.856 1.855 c -0.747 -1.711 -2.58 -1.477 -3.434 -0.98 c -2.351 1.366 -4.772 0.632 -7.144 0.905 c -2.861 0.331 -5.878 -0.878 -8.616 0.939 c -0.418 0.277 -1.558 0.173 -1.839 -0.177 c -0.937 -1.166 -2.153 -0.861 -3.209 -0.732 c -2.721 0.335 -4.974 -0.697 -7.014 -2.082 c -1.225 0.262 -2.051 0.971 -3.23 1.146 c -1.83 0.272 -3.478 -1.175 -5.255 -0.274 c -1.221 -1.703 -3.44 -0.036 -4.774 -1.426 c -0.81 -0.844 -1.946 -0.515 -2.812 -0.338 c -1.199 0.245 -2.174 1.308 -3.604 0.95 c -1.085 -0.271 -2.321 0.4 -3.334 -0.396 c -0.89 -0.699 -1.901 0.168 -2.997 -0.49 c -0.985 -0.593 -2.724 -0.445 -3.89 0.755 c -0.626 -0.689 -1.18 -1.299 -1.712 -1.886 c -0.417 0.359 -0.834 0.993 -1.151 0.946 c -2.219 -0.328 -4.478 0.692 -6.735 -0.643 c -1.276 -0.755 -3.208 -0.837 -4.623 0.225 c -0.953 0.714 -1.799 0.449 -2.726 0.279 c -0.216 -0.592 -0.427 -1.169 -0.691 -1.895 c -2.699 0.559 -5.569 -0.833 -8.078 0.906 c -2.688 -2.219 -6.326 0.428 -9.251 -1.695 c -1.083 -0.785 -3.216 -0.127 -4.599 -0.127 c -1.52 1.064 -2.737 2.025 -4.478 2.028 c -1.248 0.001 -2.699 -0.55 -3.62 0.888 c -1.256 -1.885 -2.411 -0.326 -3.646 0.052 c -0.609 0.187 -1.425 0.252 -1.974 -0.003 c -4.376 -2.026 -9.253 -1.71 -13.748 -3.037 c -2.021 -0.598 -3.899 -1.248 -5.899 -0.768 c -2.022 2.468 -5.151 2.399 -7.581 3.781 c -1.367 0.776 -2.691 -0.603 -4.131 -1.026 c -0.883 1.229 -2.49 1.193 -3.612 2.149 c -2.816 -2.362 -5.209 -0.515 -7.65 0.778 c -0.844 -1.183 -2.169 -1.243 -3.021 -0.547 c -1.399 1.144 -2.736 0.768 -4.105 0.391 c -3.305 -0.909 -8.024 -0.512 -11.431 -0.089 c -4.46 0.554 -8.897 3.014 -13.567 0.466 c -1.463 -0.799 -3.078 0.344 -4.375 1.056 c -0.85 -0.495 -1.261 -1.27 -2.264 -1.15 c -1.15 0.136 -2.331 -0.018 -3.494 0.046 c -1.043 0.057 -1.391 -1.352 -2.594 -1.049 c -1.111 0.28 -2.241 0.104 -3.049 -0.898 c -0.695 0.735 -1.469 1.58 -2.388 0.432 c -0.857 -1.071 -2.272 0.091 -3.115 -1.019 c -0.583 -0.768 -1.884 1.156 -2.445 -0.465 c -1.418 1.769 -3.375 0.822 -5.093 0.953 c -1.822 0.139 -3.981 0.636 -5.417 -0.119 c -1.878 -0.987 -3.198 0.296 -4.747 0.313 c -1.509 0.017 -2.263 -1.29 -3.565 -1.185 c -1.332 1.381 -3.052 1.563 -4.426 0.635 c -1.61 -1.089 -3.452 -0.974 -4.711 -0.479 c -2.676 1.051 -5.646 0.289 -7.828 1.938 c -0.683 -0.542 -1.055 -0.839 -1.688 -1.342 c -0.829 0.576 -1.777 1.076 -2.848 1.373 c -3.517 0.977 -7.056 1.02 -10.609 0.846 c -1.409 -0.068 -2.471 0.435 -3.549 1.069 c -1.926 -0.894 -3.757 -0.987 -5.342 -1.232 c -2.083 -0.321 -4.088 -1.155 -6.135 -1.772 c -0.341 0.311 -0.696 0.633 -1.05 0.955 c -0.949 -0.949 -1.892 -1.892 -2.967 -2.968 c -0.514 0 -1.163 -0.001 -1.811 0 c -0.608 0.001 -0.663 -1.126 -1.408 -0.78 c -0.296 0.296 -0.532 0.532 -0.768 0.768 c -2.003 -1.778 -2.003 -1.778 -4.481 -2.451 c -0.039 -0.618 0.13 -1.346 -0.79 -1.529 c -3.206 1.594 -6.601 0.994 -9.968 0.765 c -0.931 -1.668 -1.427 0.507 -2.274 0.259 c -1.041 -0.306 -1.756 -1.276 -3.085 -1.105 c -1.035 0.133 -1.745 0.709 -2.603 0.992 c -1.053 0.346 -2.321 0.197 -3.468 0.05 c -1.123 -0.144 -1.734 0.768 -2.601 0.985 c -2.311 0.58 -4.655 1.614 -7.058 0.991 c -1.986 -0.515 -3.309 1.3 -5.096 1.04 c -1.716 -0.248 -2.819 -2.006 -4.672 -1.988 c -0.48 0.006 -1.005 0.111 -1.326 -0.419 c 0.217 -1.201 -0.782 -1.697 -1.415 -2.407 c -1.292 -0.588 -2.923 0.468 -4.132 -1 c -0.348 -0.423 -1.842 -0.491 -2.335 -0.108 c -2.484 1.927 -5.761 -0.025 -8.259 1.882 c -0.759 0.579 -1.799 -0.181 -2.503 -0.876 c -4.245 1.979 -5.566 2.092 -10.38 2.008 c -1.64 -0.028 -3.296 0.806 -4.912 1.238 c -0.235 0.615 0.028 1.39 -1.033 1.775 c -1.321 -0.673 -2.828 -1.439 -4.226 -2.15 c -0.913 0.293 -1.238 1.397 -2.357 1.017 c -0.283 -0.255 -0.646 -0.579 -1.189 -1.069 c -0.287 1.471 -1.421 1.18 -2.375 1.095 c -2.043 -0.183 -3.799 -1.27 -5.693 -1.917 c -2.101 -0.717 -4.565 0.853 -6.657 -0.875 c -0.408 -0.337 -1.498 0.116 -1.865 -0.229 c -2.137 -2.005 -4.153 -0.596 -6.215 0.222 c -0.931 -1.526 -2.305 -1.788 -3.374 -0.746 c -1.943 1.897 -3.276 -0.342 -4.864 -0.531 c -1.855 -0.221 -3.326 2.316 -4.94 0.811 c -1.349 -1.258 -2.909 -0.114 -4.57 -1.309 c -0.179 -0.207 -0.711 -0.823 -1.21 -1.402 c -0.616 0.412 -0.896 1.157 -1.866 0.963 c -2.224 -2.004 -5.235 -3.755 -8.021 -2.738 c -2.296 0.838 -3.802 0.482 -5.77 -0.179 c -2.098 -0.704 -4.248 -1.223 -6.57 -1.123 c -2.024 0.087 -4.011 0.092 -6.159 -0.72 c -2.105 -0.795 -4.683 -0.251 -6.682 -2.073 c -0.509 -0.463 -1.934 -0.53 -2.637 0.516 c -0.365 0.543 -0.893 0.287 -1.114 0.319 c -1.406 -0.75 -2.636 -1.405 -3.804 -2.028 c -2.504 1.352 -4.994 2.255 -7.78 2.065 c -1.37 -0.094 -2.727 -0.035 -3.96 0.694 c -1.209 -1.401 -2.82 -0.387 -4.208 -0.702 c -3.62 -0.819 -6.958 1.528 -11.579 0.768 c -0.032 -0.08 -0.401 -0.995 -0.917 -2.273 c -1.01 2.458 -2.813 2.302 -4.293 2.836 c -2.534 0.914 -5.234 0.974 -7.805 1.67 c -3.218 -1.734 -6.673 -0.716 -9.859 -1.035 c -1.111 1.111 -2.053 2.054 -3.036 3.037 c -2.809 0.018 -5.796 -0.494 -8.012 1.982 c -0.656 -0.656 -1.245 -1.245 -2.011 -2.011 c -3.176 0.305 -6.626 -0.709 -9.844 1.024 c -2.124 -1.083 -2.086 -0.977 -3.818 -0.358 c -1.165 0.416 -2.049 1.458 -3.438 1.375 c -2.79 -0.167 -5.621 0.335 -8.363 -0.534 c -0.075 0.488 0.207 1.044 -0.828 1.633 c -2.107 -1.286 -4.136 1.014 -6.53 0.899 c -1.032 -0.532 -1.426 -1.861 -2.992 -2.075 c -1.815 1.799 -4.035 1.946 -6.656 1.126 c -3.284 -1.028 -6.238 2.367 -9.666 1.103 c -1.319 1.573 -3.447 0.094 -4.576 0.938 c -1.846 1.38 -3.191 -0.94 -4.748 -0.105 c -1.646 -1.447 -3.679 -0.854 -5.396 -1.017 c -2.018 -1.521 -3.892 -2.889 -5.871 -1.552 c -0.93 0.408 -0.84 -0.752 -1.598 -0.083 c -0.175 0.18 -0.407 0.417 -0.643 0.659 c -0.566 -0.59 -1.054 -1.341 -2.827 -0.624 c -0.076 0.131 -0.547 0.951 -1.02 1.77 c 0 -0.371 -0.001 -0.741 -0.001 -1.112 c -5.352 0.475 -9.849 -1.026 -13.06 -4.952 c -2.449 0.903 -2.449 0.903 -4.533 -0.089 c -2.724 1.548 -5.446 1.525 -8.169 0.001 c -1.368 0.71 -2.736 1.42 -3.397 1.763 c -3.532 -0.728 -6.427 -1.307 -8.771 -2.919 c -0.741 0.571 -1.028 1.297 -1.82 1.158 c -1.388 -0.72 -2.756 -1.43 -3.868 -2.007 c -3.021 1.753 -5.96 0.652 -8.615 1.049 c -0.797 -0.871 -1.356 -1.482 -2.097 -2.291 c -1.741 1.015 -3.215 -0.443 -4.653 -0.828 c -0.575 0.466 -0.91 0.737 -1.235 1.001 c -0.673 -0.673 -1.262 -1.263 -1.872 -1.872 c -2.219 2.337 -4.406 0.048 -6.982 -0.156 c -2.32 3.421 -6.463 3.874 -10.109 4.943 c -2.834 0.832 -6.127 -0.284 -9.045 1.139 c -0.256 0.125 -0.796 0.116 -0.944 -0.055 c -1.258 -1.452 -3.393 -0.696 -4.481 -2.077 c -0.706 0.45 -1.174 0.75 -1.612 1.028 c -0.348 -0.348 -0.583 -0.583 -0.843 -0.843 c -0.689 0.644 -1.378 1.288 -2.452 2.29 c -0.484 -0.839 -0.958 -1.658 -1.373 -2.377 c -1.433 0.871 -1.534 2.105 -2.202 2.649 c -3.546 2.57 -7.799 0.318 -11.329 1.861 c -4.142 1.811 -7.867 -1.129 -11.987 -0.347 c -0.829 2.764 -4.707 1.139 -5.532 3.898 c -1.179 0 -2.176 0 -3.211 0 c -1.179 1.822 -3.615 2.105 -4.897 3.997 c -1.657 -0.287 -3.448 0.627 -5.084 -0.896 c -0.539 -0.502 -2.363 -0.525 -2.833 -0.034 c -1.654 1.725 -3.939 0.716 -5.85 1.736 c -1.677 0.895 -4.209 0.187 -6.288 0.187 c -1.525 -1.737 -3.758 -1.651 -5.562 -2.533 c -1.992 -0.974 -4.315 -0.342 -6.438 -1.366 c -1.779 -0.858 -4.248 0.826 -6.021 -1.063 c -0.493 0.387 -0.786 1.106 -2.217 0.851 c -0.233 -0.399 -0.736 -1.259 -0.868 -1.485 c -2.381 -0.849 -4.2 0.149 -5.89 -1.215 c -0.813 -0.657 -2.962 -0.701 -3.794 -0.075 c -1.715 1.29 -3.445 0.783 -5.17 0.861 c -2.328 0.105 -4.664 0.026 -6.997 0.025 c -1.719 1.708 -3.815 2.123 -6.171 2.029 c -2.98 -0.118 -5.97 -0.028 -8.855 -0.028 c -0.689 0.688 -1.278 1.278 -1.867 1.867 c -0.498 -0.308 -0.996 -0.616 -1.897 -1.175 c -0.388 2.401 -2.434 0.696 -3.564 1.615 c -0.293 0.569 0.012 1.362 -0.338 1.51 c -3.463 0.326 -6.337 0.991 -8.169 2.808 c -4.955 1.452 -9.135 -1.267 -13.568 -0.623 c -4.48 0.649 -8.601 -1.6 -12.961 -1.979 c 0 2.838 0 5.29 0 7.976 c 341.006 0 681.882 0 1022.76 0 c 14.494 0 28.988 -0.069 43.481 -0.015 c 3.862 0.015 5.46 -0.053 5.55 -0.188 c 283.215 0 565.436 0 847.625 0 c 0 -6.655 0 -13.224 0 -19.867 C 1915.9 10.076 1910.91 9.958 1906.69 12.029 Z" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "wave5") {

echo <<<HTMLCODE
<div class="na-mask-wave5 mask-zone mask-height"></div>
<div class="na-mask na-mask-wave5$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 2011 124.95" width="100%" height="120px" preserveAspectRatio="none">
		<path transform="translate(0 -52.64)" d="M 2011 156.4 V 92.28 C 1552 189.23 1380 131 813 66.8 S 0 177.59 0 177.59 H 2011 Z" fill="$fill" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "round1") {

echo <<<HTMLCODE
<div class="na-mask-round1 mask-zone mask-height"></div>
<div class="na-mask na-mask-round1$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="mask-svg" viewBox="0 0 2560 80" width="2560px" height="80px" version="1.1">
		<path fill="$fill" d="M 1278 80 h 1282 V 0 C 2560 0 1918.7 80 1278 80 Z M 0 80 h 1278 C 638.7 80 0 0 0 0 V 80 Z" /> 
	</svg>
</div>
HTMLCODE;

	} else if($mask == "round2") {

echo <<<HTMLCODE
<div class="na-mask-round2 mask-zone mask-height"></div>
<div class="na-mask na-mask-round2$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 2560 80" width="2560px" height="80px" version="1.1">
		<path fill="$fill" d="M 1278 80 h 1282 V 0 C 2560 0 1918.7 80 1278 80 Z M 0 80 h 1278 C 638.7 80 0 0 0 0 V 80 Z" /> 
	</svg>
</div>
HTMLCODE;

	} else if($mask == "round3") {

echo <<<HTMLCODE
<div class="na-mask-round3 mask-zone mask-height"></div>
<div class="na-mask na-mask-round3$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 100 50" preserveAspectRatio="none" width="100%" height="50px">
		<path fill="$fill" d="M100 50H0V0l50 48 50-48V50z"></path>
	</svg>
</div>
HTMLCODE;

	} else if($mask == "round4") {

echo <<<HTMLCODE
<div class="na-mask-round4 mask-zone mask-height"></div>
<div class="na-mask na-mask-round4$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 100 170" preserveAspectRatio="none meet" width="30%" height="170px">
		<path fill="$fill" d="M 0 100 L 100 100 L 0 10 Z" />
	</svg>
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 100 170" preserveAspectRatio="none meet" width="70%" height="170px">
		<path fill="$fill" d="M 0 100 L 100 100 L 100 10 Z" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "round5") {

echo <<<HTMLCODE
<div class="na-mask-round5 mask-zone mask-height"></div>
<div class="na-mask na-mask-round5$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 100 170" preserveAspectRatio="none meet" width="70%" height="170px">
		<path fill="$fill" d="M 0 100 L 100 100 L 0 10 Z" />
	</svg>
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 100 170" preserveAspectRatio="none meet" width="30%" height="170px">
		<path fill="$fill" d="M 0 100 L 100 100 L 100 10 Z" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "brush1") {

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-brush1 mask-zone mask-height"></div>
<div class="na-mask na-mask-brush1$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 2560 16" width="2560px" height="16px" version="1.1"> 
		<defs> 
			<pattern id="$id" patternUnits="userSpaceOnUse" x="0" y="0" width="400px" height="16px"> 
				<path fill="$fill" d="M 246.9 3.7 V 2.6 c -1 -0.6 -2 -1.2 -3.5 -0.9 C 244.4 2.9 245.8 2.8 246.9 3.7 Z M 247 2.5 C 247 2.5 246.9 2.5 247 2.5 L 247 2.5 c -0.1 0.1 -0.1 0.1 0 0.1 C 247 2.6 247 2.6 247 2.5 Z M 234 1.7 c 0.8 0.4 1.4 0.7 2.1 1.1 C 235.3 1.5 235.3 1.5 234 1.7 Z M 247 2.5 c 0.3 -0.2 0.6 -0.4 1 -0.6 C 246.9 1.4 247.1 2.1 247 2.5 Z M 241.2 2.8 c -0.5 -0.1 -0.9 -0.1 -1.4 -0.2 C 240.3 3.3 240.3 3.3 241.2 2.8 Z M 239.8 2.6 C 239.8 2.6 239.8 2.5 239.8 2.6 C 239.8 2.5 239.8 2.5 239.8 2.6 C 239.7 2.5 239.7 2.5 239.8 2.6 C 239.8 2.6 239.8 2.6 239.8 2.6 Z M 239.9 1.4 h -2.5 c 0 0.2 0 0.3 -0.1 0.4 c 0.8 0.2 1.6 0.4 2.4 0.7 C 239.8 2.2 239.8 1.8 239.9 1.4 Z M 282.3 2.6 h -2.8 C 280.6 3.6 281.4 2.9 282.3 2.6 Z M 336.5 4.6 c 1.1 0.1 2.2 0.2 3.2 0.3 c -0.3 -0.5 -0.7 -0.9 -1.2 -1 c -1.7 -0.1 -3.4 0 -5.1 0 c 0 0.2 0 0.4 0 0.6 C 334.5 4.5 335.5 4.5 336.5 4.6 Z M 264.4 2.6 c -0.1 -0.1 -0.3 -0.3 -0.4 -0.3 c -0.2 0 -0.4 0.2 -0.5 0.3 c 0.1 0.1 0.2 0.3 0.5 0.5 C 264 2.9 264.2 2.7 264.4 2.6 Z M 262.9 4.2 c -0.3 -0.7 -0.5 -1.4 -0.7 -2 h -6.2 c 1.4 0.4 3.1 0.7 4.5 1.5 C 261.3 4.2 261.9 4.3 262.9 4.2 Z M 275.1 3.7 c 0.1 0 0.5 -0.3 0.5 -0.5 c 0 -0.2 -0.3 -0.5 -0.5 -0.5 c -0.2 0 -0.4 0.3 -0.6 0.5 C 274.8 3.4 274.9 3.7 275.1 3.7 Z M 400 4.1 V 3.6 c -1.1 0.2 -2.3 0 -3.5 0.1 c -0.5 0 -1.1 -0.3 -1.6 -0.3 c -1 -0.1 -1.9 0 -2.9 0 c -0.3 1.2 0.9 1.1 1.5 1.5 c -0.1 0.1 -0.1 0.2 -0.2 0.2 h -2.7 c 0.8 0 1.6 0.4 2.4 0.5 c -1.4 3 -14.6 1.4 -17.5 1.2 c -3.5 -0.3 -7.1 -0.1 -10.7 -0.2 c -3.8 -0.1 -7.5 -0.3 -11.3 -0.3 c -2.6 0 -5.2 0.1 -7.8 0 c -5.1 -0.1 -10.2 -0.3 -15.3 -0.4 c -2.4 -0.1 -4.8 -0.1 -7.3 -0.2 c -0.2 0 -0.4 -0.2 -0.6 -0.3 c 3.1 0.2 6 -0.1 9 -0.4 c 0.9 -0.1 1.1 -0.4 0.7 -1.3 h -19.8 c 0 0.2 0 0.3 0 0.5 c 2.8 0.9 5.9 0.2 8.8 1.1 c -4.4 0.7 -8.8 0 -13.2 0.4 c 0.5 -1.2 0.2 -1.9 -1 -2 c -1.9 -0.2 -3.8 -0.3 -5.6 -0.4 c -2.5 -0.2 -5 -0.4 -7.6 -0.5 c -0.8 0 -1.5 0.2 -2.3 0.2 c 0 0.2 0 0.3 -0.1 0.5 c 0.5 0.3 0.9 0.6 1.4 0.8 c 1.5 0.7 3.2 0.4 4.8 0.4 c 1.1 0 2.4 -0.5 3 0.9 c 0 0 0 0 0 0 h 0.1 c 1.7 -0.8 3.4 -0.5 5.1 0 h -5.1 c 0 0 -0.1 0 -0.1 0 c 0 0 0 0 0 0 c -0.5 0 -1 0.1 -1.5 0.1 c -3.1 0 -6.3 0 -9.4 -0.1 c -4.9 -0.1 -9.8 -0.2 -14.7 -0.3 c -4.1 0 -8.2 0 -12.4 0 c -0.7 0 -1.7 0.1 -2 -0.3 c -0.9 -0.9 -1.4 -0.4 -2.3 0 c -0.7 0.3 -1.7 -1.1 -2.3 -0.5 c -1 1 -2.1 0.6 -3 0.5 c -4.6 -0.2 -9.2 -0.7 -13.8 -0.6 c -2.3 0.1 -4.4 -1.2 -6.7 -0.7 c -0.1 0 -0.2 -0.2 -0.4 -0.2 c -1.1 -0.2 -2.1 -0.3 -3.2 -0.5 c 0 0.1 0 0.1 0 0.2 c 0.3 0.1 0.6 0.2 1.1 0.5 c -2.8 0 -5.3 0 -7.8 0 c -0.4 0 -0.7 -0.5 -1.1 -0.6 c -0.7 -0.2 -1.6 -0.5 -2.3 -0.2 c -1.8 0.7 -2.2 0.9 -2.9 0.4 c -2 -1.2 -2.2 -1.2 -4.2 -0.3 c 0.8 0.1 1.7 0.2 2.6 0.2 c -0.9 0.4 -1.8 0.6 -2.7 0.6 c -1.8 0 -3.6 -0.2 -5.5 -0.1 c -3 0 -6 0.2 -9 0.3 c -0.3 0 -0.7 -0.2 -1 -0.2 c -0.6 -0.2 -1.3 -0.5 -1.9 -0.4 c -1.7 0 -3.5 0.4 -5.2 0.4 c -2.4 0 -4.8 -0.1 -7.3 -0.2 c -0.8 0 -1.5 -0.1 -2.3 -0.1 c -1.5 0 -3 0.2 -4.6 0.2 c -1 0 -2 0 -2.8 0.9 c 2.1 0 4 0 5.9 0 c 10.7 0.1 21.4 0.2 32 0.4 c 4.3 0.1 8.6 0.3 12.8 0.5 c 5.7 0.2 11.4 0.5 17 0.8 c 2 0.1 4.1 0.1 6.1 0.2 c 8.1 0.2 16.3 0.5 24.4 0.7 c 3 0.1 6 0 9 0 c -0.6 0.5 -1.3 0.8 -1.9 0.8 c -2.8 0.1 -5.7 -0.2 -8.5 0.3 c -0.5 0.1 -1.1 0 -1.6 0 c -6.2 -0.1 -12.4 -0.2 -18.7 -0.4 c -4.6 -0.2 -9.2 -0.4 -13.8 -0.7 c -4.5 -0.2 -8.9 -0.5 -13.4 -0.7 c -3.8 -0.2 -7.6 -0.2 -11.5 -0.3 c -0.5 0 -1 0 -1.5 0.1 c -0.9 0 -1.8 0.2 -2.7 0.1 c -2.2 -0.1 -4.3 -0.3 -6.5 -0.4 c -1.6 -0.1 -3.2 0.1 -4.9 0 c -1.5 -0.1 -2.8 0 -4.3 0.3 c -1.5 0.2 -3.1 0.3 -4.5 -0.2 c -1.1 -0.4 -2 -0.3 -3 0 c -0.5 0.2 -1.4 0.4 -1.5 0.2 c -0.6 -0.9 -1.4 -0.5 -2.1 -0.5 c -3.2 0 -6.3 0.3 -9.5 0.2 c -2.9 0 -5.8 -0.4 -8.7 -0.4 c -3.8 0 -7.7 -0.2 -11.5 0 c -0.8 0 -1.7 0 -2.5 -0.1 c -1.5 -0.1 -3.2 -0.5 -4.6 -0.2 c -1.6 0.3 -3.2 -0.7 -4.7 0.3 c -0.1 0.1 -0.5 -0.2 -0.8 -0.2 c -0.6 -0.2 -1.2 -0.4 -1.8 -0.4 c -5.7 -0.2 -11.3 -0.3 -17 -0.4 c -9.4 -0.2 -18.8 -0.4 -28.3 -0.6 c -0.2 0 -0.4 0 -0.6 0 c -2.6 -0.1 -5.3 -0.2 -7.9 -0.2 c -3 0 -6.1 0.2 -9.2 0.3 c -3.1 0 -6.3 0 -9.4 0 c -1.3 0 -2.6 -0.1 -4 -0.2 c -1.6 0 -3.3 0 -4.9 0 c -0.8 0 -1.5 0 -2.3 0.1 c -0.7 0 -1.4 0.2 -2.1 0.2 c -2.4 -0.2 -4.7 -0.4 -7.1 -0.1 c -2.4 0.2 -4.9 -0.1 -7.4 0 c -3.6 0.1 -7.3 0 -10.8 0.6 c -0.2 0 -0.5 -0.1 -0.8 -0.1 c -0.6 -0.1 -1.2 -0.2 -1.8 -0.4 c -0.3 -0.1 -0.5 -0.3 -0.7 -0.5 C 21 3.2 21 3.1 21 2.9 c 2.3 -0.1 4.5 -0.2 6.8 -0.2 c 1.2 0 2.3 0 3.5 -0.2 c 0.5 -0.1 0.9 -0.7 1.6 -1.3 c -1.8 0 -3.6 -0.1 -5.3 0 c -6.5 0.3 -13 0.7 -19.5 1 C 7 2.3 5.8 2.4 4.6 2.5 c -1.1 0.1 -2 -0.1 -3.2 0.6 C 1 3.4 0.5 3.5 0 3.6 v 0.5 c 1.5 0 3.1 0 4.8 -0.4 C 4.4 4.2 4.3 4.5 4.2 4.5 C 2.8 4.6 1.4 4.7 0 4.8 V 16 h 400 V 4.8 c -1.5 0.1 -3 0.2 -4.5 0.2 c 0 -0.2 0 -0.3 0 -0.4 C 397 4.1 398.5 4.1 400 4.1 Z M 12.1 2.8 h -1.5 V 2.7 h 1.5 V 2.8 Z M 324.5 7.7 c -0.2 0 -0.3 -0.2 -0.7 -0.5 h 11.5 c 0 0.1 0 0.2 0 0.3 C 331.7 7.6 328.1 7.7 324.5 7.7 Z M 337.3 7.4 c 1.8 -0.2 3.7 -0.9 5.6 0 H 337.3 Z M 117.3 2.7 c -0.1 -0.1 -0.2 -0.3 -0.3 -0.3 c -1.8 0.2 -3.4 -0.5 -5.2 -0.5 c -1.7 0.1 -3.4 0.3 -5.1 0.2 c -2.3 -0.1 -4.5 0 -6.8 0 c 5.8 0.3 11.5 1 17.3 1 C 117.3 3.1 117.3 2.9 117.3 2.7 Z M 97.9 2.5 c -0.7 -0.3 -1.2 -0.5 -1.7 -0.7 c -1.4 -0.7 -2.8 -1 -4.4 -0.7 c -1.7 0.4 -3.5 0.4 -5.3 0.4 c -1 0 -2 -0.3 -3 -0.4 C 82.2 1 80.8 0.8 79.4 1 c -1.3 0.2 -2.5 0.3 -3.8 0.2 c -1.4 -0.2 -2.8 -0.4 -4.3 0.1 c -1.3 0.4 -2.9 -0.2 -4.4 -0.3 c -0.3 0 -0.6 -0.1 -0.8 0 c -0.3 0.1 -0.5 0.4 -0.8 0.6 c 0 0.1 0.1 0.2 0.2 0.4 C 76.2 2.2 87 2.4 97.9 2.5 Z M 121.1 3.3 c 2.2 0 4.3 0 6.5 0.2 c 4.2 0.4 8.3 0.8 12.6 -0.3 c -0.8 -0.2 -1.5 -0.7 -2.3 -0.7 c -1.8 -0.1 -3.6 -0.1 -5.4 -0.1 c 0 0 -0.1 0 -0.2 0.1 c -1 1.1 -2.3 0.7 -3.4 0.5 c -3 -0.5 -6 0.5 -9 -0.2 c -0.3 -0.1 -0.7 0.2 -1.5 0.6 C 119.6 3.3 120.3 3.3 121.1 3.3 Z M 36.3 2.4 c 0.2 0 0.3 -0.1 0.5 -0.2 c -0.2 -0.2 -0.3 -0.4 -0.5 -0.5 C 36.2 1.8 36.1 2 36 2.1 C 36 2.2 36.2 2.4 36.3 2.4 Z M 149 3.8 c 1.2 -0.1 2.3 0.9 4 -0.3 c -0.9 -0.1 -1.4 -0.3 -1.9 -0.2 c -1.9 0.2 -3.7 0.2 -5.6 -0.2 c -1.3 -0.3 -2.9 -0.5 -4.5 0.8 h 4 C 146.3 3.8 147.7 3.9 149 3.8 Z M 45.4 2.3 c 1.7 -0.7 3.2 -0.2 4.7 -0.3 c 1.1 0 2.2 0.2 3.3 0 c 2 -0.4 3.8 -0.4 5.8 -0.1 c 1.6 0.2 3.3 0.4 5 -0.4 c -0.2 -0.1 -0.4 -0.2 -0.6 -0.2 c -2.9 0.3 -5.9 -0.3 -8.8 0 c -0.6 0.1 -1.2 -0.1 -1.9 -0.1 c -2.4 0 -4.9 -0.2 -7.3 0 c -1.6 0.1 -3.1 0.6 -4.6 -0.2 c -0.1 0 -0.2 0.1 -0.5 0.2 c 0.1 0.3 0.2 0.6 0.3 0.9 C 42.5 2.2 44.2 2.8 45.4 2.3 Z M 203.9 3 c -1.1 -0.2 -2 -0.3 -3 -0.5 C 201.8 3.1 202.6 3.9 203.9 3 Z M 220.9 1.5 c 0 -0.1 0 -0.2 -0.1 -0.2 c -0.3 -0.1 -0.6 -0.2 -1 -0.3 c 0 0.1 -0.1 0.2 -0.1 0.3 c 0.3 0.1 0.7 0.2 0.9 0.3 C 220.8 1.6 220.9 1.6 220.9 1.5 Z M 203.7 1 c -0.4 -0.2 -0.8 -0.4 -1.3 -0.7 c -0.1 0.1 -0.1 0.2 -0.2 0.3 c 0.4 0.2 0.8 0.4 1.2 0.7 C 203.6 1.2 203.7 1.1 203.7 1 Z M 232.9 1.6 c -0.7 -0.3 -1.5 -0.5 -2.2 -0.8 c -0.1 0.2 -0.1 0.4 -0.2 0.6 c 0.7 0.4 1.4 0.8 2.4 1.4 C 232.9 2.2 233 1.6 232.9 1.6 Z M 191.4 0.9 c -1 -0.3 -2 -0.6 -2.9 -0.9 c 0 0.2 -0.1 0.4 -0.1 0.6 C 189.3 0.9 190.2 1.8 191.4 0.9 Z M 170.9 4.3 c 0 -0.2 0 -0.3 0 -0.5 c -0.9 -0.1 -1.8 -0.4 -2.7 -0.4 c -0.8 0 -1.6 0.2 -2.4 0.1 c -1.4 0 -2.8 -0.2 -4.1 -0.2 c -2.4 0 -4.7 -0.1 -7.1 -0.1 c -0.4 0 -0.8 0.2 -1.2 0.4 c 0.1 0.2 0.1 0.4 0.2 0.6 H 170.9 Z" /> 
			</pattern>
		</defs>
		<rect fill="url(#$id)" x="0" y="0" width="100%" height="16px" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "brush2") {

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-brush2 mask-zone mask-height"></div>
<div class="na-mask na-mask-brush2$rev">
	<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 2560 16" width="2560px" height="16px" version="1.1">
		<defs>
			<pattern id="$id" patternUnits="userSpaceOnUse" x="0" y="0" width="400" height="16px">
				<path fill="$fill" fill-rule="inherit" d="M 74.6 2.3 c -0.4 0 -0.7 0 -1.1 -0.1 v 0.2 C 73.9 2.4 74.2 2.4 74.6 2.3 L 74.6 2.3 Z M 379.4 7.3 c 0.5 0.1 1.1 0.1 1.7 0 c 3.3 -0.2 6.6 -0.1 9.9 0 c 2.5 0 5.1 -0.2 7.6 -0.1 c 0.5 0 0.9 0 1.4 0 V 4.5 c -2.4 0 -4.8 0 -7.2 0 c -1.1 0 -2.2 -0.1 -3.3 -0.1 C 381.7 4 373.8 3.7 366 3.5 c -5.4 -0.2 -10.9 -0.3 -16.3 -0.4 c -4.9 -0.1 -9.9 -0.3 -14.8 -0.4 c -5.6 -0.1 -11.3 0 -16.9 -0.2 C 312 2.4 306 2.2 299.9 1.9 c -5.6 -0.3 -11.2 -0.7 -16.8 -0.8 c -4.8 -0.2 -9.6 -0.1 -14.3 0 c -6.2 0.1 -12.4 0.4 -18.6 0.6 c -5 0.2 -9.9 0.4 -14.9 0.4 c -4.9 0 -9.8 -0.3 -14.6 -0.5 C 215.3 1.4 210 1 204.7 0.7 c -6.6 -0.3 -13.1 -0.6 -19.7 -0.7 c -4.2 0 -8.4 0.2 -12.6 0.4 c -1.1 0 -2.3 0.2 -3.4 0.2 c -1.2 0 -2.4 0 -3.6 0 c -2.7 0 -5.4 0.9 -8.1 0.4 c -0.5 -0.1 -1 0 -1.4 0 c -2.5 0.2 -5.1 0.5 -7.6 0.5 c -4.5 0 -9 -0.3 -13.6 -0.4 c -1.1 0 -2.2 0.2 -3.3 0.1 C 129.7 1.3 128 1 126.3 1 c -3.2 -0.1 -6.4 0.1 -9.6 -0.2 c -1.2 -0.1 -2.3 -0.2 -3.4 -0.1 c -1.5 0.1 -2.9 0.2 -4.4 0.3 c -1.7 0 -3.4 -0.1 -5.1 0.1 c -2.6 0.2 -5.3 0 -7.9 0.5 c -0.2 0 -0.6 0 -0.7 -0.2 c -0.5 -0.7 -1 -0.2 -1.6 -0.2 c -2.3 0.2 -4.5 1.1 -6.8 0.5 c -0.5 -0.1 -1 0.2 -1.5 0.3 c -0.5 0.1 -1 0.4 -1.5 0.4 c -0.7 0.1 -1.3 0.1 -2 0.1 c -3.9 0 -7.8 0.7 -11.8 0.7 V 3.1 c 0.8 -0.2 1.6 -0.4 2.6 -0.7 c -1.9 -0.2 -3.5 -0.3 -5.1 -0.4 c -0.2 0 -0.5 0 -0.7 0.1 c -1.4 1 -3.1 1 -4.7 1.2 c -0.8 0.1 -1.7 0 -2.6 0 c 0 -0.1 0 -0.1 0 -0.2 c 0.5 -0.2 1.1 -0.4 1.7 -0.7 c -0.8 -1.1 -1.7 -0.5 -2.4 -0.2 c -1.2 0.6 -2.4 0.7 -3.7 0.7 c -0.1 -0.4 -0.2 -0.7 -0.4 -1.3 c -0.5 0.2 -1.1 0.5 -1.6 0.7 c -0.4 0.2 -0.8 0.5 -1.3 0.5 C 51 3 50.1 3 49.2 3 c -0.1 -0.2 -0.2 -0.5 -0.4 -1.1 c -1.8 1.4 -3.9 1.3 -5.9 1.7 C 43 3.3 43 3 43.1 2.8 c -1.8 -0.1 -1.8 -0.1 -2.2 1.5 c -1.6 0.1 -0.9 0.4 -2.6 0.5 C 36.5 5 34.1 3 33.5 4.7 c -2.7 -0.1 -5.4 -0.2 -8.1 -0.3 c -2.8 -0.2 -5.6 -0.2 -8.4 -0.3 c -3.2 -0.2 -6.3 0.6 -9.5 0.5 C 5 4.5 2.5 4.5 0 4.5 v 2.8 c 3 0.1 6 0.3 9 0.5 c 1.1 0 2.2 0.1 3.3 0.3 C 8.2 8 4.1 8.1 0 8.1 V 16 h 400 V 8.1 c -8.9 0.1 -17.8 0.2 -26.7 -0.5 C 375.3 7.3 377.4 6.8 379.4 7.3 Z M 17.7 8.1 h -2.1 V 8 L 17.7 8.1 L 17.7 8.1 Z M 30.7 8.4 h -0.9 V 8.2 h 0.9 V 8.4 Z M 68 2.9 c 0 0.1 0 0.2 0 0.3 c -0.5 0 -1 -0.1 -1.6 -0.1 C 66.9 3 67.5 2.9 68 2.9 Z M 211.7 5.5 c -1.5 -0.1 -3 -0.2 -4.5 -0.2 c -5.6 -0.3 -11.1 -0.5 -16.7 -0.2 c -3.4 0.2 -6.8 0.1 -10.3 0.2 c -7.6 0.3 -15.1 0.7 -22.7 0.9 c -4.2 0.1 -8.5 0.1 -12.7 0 c -5 0 -10.1 -0.2 -15.1 -0.2 c -8.4 0 -16.9 0 -25.3 0 c -3.9 0 -7.8 0.2 -11.7 0.3 c -8.6 0.1 -17.2 0.2 -25.8 0.3 c -5.5 0.1 -11 0.1 -16.5 0.2 c -1.3 0 -2.7 0.2 -4.1 0.3 h -0.1 c 0.4 -1.5 0.8 -1.2 2.2 -1.2 c 2.9 -0.2 5.9 -0.3 8.8 -0.4 c 3.5 -0.1 7.1 0 10.6 0 c 1.9 0 3.7 0.2 5.6 0.3 c 0.6 0 1.2 -0.3 1.8 -0.3 c 2.8 0 5.6 -0.7 8.3 -0.7 c 0.8 0 1.7 -0.1 2.6 -0.2 c 2 -0.1 4.1 -0.2 6.2 -0.3 c 2.1 -0.1 4.1 -0.1 6.2 0 c 3.5 0 7.1 0.1 10.6 0.1 c 4.4 0 8.8 -0.1 13.2 0 c 3.6 0.1 7.1 0.4 10.6 0.5 C 136.5 5 140 5 143.6 5 c 1.4 0 2.7 -0.3 4.1 -0.5 c 0.1 0 0.3 0 0.4 0 c 3.2 0.7 6.3 -0.2 9.4 -0.3 c 3.1 -0.1 6.2 -0.1 9.3 -0.2 c 1 0 2.1 -0.1 3.1 -0.2 c 2.4 -0.1 4.9 -0.3 7.3 -0.3 c 4.6 0 9.2 0 13.9 0.2 c 2 0.1 4 0.6 5.9 0.7 c 1.7 0.2 3.4 0.2 5.1 0 c 2.3 -0.2 4.5 0.2 6.7 0.4 c 0.9 0 1.8 0.2 2.8 0.3 C 211.7 5.2 211.7 5.4 211.7 5.5 Z M 213.2 5.6 c 0.7 -0.5 1 -0.6 1.7 -0.6 c 3.2 0.2 6.4 0.3 9.6 0.4 c 2.3 0.1 4.6 0.2 6.9 0.1 c 3 0 6.1 -0.1 9.1 -0.2 c 3.8 -0.2 7.7 -0.5 11.5 -0.7 c 3.6 -0.2 7.2 -0.3 10.8 -0.4 c 0.6 0 1.2 0.1 1.8 0.1 c 1 0 2 0 3.1 0 c 1 0 2.1 0.1 3.1 0.2 c 0.8 0.1 1.5 0.4 2.5 0.7 C 253.3 6.6 233.4 7.5 213.2 5.6 Z M 307.6 6.4 c 0 -0.2 0 -0.4 0 -0.6 c 1.2 0.1 2.5 0.2 3.7 0.4 c 1.1 0.2 2.2 -1.1 3.3 0.2 H 307.6 Z M 318 6.7 c 0 -0.1 0 -0.3 -0.1 -0.4 c 0.2 -0.1 0.4 -0.3 0.6 -0.3 c 0.3 0 0.7 0.3 1 0.4 c 2 0.1 3.9 0.2 5.8 0.2 c 1.6 0 3.3 -0.2 4.9 -0.3 c 0.5 0 1 0.1 1.5 0.3 C 327.1 6.7 322.6 7.4 318 6.7 Z M 358.3 7.4 c -2.8 0 -5.5 0.1 -8.3 0.1 c -2.8 0 -5.5 0.1 -8.3 -0.6 c 2.2 -0.6 4.6 -1.5 6.7 -0.8 c 2.1 0.7 4.1 0.5 6.2 0.7 c 1.2 0.1 2.4 0.1 3.6 0.2 V 7.4 Z M 359.9 7.4 V 7.1 h 4.6 c 0 0.1 0 0.2 0 0.4 H 359.9 Z" /> 
			</pattern>
		</defs>
		<rect fill="url(#$id)" x="0" y="0" width="100%" height="16px" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "special1") {

		$id = na_rid(); 

echo <<<HTMLCODE
<div class="na-mask-special1 mask-zone mask-height"></div>
<div class="na-mask na-mask-special1$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="mask-svg" viewBox="0 0 2700 64" width="2700px" height="64px" version="1.1">
		<defs>
			<filter id="$id" x="-50%" y="-50%" width="200%" height="200%" filterUnits="objectBoundingBox">
				<feOffset result="shadowOffsetInner1" in="SourceAlpha" dx="0" dy="2" />
				<feGaussianBlur result="shadowBlurInner1" in="shadowOffsetInner1" stdDeviation="1.5" />
				<feComposite result="shadowInnerInner1" in="shadowBlurInner1" in2="SourceAlpha" operator="arithmetic" k2="-1" k3="1" />
				<feColorMatrix result="shadowMatrixInner1" in="shadowInnerInner1" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.45 0" />
				<feMerge>
					<feMergeNode in="SourceGraphic" />
					<feMergeNode in="shadowMatrixInner1" />
				</feMerge>
			</filter>
		</defs>
		<path filter="url(&quot;#$id&quot;)" fill="$fill" d="M 1892 0 L 2119 44.993 L 2701 45 L 2701.13 63.993 L -0.16 63.993 L 1.73847e-012 45 L 909 44.993 L 1892 0 Z" />
		<path filter="url(&quot;#$id&quot;)" fill="$color" d="M 2216 44.993 L 2093 55 L 1882 6 L 995 62 L 966 42 L 1892 0 L 2118 44.993 L 2216 44.993 L 2216 44.993 Z" />
	</svg>
</div>
HTMLCODE;

	} else if($mask == "special2") {

		$id = na_rid();

echo <<<HTMLCODE
<div class="na-mask-special2 mask-zone mask-height"></div>
<div class="na-mask na-mask-special2$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="mask-svg" viewBox="0 0 2700 57" width="2700px" height="57px" version="1.1">
		<defs>
			<filter id="$id" x="-50%" y="-50%" width="200%" height="200%" filterUnits="objectBoundingBox">
				<feOffset result="shadowOffsetOuter1" in="SourceAlpha" dx="0" dy="-2" />
				<feGaussianBlur result="shadowBlurOuter1" in="shadowOffsetOuter1" stdDeviation="2" />
				<feColorMatrix result="shadowMatrixOuter1" in="shadowBlurOuter1" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.5 0" />
				<feMerge>
					<feMergeNode in="shadowMatrixOuter1" />
					<feMergeNode in="SourceGraphic" />
				</feMerge>
			</filter>
		</defs>
		<g transform="translate(-1 10)">
			<path fill="$color" d="M 0.455078 18.5 L 1 47 L 392 47 L 1577 35 L 392 17 L 0.455078 18.5 Z" />
			<path fill="$fill" filter="url(&quot;#$id&quot;)" d="M 2701 0.313494 L 2701 47.235 L 2312 47 L 391 47 L 2312 0 L 2701 0.313494 Z" />
		</g>
	</svg>
</div>
HTMLCODE;

	} else if($mask == "special3") {

echo <<<HTMLCODE
<div class="na-mask-special3 mask-zone mask-height"></div>
<div class="na-mask na-mask-special3$rev">
	<svg xmlns="https://www.w3.org/2000/svg" class="na-mask mask-fill" viewBox="0 0 767 60" preserveAspectRatio="none meet" width="767px" height="60px" version="1.1">
		<polygon fill="$color" points="767,0 767,50 0,60" />
	</svg>
	<svg xmlns="https://www.w3.org/2000/svg" class="na-mask mask-over" viewBox="0 0 767 50" preserveAspectRatio="none meet" width="767px" height="50px" version="1.1">
		<polygon fill="$fill" points="767,0 767,50 0,50" />
	</svg>
</div>
HTMLCODE;
	}
}