<?php
// emoji.php

// 이모티콘 기본 폴더 경로 설정
$emojiDir = __DIR__;

// 지원할 이미지 확장자
$allowedExtensions = ['png', 'jpg', 'jpeg', 'gif'];

// 그룹화된 이모티콘 배열 초기화
$groupedEmojis = [];

// 폴더 내의 모든 하위 디렉토리 가져오기
$subDirs = array_filter(glob($emojiDir . '/*'), 'is_dir');

foreach ($subDirs as $subDir) {
    $subDirName = basename($subDir); // 하위 디렉토리 이름 추출
    $groupedEmojis[$subDirName] = []; // 그룹 초기화

    // 하위 디렉토리 내의 파일 목록 가져오기
    $files = scandir($subDir);
    
    foreach ($files as $file) {
        $filePath = $subDir . '/' . $file;
        if (is_file($filePath)) {
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            if (in_array($ext, $allowedExtensions)) {
                // 도메인과 경로를 포함한 이미지 URL 생성
                $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || 
                             $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
                $domain = $_SERVER['HTTP_HOST'];
                $imageUrl = $protocol . $domain . dirname($_SERVER['REQUEST_URI']) . '/' . $subDirName . '/' . $file;

                // 그룹에 이미지 추가
                $groupedEmojis[$subDirName][] = $imageUrl;
            }
        }
    }
}

// JSON 형식으로 출력
header('Content-Type: application/json');
echo json_encode($groupedEmojis);
?>
