<?php
// 현재 디렉토리 경로
$directory = __DIR__ . '/data'; // data 폴더 경로

// 파일 삭제 기준 시간(7일)
$delete_time = time() - (7 * 24 * 60 * 60);

// 재귀적으로 디렉토리 내의 파일 삭제
function deleteOldFiles($dir, $delete_time) {
    // 디렉토리 내의 파일 및 폴더 목록 가져오기
    $users = scandir($dir);

    foreach ($users as $user) {
        // 현재 사용자 폴더 경로
        $user_path = $dir . '/' . $user;

        // '.' 및 '..' 디렉토리 건너뛰기
        if ($user === '.' || $user === '..' || !is_dir($user_path)) {
            continue;
        }

        // 사용자 폴더 내의 날짜 형식 폴더 가져오기
        $dates = scandir($user_path);

        foreach ($dates as $date) {
            // 날짜 폴더 경로
            $date_path = $user_path . '/' . $date;

            // 날짜 형식인지 확인
            if ($date === '.' || $date === '..' || !is_dir($date_path) || !preg_match('/^\d{8}$/', $date)) {
                continue;
            }

            // 날짜와 비교
            $folder_time = strtotime($date);
            if ($folder_time < $delete_time) {
                // 날짜 폴더와 그 안의 파일 삭제
                array_map('unlink', glob("$date_path/*.*"));
                rmdir($date_path);
                echo "Deleted folder and files: " . $date_path . "\n";
            }
        }
    }
}

// 데이터 디렉토리 내의 오래된 파일 삭제
deleteOldFiles($directory, $delete_time);
?>