<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 썸네일 크기 수정
$thumb_width = 300; // 너비
$thumb_height = 200; // 높이
?>

<div class="latest_wrap">
    <?php
    for ($i=0; $i<count($list); $i++) {
    $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

    if($thumb['src']) {
        $img = $thumb['src'];
    } else {
        $img = $latest_skin_url.'/img/noimg.png';
        $thumb['alt'] = '등록된 이미지가 없습니다.';
    }
    $img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
    ?>

    <div class="latest_item" onclick="location.href='<?php echo $list[$i]['href'] ?>';" style="cursor: pointer;">
        <div class="latest_info">
            <div class="latest_member_id">
                <?php echo $list[$i]['name'] ?>
            </div>
            <div class="latest_subject">
                <?php echo $list[$i]['subject'] ?>
            </div>
            <div class="latest_content">
                <?php echo cut_str(strip_tags($list[$i]['wr_content']), 80)?>
            </div>
        </div>
        <div class="latest_img">
            <?php echo $img_content; ?>
        </div>
    </div>

    <?php }  ?>
    <?php if (count($list) == 0) { //게시물이 없을 때  ?>
    <div class="latest_item">
        <div class="latest_content">
            등록된 게시물이 없습니다.
        </div>
    </div>
    <?php }  ?>
</div>

<style>
/* 전체 피드 구성 */
.latest_wrap {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 20px;
}

.latest_item {
    display: flex;
    flex-direction: row;
    width: 100%;
    max-width: 800px; /* 최대 너비 설정 */
    min-height: 200px; /* 고정 높이 설정 */
    background-color: #fff;
    border-radius: 10px;
    overflow: hidden;
    transition: transform 0.3s ease;
}

.latest_item:hover {
    transform: scale(1.05);
}

/* 텍스트 및 이미지 스타일 */
.latest_info {
    flex: 1;
    padding: 10px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.latest_member_id {
    font-family: 'Montserrat', sans-serif;
    font-weight: bold;
    margin-bottom: 5px;
}

.latest_subject {
    font-size: 1.4em;
    margin-bottom: 5px;
}

.latest_content {
    font-family: 'Roboto', sans-serif;
    font-size: 14px;
    color: #3a3a3a;
}

/* 이미지 스타일 */
.latest_img {
    flex: 0 0 300px; /* 고정 너비 */
    height: 100%; /* 부모 요소 높이에 맞춤 */
}

.latest_img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* 미디어 쿼리 */
@media (max-width: 768px) {
    .latest_item {
        flex-direction: column; /* 모바일에서는 세로로 배치 */
        align-items: center;
    }

    .latest_img {
        flex: none;
        width: 100%; /* 전체 너비 사용 */
        height: auto; /* 비율에 따라 높이 조정 */
    }
}
</style>