<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 썸네일 크기 수정
$thumb_width = 300; // 썸네일 너비
$thumb_height = 200; // 썸네일 높이
?>

<div class="latest_wrap">
    <?php
    for ($i=0; $i<count($list); $i++) {
        $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

        if($thumb['src']) {
            $img = $thumb['src'];
        } else {
            $img = $latest_skin_url.'/img/noimg.png';
            $thumb['alt'] = '등록된 이미지가 없습니다.';
        }
        $img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
    ?>

    <div class="latest_item" onclick="location.href='<?php echo $list[$i]['href'] ?>';" style="cursor: pointer;">
        <div class="latest_info">
            <div class="latest_member_id">
                <?php echo $list[$i]['name'] ?>
            </div>
            <div class="latest_subject">
                <?php echo $list[$i]['subject'] ?>
            </div>
            <div class="latest_content">
                <?php echo cut_str(strip_tags($list[$i]['wr_content']), 80)?>
            </div>
        </div>
        <div class="latest_img">
            <?php echo $img_content; ?>
        </div>
    </div>

    <?php } ?>
    <?php if (count($list) == 0) { //게시물이 없을 때 ?>
    <div class="latest_item">
        <div class="latest_content">
            등록된 게시물이 없습니다.
        </div>
    </div>
    <?php } ?>

</div>

<style>
.latest_wrap {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 20px;
    margin: 10px;
    margin-bottom: 70px;
}

.latest_item {
    display: flex;
    width: 100%;
    max-width: 800px; /* 최대 너비 설정 */
    min-height:200px;
    height:27%;
    max-height:320px;
    border: 1px solid #f2f2f2;
    border-radius: 10px;
    overflow: hidden;
    background-color: #fff;
    transition: transform 0.3s ease;
}

.latest_item:hover {
    transform: scale(1.02);
}

.latest_info {
    flex-grow: 1;
    padding: 10px;
    width: 66.67%; /* 텍스트 영역이 2/3 차지 */
}

.latest_member_id, .latest_subject, .latest_content {
    margin-bottom: 10px;
}

.latest_member_id {
    font-family: 'Montserrat', sans-serif;
    font-weight: bold;
}

.latest_subject {
    font-size: 1.4em;
    font-family: 'Montserrat', sans-serif;
    font-weight: bold;
}

.latest_content {
    font-family: 'Roboto', sans-serif;
    font-size: 14px;
    color: #3a3a3a;
}

/* 썸네일 이미지 스타일 */
.latest_img {
    flex-shrink: 0; /* 이미지가 줄어들지 않도록 설정 */
    width: 45%; /* 이미지가 화면의 1/3 차지 */
    min-height:100%;
    max-width:100%;
    overflow: hidden;
}

.latest_img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 10px; /* 이미지 모서리 둥글게 */
    filter: brightness(1.1) contrast(1.1); /* 필터 적용 */
}

.latest_member_id img {
border-radius:50%;
}
</style>

<script>
    document.querySelectorAll('.latest_item').forEach(item => {
        item.addEventListener('click', () => {
            item.classList.toggle('active');
        });
    });
</script>