<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
$member = get_member($mb_id);
$mb_nick = $member['mb_nick'];
?>
<div class="hd_menu"><!--2-->

    <div class="logo"><!--로고-->
        <a href="<?php echo G5_URL ?>">
            <img src="<?php echo G5_THEME_IMG_URL ?>/logo.png" alt="<?php echo $config['cf_title']; ?>">
        </a>
    </div>
    <div class="title">
    <a href="<?php echo G5_BBS_URL ?>/profile.php?mb_id=<?php echo $mb_id; ?>">
        <span style="font-weight:520;font-size:20px;color:#2a2a2a;"><?php echo $mb_nick; ?></span>
    </a>
    </div>
    <div class="menu-items">
        <span class="send_memo"><!--1:1채팅-->
            <a href="<?php echo G5_BBS_URL ?>/memo.php">
                <i class="fa fa-send-o" style="font-size:25px;color:#2a2a2a;margin-right:5px"></i>
            </a>
        </span>
    </div>
</div><!--2-->

<style>
body {
    font-family: 'Arial', sans-serif;
    margin: 0;
    padding: 0;
}

.hd_menu {
    display: flex;
    justify-content: space-between;
    align-items: center;
    height: 60px;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background-color: #ffffff;
    z-index: 1000;
    padding: 10px 20px;
}

.logo img {
    height: 40px;
    width: auto;
}

.title {
    font-weight: 600;
    font-size: 22px;
    color: #2a2a2a;
}

.menu {
    display: flex;
    position: fixed;
    justify-content: space-between; /* 좌우 정렬 */
    width: 100%;
    top:60px;
    background-color:#fff;
    z-index:2
}

.menu-container {
    flex: 1; /* 각 버튼이 가로의 절반을 차지하도록 설정 */
    display: flex;
    justify-content: center; /* 중앙 정렬 */
    height:50px;
    border-bottom:1px solid #ddd
}

.menu button {
    cursor: pointer;
    border: none;
    background-color: #0000;
    color: #333;
    font-size:15px;
    width:95%;
    height:50px;
}

.menu button:hover {
    background-color: #fafafa;
    transform: scale(1.05);
    border-bottom:2px solid #2a2a2a
}

#followerList, #followingList {
    padding: 10px;
    margin-top:120px
}

#followerList div, #followingList div {
    color: #333;
    transition: background-color 0.2s; /* 항목에 hover 효과 추가 */
}

#followerList div:hover, #followingList div:hover {
    background-color: #f0f0f0; /* hover 시 배경색 변경 */
}


    .follower-container img {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        margin-right: 10px;
    }

    .follower-info {
        display: flex;justify-content: flex-start;align-items: center;padding:10px;
    }

    .follow-btn {
        background-color: #f1f1f1;
        color: #2c2c2c;
        border: none;
        border-radius: 5px;
        padding: 5px 10px;
        cursor: pointer;
        transition: background-color 0.3s;
        margin-left: 10px; /* 버튼과 닉네임 간격 */
    }

    .follow-btn.active {
        background-color: #fecc58;
        padding: 5px 10px;
        border-radius:10px;
        font-size:15px;
        font-weight:500;
        color:#fff
    }

    a {
        text-decoration: none; /* 링크의 밑줄 제거 */
        color: #3c3c3c;
        font-weight:500
    }

    a:hover {
        font-weight:530
    }
    
    button {
    transition: background-color 0.3s ease, transform 0.3s ease, border-bottom 0.3s ease;
    }
</style>
<div class="menu">
    <div class="menu-container" id="followersMenu">
        <button id="followerBtn" onclick="loadFollowers()">팔로워</button>
    </div>
    <div class="menu-container" id="followingMenu">
        <button id="followingBtn" onclick="loadFollowing()">팔로잉</button>
    </div>
</div>

<div class="followlist">
<div id="followerList" style="display:none;"></div>
<div id="followingList" style="display:none;"></div>
</div>

<script>
let startX;
const followerList = document.getElementById('followerList');
const followingList = document.getElementById('followingList');
const followerBtn = document.getElementById('followerBtn');
const followingBtn = document.getElementById('followingBtn');

// 버튼 스타일 적용 함수
function applyButtonStyle(button) {
    button.style.backgroundColor = '#fafafa';
    button.style.transform = 'scale(1.05)';
    button.style.borderBottom = '2px solid #2a2a2a';
}

// 버튼 스타일 초기화 함수
function resetButtonStyle(button) {
    button.style.backgroundColor = '';
    button.style.transform = '';
    button.style.borderBottom = '';
}

document.addEventListener('touchstart', function(e) {
    startX = e.touches[0].clientX; // 터치 시작 위치
});

document.addEventListener('touchmove', function(e) {
    const moveX = e.touches[0].clientX; // 현재 터치 위치
    const diffX = startX - moveX; // 이동 거리

    // 오른쪽에서 왼쪽으로 스와이프 시
    if (diffX > 50) { // 50px 이상 이동 시
        followerList.style.display = 'none';
        followingList.style.display = 'block';
        
        resetButtonStyle(followerBtn); // 이전 버튼 스타일 초기화
        applyButtonStyle(followingBtn); // 팔로잉 버튼 스타일 적용
        followingBtn.click(); // 팔로잉 버튼 자동 클릭
    }

    // 왼쪽에서 오른쪽으로 스와이프 시
    if (diffX < -50) { // -50px 이상 이동 시
        followingList.style.display = 'none';
        followerList.style.display = 'block';

        resetButtonStyle(followingBtn); // 이전 버튼 스타일 초기화
        applyButtonStyle(followerBtn); // 팔로워 버튼 스타일 적용
        followerBtn.click(); // 팔로워 버튼 자동 클릭
    }
});

// 페이지 로드 시 팔로워 버튼 자동 클릭
window.onload = function() {
    applyButtonStyle(followerBtn); // 자동 클릭 시 스타일 적용
    followerBtn.click(); // 페이지가 로드될 때 팔로워 버튼 클릭
};

// 클릭 이벤트로 스타일 초기화
followerBtn.addEventListener('click', function() {
    resetButtonStyle(followingBtn); // 팔로잉 버튼 스타일 초기화
});

followingBtn.addEventListener('click', function() {
    resetButtonStyle(followerBtn); // 팔로워 버튼 스타일 초기화
});
</script>
<script>
let followerPage = 1;
let followingPage = 1;
let mb_id = getQueryParameter('mb_id'); // mb_id 값을 URL에서 가져오기
let currentList = ''; // 현재 리스트 상태
let followersSet = new Set(); // 팔로워 유저 ID 집합
let followingSet = new Set(); // 팔로잉 유저 ID 집합

// URL에서 파라미터 값 가져오는 함수
function getQueryParameter(name) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}

// 팔로워 로드 함수
function loadFollowers() {
    document.getElementById('followingList').style.display = 'none'; // 팔로잉 리스트 숨기기
    const followerList = document.getElementById('followerList');
    followerList.style.display = 'block';
    followerList.innerHTML = ''; // 초기화
    followerPage = 1; // 페이지 초기화
    currentList = 'followers'; // 현재 리스트 상태 설정
    followersSet.clear(); // 집합 초기화
    loadMoreFollowers();

    // 스크롤 이벤트 등록
    window.onscroll = function() {
        if (currentList === 'followers' && (window.innerHeight + window.scrollY) >= document.body.offsetHeight) {
            loadMoreFollowers();
        }
    };
}

// 팔로잉 로드 함수
function loadFollowing() {
    document.getElementById('followerList').style.display = 'none'; // 팔로워 리스트 숨기기
    const followingList = document.getElementById('followingList');
    followingList.style.display = 'block';
    followingList.innerHTML = ''; // 초기화
    followingPage = 1; // 페이지 초기화
    currentList = 'following'; // 현재 리스트 상태 설정
    followingSet.clear(); // 집합 초기화
    loadMoreFollowing();

    // 스크롤 이벤트 등록
    window.onscroll = function() {
        if (currentList === 'following' && (window.innerHeight + window.scrollY) >= document.body.offsetHeight) {
            loadMoreFollowing();
        }
    };
}

function loadMoreFollowers() {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_followers.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            if (response.followers && response.followers.length > 0) {
                response.followers.forEach(follower => {
                    if (!followersSet.has(follower.mb_id)) {
                        const div = document.createElement('div');
                        div.className = 'follower-container';
                        const iconFilePath = `<?php echo G5_URL ?>/data/member_image/${follower.mb_id.substring(0, 2)}/${follower.mb_id}.gif`;
                        const img = new Image();
                        img.src = iconFilePath;
                        img.onerror = function() {
                            img.src = `<?php echo G5_URL ?>/data/member/${follower.mb_id.substring(0, 2)}/${follower.mb_id}.gif`;
                        };
                        const followBtn = document.createElement('button');
                        followBtn.id = `followBtn_${follower.mb_id}`;
                        followBtn.className = 'follow-btn';
                        followBtn.onclick = function() {
                            toggleFollow(follower.mb_id);
                        };
                        checkFollowingStatus(follower.mb_id, function(isFollowing) {
                            if (isFollowing) {
                                followBtn.innerText = '채팅';
                                followBtn.onclick = function() {
                                    window.location.href = `memo_form.php?me_recv_mb_id=${follower.mb_id}`;
                                };
                                followBtn.classList.add('active');
                            } else {
                                followBtn.innerText = '팔로우';
                            }
                        });
                        const followerInfo = document.createElement('div');
                        followerInfo.className = 'follower-info';
                        followerInfo.appendChild(img);
                        followerInfo.innerHTML += `<a href="profile.php?mb_id=${follower.mb_id}" alt="profile"> ${follower.mb_nick} </a>`;
                        div.appendChild(followerInfo);
                        
                        // PHP 조건문 추가
                        <?php if ($is_member) { ?>
                            div.appendChild(followBtn);
                        <?php } ?>

                        document.getElementById('followerList').appendChild(div);
                        followersSet.add(follower.mb_id);
                    }
                });
                followerPage++;
            } else {
                console.log("더 이상의 팔로워가 없습니다.");
            }
        } else {
            console.error("팔로워 로드 실패: " + xhr.status);
        }
    };
    xhr.send('page=' + followerPage + '&mb_id=' + mb_id);
}

// checkFollowingStatus 함수 수정 (필요시)
function checkFollowingStatus(targetId, callback) {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_get-following.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            callback(response.isFollowing);
        }
    };
    xhr.send('mb_id=' + targetId);
}

// toggleFollow 함수 수정 (필요시)
function toggleFollow(targetId) {
    const btn = document.getElementById(`followBtn_${targetId}`);
    const action = btn.innerText === '팔로우' ? 'follow' : 'unfollow';
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_follow.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            if (action === 'follow') {
                btn.innerText = '팔로잉';
                alert('팔로우 성공!');
            } else if (action === 'unfollow') {
                btn.innerText = '팔로우';
                alert('팔로우 취소 성공!');
            }
        }
    };
    xhr.send('action=' + action + '&target_id=' + targetId); // mb_id 사용
}

// 팔로잉 추가 로드 함수
function loadMoreFollowing() {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_following.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            if (response.following && response.following.length > 0) {
                response.following.forEach(following => {
                    if (!followingSet.has(following.mb_id)) { // 중복 체크
                        const div = document.createElement('div');
                        const iconFilePath = `<?php echo G5_URL ?>/data/member_image/${following.mb_id.substring(0, 2)}/${following.mb_id}.gif`;

                        // 이미지가 존재하지 않을 경우 기본 이미지 경로로 설정
                        const img = new Image();
                        img.src = iconFilePath;
                        img.onerror = function() {
                            img.src = `<?php echo G5_URL ?>/data/member/${following.mb_id.substring(0, 2)}/${following.mb_id}.gif`;
                        };

                        // a 태그 추가
                        div.innerHTML = `<a href="profile.php?mb_id=${following.mb_id}" style="display: flex;justify-content: flex-start;align-items: center;padding:10px" alt="profile">
                                            <img src="${iconFilePath}" alt="${following.mb_nick}" style="width: 50px; height: 50px; border-radius: 50%; margin-right: 10px;display:block">
                                            ${following.mb_nick}
                                        </a>`;
                        document.getElementById('followingList').appendChild(div);
                        followingSet.add(following.mb_id); // 유저 ID 추가
                    }
                });
                followingPage++;
            } else {
                console.log("더 이상의 팔로잉이 없습니다.");
            }
        } else {
            console.error("팔로잉 로드 실패: " + xhr.status);
        }
    };
    xhr.send('page=' + followingPage + '&mb_id=' + mb_id); // mb_id 사용
}
</script>