<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/latest.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/style.css">', 0);

$member_mb_id = get_member($row['mb_id']);

// 현재 URL의 mb_id 파라미터 값 가져오기
$current_mb_id = isset($_GET['mb_id']) ? $_GET['mb_id'] : null;

// 회원 정보의 mb_id
$member_mb_id = $member['mb_id'];

// mb_id가 일치하는지 확인
if ($current_mb_id === $member_mb_id) {
    // 일치할 경우 리다이렉트
    header("Location: " . G5_BBS_URL . "/member_profile.php?mb_id=" . urlencode($member_mb_id));
    exit; // 스크립트 종료
}
?>
<div class="profile_hd"><!--1-->

<div class="hd_menu"><!--2-->

    <div class="logo"><!--로고-->
        <a href="<?php echo G5_URL ?>">
            <img src="<?php echo G5_THEME_IMG_URL ?>/logo.png" alt="<?php echo $config['cf_title']; ?>">
        </a>
    </div>
    	<!-- page title{ -->
	<div class="title">
		<span style="font-weight:520;font-size:20px;color:#2a2a2a;"><?php echo $mb['mb_nick']; ?>의  프로필</span>
	</div>
    <div class="menu-items"> <!-- 1:1 채팅과 개인 메뉴를 가로로 배치 -->
        <span class="send_memo"><!--1:1채팅-->
            <a href="<?php echo G5_BBS_URL ?>/memo.php">
                <i class="fa fa-send-o" style="font-size:25px;color:#2a2a2a;margin-right:5px"></i>
            </a>
        </span>
    </div>

    </div>

</div><!--2-->
<style>
@keyframes fadeIn {
  from {
    opacity: 0;
    transform: translateY(-10px); /* 위에서 아래로 부드럽게 나타나도록 */
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

.fade-in {
  animation: fadeIn 0.5s ease; /* 0.5초 동안 부드럽게 나타나게 함 */
}
</style>

<style>
.pop {
  justify-content: center;
  align-items: center;
  position: fixed;
  z-index: 1;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(255, 255, 255, 0.8);
  -webkit-backdrop-filter: blur(10px);
  backdrop-filter: blur(10px);
  display: none
}

.pop-modal-content {
    margin: 15% auto;
    padding: 20px;
    width: 80%; /* 모달 너비 */
    max-width:320px
}

.pop-close-btn {
    color: #aaa;
    float: right;
    font-size: 28px;
    font-weight: bold;
}

.pop-close-btn:hover,
.pop-close-btn:focus {
    color: #2a2a2a;
    text-decoration: none;
    cursor: pointer;
}

.pop-modal-content .pqr {
  margin-bottom: 10px;
  padding:20px;
  border-radius:10px;
}

.pop-modal-content .pqr img {
  border-radius:50%;
  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
  width:220px;
  height:220px;
  max-width:220px;
  max-height:220px;
}

.pop-modal-content .psns_share {
  border-radius:10px;
  margin-top:15px;
  background-color: rgba(255, 255, 255, 0.8);
  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
  padding:25px 45px
}
</style>
<div class="profile"><!--3-->
<div class="profile_info">
    <div class="profile_img" id="profileImage" style="position: relative;">
        <?php echo get_member_profile_img($mb['mb_id']); ?><!--프로필이미지-->
    </div>
    <div class="profile_text"><!-- 텍스트 부분 -->
        <span class="nick">
            <?php echo $mb['mb_nick']; ?><!--닉네임-->

<?php
// 포인트에 따른 뱃지(칭호) 시스템
$points = $mb['mb_point'];
$bedge = ''; // 초기화

if ($points >= 50000) {
    $bedge = '<img src="https://dsclub.kr/api/img/등급/초월50000.png" width="25" height="25" alt="다이아">'; // 초월
} elseif ($points >= 25000) {
    $bedge = '<img src="https://dsclub.kr/api/img/등급/다이아25000.png" width="25" height="25" alt="다이아">'; // 다이아
} elseif ($points >= 15000) {
    $bedge = '<img src="https://dsclub.kr/api/img/등급/골드15000.png" width="25" height="25" alt="골드">'; // 골드
} elseif ($points >= 7000) {
    $bedge = '<img src="https://dsclub.kr/api/img/등급/플래티넘7000.png" width="25" height="25" alt="플래티넘">'; // 플래티넘
} elseif ($points >= 5000) {
    $bedge = '<img src="https://dsclub.kr/api/img/등급/실버5000.png" width="25" height="25" alt="실버">'; // 실버
} elseif ($points >= 3000) {
    $bedge = '<img src="https://dsclub.kr/api/img/등급/브론즈3000.png" width="25" height="25" alt="브론즈">'; // 브론즈
}

// 뱃지 출력
echo $bedge; 
?>

        </span>
        <span class="id">
            <a href="#" onclick="copyMemberId('@<?php echo $mb_id ?>')">@<?php echo $mb_id ?></a><!-- }@아이디-->
        </span>
    </div>
    <?php if ($is_member) { ?>
    <button id="followBtn" onclick="toggleFollow('<?php echo $mb_id; ?>')">팔로우</button>
    <?php } ?>
</div>

<!-- 팔로우 시스템 메뉴{ -->
<a href="follow.php?mb_id=<?php echo $mb_id ?>" class="follow-link">
    <div class="follower-group">
        <span class="followers">0</span><!-- 총 팔로워 수 -->
        <span style="font-size:15px; color:#4c4c4c">팔로워</span>
    </div>
    <div class="following-group">
        <span class="following">0</span><!-- 총 팔로잉 수 -->
        <span style="font-size:15px; color:#4c4c4c">팔로잉</span>
    </div>
</a>
<style>
.follow-link {
    display: flex; /* 가로 정렬을 위해 flexbox 사용 */
    margin-top: 10px;
    margin-bottom: -5px;
}

.follower-group,
.following-group,
.write-total {
    display: flex;
    flex-direction: column; /* 세로 정렬을 위해 column 방향으로 설정 */
    align-items: center; /* 가운데 정렬 */
    margin: 0 10px; /* 그룹 간의 간격 조정 */
}

.followers,
.following,
#output_value {
    font-size: 20px; /* 원하는 폰트 크기로 설정 */
    font-weight: 500
}
</style>
<!-- 프로필 팝업 모달 -->
<div class="pop" id="popModal" style="display: none;">
    <div class="pop-modal-content">
        <span class="pop-close-btn">&times;</span>
        <div class="pqr">
            <center>
                <?php echo get_member_profile_img($mb['mb_id']); ?><!--프로필이미지-->
                <div style="padding-top:15px;width:100%;"></div>
                <a href="#" onclick="copyMemberId('@<?php echo $mb_id ?>')">
                    <span style="font-size:20px;font-weight:520;text-align:center;color:#3a3a3a !important">@<?php echo $mb_id ?></span>
                </a>
            </center>
        </div>
        <div class="psns_share">
            <?php include_once(G5_PLUGIN_PATH.'/profile_share/pshare.php'); ?>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const profileImage = document.getElementById('profileImage');
    const popModal = document.getElementById('popModal');
    const closeBtn = document.querySelector('.pop-close-btn');

    let touchTimer;

    // 꾹 누르기 시작
    profileImage.addEventListener('touchstart', function(event) {
        event.preventDefault(); // 기본 동작 방지 (다운로드 메뉴)
        touchTimer = setTimeout(function() {
            popModal.style.display = 'block'; // 모달 열기
            popModal.classList.add('fade-in'); // 애니메이션 추가
        }, 700); // 700ms 이상 누르면 모달 열기
    });

    // 꾹 누르기 종료
    profileImage.addEventListener('touchend', function(event) {
        clearTimeout(touchTimer); // 타이머 초기화
    });

    // 모달 닫기 버튼 클릭 시 모달 닫기
    closeBtn.addEventListener('click', function() {
        popModal.style.display = 'none';
    });

    // 모달 외부 클릭 시 모달 닫기
    window.addEventListener('click', function(event) {
        // 모달 외부 클릭 시 닫기
        if (event.target === popModal) {
            popModal.style.display = 'none';
        }
    });
});
</script>
</div>
    </div>

   <div class="profile_menu"><!--6-->
        <span class="profile_edit">
            <a href="<?php echo G5_BBS_URL ?>/memo_form.php?me_recv_mb_id=<?php echo $mb_id ?>">
                개인 채팅
            </a>
        </span>
        <!-- 프로필 공유{ -->
       <span class="profile_share">
  공유하기
</span>

<div class="share-modal hidden">
  <div class="share-modal-content">
    <span class="close_button">&times;</span>
    <!-- 프로필 qr코드로 공유{ -->
    <div class="qr">
    <center>
    <?php
// 현재 페이지의 주소를 가져옵니다.
$current_url = 'http';
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    $current_url .= "s";
}
$current_url .= "://";
$current_url .= $_SERVER['HTTP_HOST'] . "/bbs/profile.php?mb_id=" . $mb_id;
// QR 코드를 출력합니다.
echo "<img src='https://api.qrserver.com/v1/create-qr-code/?data=" . urlencode($current_url) . "&size=200x200' alt='QR Code'>";
?>
<!-- 프로필 아이디 복사{ -->
<div style="padding-top:15px;width:100%;"></div>
<a href="#" onclick="copyMemberId('@<?php echo $mb_id ?>')">
<span style="font-size:20px;font-weight:520;text-align:center;">@<?php echo $mb_id ?></span>
</a>
</center>
</div>
<!-- 프로필 sns 공유(카카오 공유 구현 어렵;;){ -->
<div class="sns_share">
<?php include_once(G5_PLUGIN_PATH.'/profile_share/share.php'); ?>
</div>
</div>
</div>
<style>
.share-modal {
  display: flex;
  justify-content: center;
  align-items: center;
  position: fixed;
  z-index: 1;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(0, 0, 0, 0.4);
  -webkit-backdrop-filter: blur(10px);
  backdrop-filter: blur(10px);
}

.share-modal-content {
  background-color: #f9f9f9;
  padding: 20px;
  border: 1px solid #f2f2f2;
  width: 60%;
  min-width: 300px;
  max-width: 400px;
  height: 50%;
  min-height: 420px;
  max-height: 450px;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  border-radius: 14px;
  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
  overflow: auto;
}

.hidden {
  display: none;
}

.close_button {
  color: #2a2a2a;
  font-size: 28px;
  font-weight: bold;
  margin-left:auto
}

.close_button:hover,
.close_button:focus {
  color: #1a1a1a;
  text-decoration: none;
  cursor: pointer;
}

.share-modal-content .qr {
  margin-bottom: 10px;
  padding:20px;
  border-radius:10px;
  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
}

.share-modal-content .sns_share {
  border-radius:10px;
  margin-top:15px;
}

</style>
<script>
const shareButton = document.querySelector('.profile_share');
const shareModal = document.querySelector('.share-modal');
const closeButton = document.querySelector('.close_button');

shareButton.addEventListener('click', () => {
  shareModal.classList.remove('hidden');
  document.body.style.overflow = 'hidden'; // 모달 외부 스크롤 막기
});

closeButton.addEventListener('click', () => {
  shareModal.classList.add('hidden');
  document.body.style.overflow = 'auto'; // 모달 외부 스크롤 허용
});

window.addEventListener('click', (event) => {
  if (event.target == shareModal) {
    shareModal.classList.add('hidden');
    document.body.style.overflow = 'auto'; // 모달 외부 스크롤 허용
  }
});

const copyLinkButton = document.getElementById('copyLink');
const lineShareButton = document.querySelector('a[href="<?= $ls ?>"]');
const facebookShareButton = document.querySelector('a[href="<?= $fs ?>"]');
const twitterShareButton = document.querySelector('a[href="<?= $ts ?>"]');

</script>
    </div><!--6-->

<!-- 팔로우 버튼{ -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const btn = document.getElementById('followBtn');
    const targetId = '<?php echo $mb_id; ?>';

    // 팔로잉 상태 확인
    checkFollowingStatus(targetId, function(isFollowing) {
        if (isFollowing) {
            btn.innerText = '팔로잉';
        }
    });
});

function checkFollowingStatus(targetId, callback) {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_get-following.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            callback(response.isFollowing);
        }
    };
    xhr.send('mb_id=' + targetId);
}

function toggleFollow(targetId) {
    const btn = document.getElementById('followBtn');
    let action;

    // 버튼 상태에 따라 액션 설정 및 AJAX 요청
    if (btn.innerText === '팔로우') {
        action = 'follow';
        btn.innerText = '팔로잉'; // 버튼 텍스트 변경
    } else if (btn.innerText === '팔로잉') {
        // AJAX 요청을 보내기 전에 '팔로우 취소'로 변경
        btn.innerText = '팔로우 취소'; 
    } else if (btn.innerText === '팔로우 취소') {
        action = 'unfollow';
        btn.innerText = '팔로우'; // 버튼 텍스트 다시 변경
    }

    // AJAX 요청
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_follow.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            if (action === 'follow') {
                alert('팔로우 성공!');
            } else if (action === 'unfollow') {
                alert('팔로우 취소 성공!');
            }
        } else {
            // 요청 실패 시 원래 상태로 복원
            if (action === 'follow') {
                btn.innerText = '팔로우';
            } else if (action === 'unfollow') {
                btn.innerText = '팔로잉';
            }
        }
    };

    xhr.send('action=' + action + '&target_id=' + targetId);
}
</script>
<!-- }팔로우 버튼 -->
<!-- 팔로워/팔로잉 수{ -->
<script>
let followingPage = 1; // 현재 페이지 설정
let followerPage = 1; // 현재 페이지 설정
let mb_id = '<?php echo $mb_id ?>'; // mb_id를 직접 입력하거나 다른 방법으로 설정하세요

// 팔로잉 목록 로드
function loadFollowing() {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_following.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            displayFollowingCount(response);
        } else {
            console.error("팔로잉 로드 실패: " + xhr.status);
        }
    };
    xhr.send('page=' + followingPage + '&mb_id=' + mb_id);
}

function displayFollowingCount(data) {
    const followingSpan = document.querySelector('.following');
    followingSpan.innerHTML = ''; // 이전 내용 초기화

    // 총 팔로잉 수 출력
    const totalCount = document.createElement('p');
    totalCount.innerText = `${data.total_following}`;
    followingSpan.appendChild(totalCount);
}

// 팔로워 목록 로드
function loadFollowers() {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo G5_URL ?>/bbs/ajax_followers.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            displayFollowerCount(response);
        } else {
            console.error("팔로워 로드 실패: " + xhr.status);
        }
    };
    xhr.send('page=' + followerPage + '&mb_id=' + mb_id);
}

function displayFollowerCount(data) {
    const followerSpan = document.querySelector('.followers');
    followerSpan.innerHTML = ''; // 이전 내용 초기화

    // 총 팔로워 수 출력
    let totalCount = data.total_followers;


    const countElement = document.createElement('p');
    countElement.innerText = `${totalCount}`;
    followerSpan.appendChild(countElement);
}

// 페이지 로드 시 팔로잉 및 팔로워 목록 불러오기
window.onload = function() {
    loadFollowing();
    loadFollowers();

    // 6초마다 데이터를 새로 고침
    setInterval(function() {
        loadFollowing();
        loadFollowers();
    }, 6000); // 6000 밀리초 = 6초
};
</script>
<!-- }팔로잉/팔로워 수 끝 -->

	    <div class="member_memo"><!--5-->
	    <span style="font-weight:520;font-size:17px;color:#3a3a3a">자기소개</span>
        <p style="margin-top:10px;"><?php echo $mb_profile ?></p><!--상태메시지-->
    </div><!--5-->

</div><!--3-->

</div><!--1-->

<div class="profile_bd" style="padding-bottom:50px;"><!--1-->


<?php
include_once('./_common.php');

$sql_common = " from {$g5['board_new_table']} a, {$g5['board_table']} b, {$g5['group_table']} c where a.bo_table = b.bo_table and b.gr_id = c.gr_id and b.bo_use_search = 1 ";

$gr_id = isset($_GET['gr_id']) ? substr(preg_replace('#[^a-z0-9_]#i', '', $_GET['gr_id']), 0, 10) : '';
if ($gr_id) {
    $sql_common .= " and b.gr_id = '$gr_id' ";
}

$view = isset($_GET['view']) ? $_GET['view'] : "";

if ($view == "w")
    $sql_common .= " and a.wr_id = a.wr_parent ";
else if ($view == "c")
    $sql_common .= " and a.wr_id <> a.wr_parent ";
else
    $view = '';

$mb_id = isset($_GET['mb_id']) ? ($_GET['mb_id']) : '';
$mb_id = substr(preg_replace('#[^a-z0-9_]#i', '', $mb_id), 0, 20);

if ($mb_id) {
    $sql_common .= " and a.mb_id = '{$mb_id}' ";
}
$sql_order = " order by a.bn_id desc ";

$sql = " select count(*) as cnt {$sql_common} ";
$row = sql_fetch($sql);
$total_count = $row['cnt'];

$rows = G5_IS_MOBILE ? $config['cf_mobile_page_rows'] : $config['cf_new_rows'];
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
if ($page < 1) $page = 1; // 페이지가 없으면 첫 페이지 (1 페이지)
$from_record = ($page - 1) * $rows; // 시작 열을 구함

$list = array();
$sql = " select a.*, b.bo_subject, b.bo_mobile_subject, c.gr_subject, c.gr_id {$sql_common} {$sql_order} limit {$from_record}, {$rows} ";
$result = sql_query($sql);
for ($i=0; $row=sql_fetch_array($result); $i++) {
    $tmp_write_table = $g5['write_prefix'].$row['bo_table'];

    if ($row['wr_id'] == $row['wr_parent']) {

        // 원글
        $comment = "";
        $comment_link = "";
        $row2 = sql_fetch(" select * from {$tmp_write_table} where wr_id = '{$row['wr_id']}' ");
        $list[$i] = $row2;

        $name = get_sideview($row2['mb_id'], get_text(cut_str($row2['wr_name'], $config['cf_cut_name'])), $row2['wr_email'], $row2['wr_homepage']);
        // 당일인 경우 시간으로 표시함
        $datetime = substr($row2['wr_datetime'],0,10);
        $datetime2 = $row2['wr_datetime'];
        if ($datetime == G5_TIME_YMD) {
            $datetime2 = substr($datetime2,11,5);
        } else {
            $datetime2 = substr($datetime2,5,5);
        }

    } else {

        // 코멘트
        $comment = '[코] ';
        $comment_link = '#c_'.$row['wr_id'];
        $row2 = sql_fetch(" select * from {$tmp_write_table} where wr_id = '{$row['wr_parent']}' ");
        $row3 = sql_fetch(" select mb_id, wr_name, wr_email, wr_homepage, wr_datetime from {$tmp_write_table} where wr_id = '{$row['wr_id']}' ");
        $list[$i] = $row2;
        $list[$i]['wr_id'] = $row['wr_id'];
        $list[$i]['mb_id'] = $row3['mb_id'];
        $list[$i]['wr_name'] = $row3['wr_name'];
        $list[$i]['wr_email'] = $row3['wr_email'];
        $list[$i]['wr_homepage'] = $row3['wr_homepage'];

        $name = get_sideview($row3['mb_id'], get_text(cut_str($row3['wr_name'], $config['cf_cut_name'])), $row3['wr_email'], $row3['wr_homepage']);
        // 당일인 경우 시간으로 표시함
        $datetime = substr($row3['wr_datetime'],0,10);
        $datetime2 = $row3['wr_datetime'];
        if ($datetime == G5_TIME_YMD) {
            $datetime2 = substr($datetime2,11,5);
        } else {
            $datetime2 = substr($datetime2,5,5);
        }

    }

    $list[$i]['gr_id'] = $row['gr_id'];
    $list[$i]['bo_table'] = $row['bo_table'];
    $list[$i]['name'] = $name;
    $list[$i]['comment'] = $comment;
    $list[$i]['href'] = get_pretty_url($row['bo_table'], $row2['wr_id'], $comment_link);
    $list[$i]['datetime'] = $datetime;
    $list[$i]['datetime2'] = $datetime2;

    $list[$i]['gr_subject'] = $row['gr_subject'];
    $list[$i]['bo_subject'] = ((G5_IS_MOBILE && $row['bo_mobile_subject']) ? $row['bo_mobile_subject'] : $row['bo_subject']);
    $list[$i]['wr_subject'] = $row2['wr_subject'];
}

$write_pages = get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, "?gr_id=$gr_id&amp;view=$view&amp;mb_id=$mb_id&amp;page=");

include_once($new_skin_path.'/profile_new.skin.php');
?>

</div><!--1-->

<!-- 프로필 아이디 복사{ -->
<script>
function copyMemberId(memberId) {
    // 멤버 아이디를 클립보드에 복사
    navigator.clipboard.writeText(memberId);

    // 사용자에게 복사 완료 알림 표시
    alert('프로필 ID가 복사되었습니다.');
}
</script>
<!--프로필 공유{ -->
<script>
function copyProfileLink() {
    // PHP에서 전달받은 $mb_id 값을 사용하여 프로필 링크 생성
    var profileLink = '<?php echo G5_BBS_URL ?>/profile.php?mb_id=<?php echo $mb_id ?>';

    // 링크를 클립보드에 복사
    navigator.clipboard.writeText(profileLink);

    // 사용자에게 복사 완료 알림 표시
    alert('프로필 링크가 복사되었습니다.');
}
</script>
<!-- 접속 중인지 출력{ -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    // 현재 페이지의 mb_id 파라미터 가져오기
    const urlParams = new URLSearchParams(window.location.search);
    const currentMbId = urlParams.get('mb_id');

    function fetchData() {
        // AJAX 요청
        $.ajax({
            url: `<?php echo G5_URL ?>/bbs/ajax_connect-info.php`, // 현재 도메인을 사용
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // 동그라미 색상 기본 설정
                let circleColor = '#8c8c8c'; // 기본 색상 (회원 아님)

                // 접속 중인 회원 목록(data)에서 currentMbId가 있는지 확인
                if (data.includes(currentMbId)) {
                    circleColor = '#4895ff'; // 회원일 경우 색상 변경
                }

                // 동그라미 생성
                const circle = $('<div></div>')
                    .css({
                        width: '15px',
                        height: '15px',
                        backgroundColor: circleColor,
                        borderRadius: '50%',
                        position: 'absolute',
                        bottom: '-5px',
                        right: '-5px',
                        margin: '5px',
                        border: '2px solid #f9f9f9'
                    });

                // 이전 동그라미 제거 (중복 방지)
                $('#profileImage').find('div').remove();
                
                // 프로필 이미지에 동그라미 추가
                $('#profileImage').append(circle);
            },
            error: function() {
                console.error('AJAX 요청 실패');
            }
        });
    }
    
    // 처음 데이터 가져오기
    fetchData();
    
    // 1분(60000ms)마다 데이터 가져오기
    setInterval(fetchData, 60000);
});
</script>

<style>
.logo img {
height:35px;weight:auto;
}
.hd_menu {
    display: flex;
    justify-content: space-between; /* 양 끝에 고정 */
    align-items: center; /* 세로 중앙 정렬 */
    height: 50px; /* 높이 설정 */
    position: fixed; /* 고정 위치 */
    top: 0; /* 상단 고정 */
    left: 0; /* 왼쪽 고정 */
    right: 0; /* 오른쪽 고정 */
    background-color: #ffffff; /* 배경색 */
    border-bottom: 1px solid #e1e8ed; /* 하단 경계선 */
    z-index: 1000; /* 다른 요소 위에 표시 */
    padding: 15px 10px
}

.logo {
    margin-left: 10px; /* 왼쪽 여백 */
}

.menu-items {
    display: flex; /* 가로 정렬 */
    align-items: center; /* 세로 중앙 정렬 */
    margin-right: 10px; /* 오른쪽 여백 */
}

.send_memo,
.personal-menu {
    margin-left: 15px; /* 아이콘 간의 여백 */
}
.profile {
    background-color: #ffffff; /* 배경색 */
    border-radius: 5px; /* 모서리 둥글게 */
    padding: 15px; /* 내부 여백 */
    padding-top: 65px; /* 위쪽 여백 */
}

.profile_info {
    display: flex; /* 가로 정렬 */
    align-items: center; /* 세로 중앙 정렬 */
    margin-bottom: 10px; /* 아래쪽 여백 */
}

.profile .profile_img {
    margin-right: 30px; /* 이미지와 텍스트 간격 */
}

.profile .profile_img img {
    width: 60px; /* 이미지 너비 */
    min-width: 60px; /* 이미지 너비 */
    max-width: 60px; /* 이미지 너비 */
    height: 60px; /* 비율 유지 */
    min-height: 60px; /* 비율 유지 */
    max-height: 60px; /* 비율 유지 */
    border-radius: 50%; /* 원형 */
}

.profile_text {
    display: flex;
    flex-direction: column; /* 세로 정렬 */
}

.nick {
    font-weight: 540; /* 닉네임 두껍게 */
    color: #14171a !important; /* 텍스트 색상 */
    font-size: 1.4em; /* 폰트 크기 */
}

.id,
.id a {
    color: #555 !important; /* 아이디 색상 */
    font-size: 17px; /* 폰트 크기 */
    margin-left: 0;
}

#followBtn {
    margin-left: auto; /* 오른쪽으로 밀기 */
    padding: 5px 15px;
    border-radius: 10px;
    font-size: 15px;
    font-weight: 520;
    background-color: #0091fe;
    border: none;
    color: #fff
}

.member_memo {
    color: #3a3a3a; /* 상태 메시지 색상 */
    margin: 10px; /* 위 아래 여백 */
    font-size: 15px;
    padding-bottom:15px;
    border-bottom:1px solid #e1e1e1;
    padding-left:15px
}

.profile_menu {
    display: flex; /* 가로 정렬 */
    margin: 0 20px;
    justify-content: center;
}

.profile_edit {
display: flex; /* Flexbox 활성화 */
    justify-content: center; /* 가로 중앙 정렬 */
    align-items: center; /* 세로 중앙 정렬 */
	color:#2a2a2a;
	padding: 10px;
	border-radius:10px;
	font-weight:500;
	border:none;
	font-size:15px;
	background-color:#f2f2f2;
	margin-right:5px;
	white-space: nowrap;
	width:70%
}

.profile_share {
    display: flex; /* Flexbox 활성화 */
    justify-content: center; /* 가로 중앙 정렬 */
    align-items: center; /* 세로 중앙 정렬 */
    color: #f2f2f2; /* 링크 색상 */
    background-color: #508ff7; /* 배경색 */
    cursor: default; /* 커서 포인터를 기본으로 변경 */
    font-weight: 560; /* 굵은 글씨 */
    padding: 10px; /* 내부 여백 */
    border-radius: 10px; /* 둥근 모서리 */
    border: none; /* 테두리 없음 */
    font-size: 15px; /* 폰트 크기 */
    margin-left: 5px; /* 왼쪽 여백 */
    white-space: nowrap; /* 줄 바꿈 방지 */
    width: 70%; /* 너비 설정 */
}

.profile_edit:hover,
.profile_share:hover {
    text-decoration: none; /* 호버 시 밑줄 */
}
</style>

<style>
.modal {
    display: none;
    position: fixed;
    z-index: 1;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.4);
}

.modal-content {
    background-color: #fefefe;
    width: 100%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
}

.close-button {
    color: #aaa;
    position: absolute;
    top: 20px;
    right: 20px;
    font-size: 28px;
    font-weight: bold;
}

.close-button:hover,
.close-button:focus {
    color: black;
    text-decoration: none;
    cursor: pointer;
}
</style>

<!-- 보안을 위한 개발자 도구 제한{ -->
<?php
// 개발자 도구 사용 감지
if (isset($_SERVER['HTTP_USER_AGENT']) && stripos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false && stripos($_SERVER['HTTP_USER_AGENT'], 'Edg') === false && stripos($_SERVER['HTTP_USER_AGENT'], 'Firefox') === false && stripos($_SERVER['HTTP_USER_AGENT'], 'Safari') === false) {
    // 개발자 도구 사용 시 오류 메시지 출력
    http_response_code(403);
    echo "개발자 도구 사용이 금지되어 있습니다.";
    exit;
}
?>
<script>
// F12 키 막기
document.addEventListener('keydown', function(event) {
  if (event.keyCode == 123) {
    event.preventDefault();
    return false;
  }
});

// 개발자 도구 열기 막기
document.addEventListener('contextmenu', function(e) {
  e.preventDefault();
});

// 개발자 도구 콘솔 막기
if (window.console) {
  console.log = function() {};
  console.error = function() {};
  console.warn = function() {};
  console.info = function() {};
  console.debug = function() {};
}
</script>
<?php
// 브라우저에서 JavaScript 사용 여부 확인
if (!isset($_SERVER['HTTP_USER_AGENT']) || !preg_match('/(?i)msie|trident|firefox|safari|opera|chrome/', $_SERVER['HTTP_USER_AGENT'])) {
    // JavaScript를 사용하지 않는 경우 리다이렉트
    header('Location: ' . G5_URL);
    exit;
}
?>