<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/style.css">', 0);
?>

<div class="register">
    <script src="<?php echo G5_JS_URL ?>/jquery.register_form.js"></script>
    <?php if($config['cf_cert_use'] && ($config['cf_cert_ipin'] || $config['cf_cert_hp'])) { ?>
    <script src="<?php echo G5_JS_URL ?>/certify.js?v=<?php echo G5_JS_VER; ?>"></script>
    <?php } ?>

    <form name="fregisterform" id="fregisterform" action="<?php echo $register_action_url ?>" onsubmit="return fregisterform_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off">
    <input type="hidden" name="w" value="<?php echo $w ?>">
    <input type="hidden" name="url" value="<?php echo $urlencode ?>">
    <input type="hidden" name="agree" value="<?php echo $agree ?>">
    <input type="hidden" name="agree2" value="<?php echo $agree2 ?>">
    <input type="hidden" name="cert_type" value="<?php echo $member['mb_certify']; ?>">
    <input type="hidden" name="cert_no" value="">
    
    <input type="hidden" name="mb_open" value="1">
    <?php if (isset($member['mb_sex'])) { ?><input type="hidden" name="mb_sex" value="<?php echo $member['mb_sex'] ?>"><?php } ?>
    <?php if (isset($member['mb_nick_date']) && $member['mb_nick_date'] > date("Y-m-d", G5_SERVER_TIME - ($config['cf_nick_modify'] * 86400))) { // 닉네임수정일이 지나지 않았다면 ?>
    <input type="hidden" name="mb_nick_default" value="<?php echo get_text($member['mb_nick']) ?>">
    <input type="hidden" name="mb_nick" value="<?php echo get_text($member['mb_nick']) ?>">
    <?php } ?>

<style>
  input:focus {outline:none;}
  .password-input-wrapper {
    position: relative;
}

.input-wrapper {
    position: relative;
}

.password-toggle-icon {
    position: absolute;
    right: 15px;
    transform: translateY(-50%);
    cursor: pointer;
    font-size:15px;
    top:40%
}

#fregisterform .profile_img img {
min-width:100px;
width:100px;
max-width:100px;
min-height:100px;
height:100px;
max-height:100px;
border-radius:50%;
height: auto;
}

.profile_img {
   display: flex; /* Flexbox 활성화 */
    justify-content: center; /* 가로 중앙 정렬 */
    margin-bottom:15px
}

.register {
padding:10px;
}

.profile-textarea-wrapper {
    position: relative;
    background-color: #f9f9f9;
    border: 1px solid #f2f2f2;
    border-radius: 15px;
    padding: 10px;
}

.profile-textarea {
    height: 100px;
    width: 100%;
    padding-right: 60px;
    box-sizing: border-box;
    border: none;
    background-color: transparent;
    font-size: 14px;
    color: #14171a;
    resize: none;
}

.profile-textarea:focus {
    outline: none;
}

.profile-text-count {
    position: absolute;
    bottom: 10px;
    right: 10px;
    font-size: 12px;
    color: #657786;
}
li, ul {
    list-style-type: none;
    padding: 0;
    margin: 0;
}
</style>
<script>
// 비밀번호 보기/숨기기 토글 기능
const passwordInput = document.getElementById('reg_mb_password');
const passwordToggleIcon = document.querySelector('.password-toggle-icon i');

passwordToggleIcon.addEventListener('click', () => {
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        passwordToggleIcon.classList.remove('fa-lock');
        passwordToggleIcon.classList.add('fa-unlock-alt');
    } else {
        passwordInput.type = 'password';
        passwordToggleIcon.classList.remove('fa-unlock-alt');
        passwordToggleIcon.classList.add('fa-lock');
    }
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var profileTextarea = document.getElementById('reg_mb_profile');
    var profileTextCount = document.getElementById('profile_text_count');

    profileTextarea.addEventListener('input', function() {
        // 줄바꿈 문자 제거
        this.value = this.value.replace(/\n/g, '');

        var textLength = this.value.length;
        profileTextCount.textContent = textLength;
    });
});
</script>
<script>
document.getElementById('check_password').addEventListener('click', function() {
    var password = document.getElementById('reg_mb_password').value;
    var passwordConfirm = document.getElementById('reg_mb_password_re').value;
</script>

<div class="profile">
<?php if ($member['mb_level'] >= $config['cf_icon_level'] && $config['cf_member_img_size'] && $config['cf_member_img_width'] && $config['cf_member_img_height']) { ?>
    <span class="profile_img">
        <img id="profileImage" src="<?php echo $w == 'u' && file_exists($mb_img_path) ? $mb_img_url : $config['cf_member_img_url']; ?>" alt="회원프로필이미지">
    </span>
    <li class="reg_mb_img_file filebox">
        <input type="hidden" class="fileName" readonly="readonly" placeholder="회원이미지">
        <label for="reg_mb_img" class="btn_file" style="display:none;"><span class="sound_only">회원이미지</span>이미지선택</label>
        <input type="file" name="mb_img" id="reg_mb_img" class="uploadBtn" style="display:none;" accept="image/*">
    </li>
    <a href="#" id="editPhotoLink" style="float:right;background-color:#f2f2f2;border:none;color:#3a3a3a;border-radius:15px;padding:10px 15px;font-size:12px;font-weight:500;margin-bottom:10px;">사진 수정</a>
    <span id="photoUploadText" style="display:none; float:right;background-color:#2589fe;border:none;color:#f9f9f9;border-radius:15px;padding:10px 15px;font-size:12px;font-weight:500;margin-bottom:10px">사진 업로드 및 사진 촬영</span>
<?php } ?>

<?php if ($config['cf_use_member_icon'] && $member['mb_level'] >= $config['cf_icon_level']) { ?>
    <li class="filebox" style="display:none;width:0;height:0;z-index:-9999">
        <input type="file" name="mb_icon" id="reg_mb_icon" class="uploadBtn">
    </li>

    <script>
        document.getElementById('reg_mb_img').addEventListener('change', function() {
            var file = this.files[0];
            if (file && file.size > 10 * 1024 * 1024) { // 10MB 이상인지 확인
                compressImage(file, function(compressedFile) {
                    var iconInput = document.getElementById('reg_mb_icon');
                    var dataTransfer = new DataTransfer();
                    dataTransfer.items.add(compressedFile);
                    iconInput.files = dataTransfer.files;
                });
            } else if (file) {
                var iconInput = document.getElementById('reg_mb_icon');
                var dataTransfer = new DataTransfer();
                dataTransfer.items.add(file);
                iconInput.files = dataTransfer.files;
            }
        });

        function compressImage(file, callback) {
            var reader = new FileReader();
            reader.onload = function(event) {
                var img = new Image();
                img.onload = function() {
                    var canvas = document.createElement('canvas');
                    var ctx = canvas.getContext('2d');

                    // 이미지 크기 설정 (이 크기를 조정하여 압축률 변경 가능)
                    var maxWidth = 2500;
                    var maxHeight = 2500;
                    var width = img.width;
                    var height = img.height;

                    if (width > height) {
                        if (width > maxWidth) {
                            height = Math.round((height * maxWidth) / width);
                            width = maxWidth;
                        }
                    } else {
                        if (height > maxHeight) {
                            width = Math.round((width * maxHeight) / height);
                            height = maxHeight;
                        }
                    }

                    canvas.width = width;
                    canvas.height = height;

                    ctx.drawImage(img, 0, 0, width, height);

                    canvas.toBlob(function(blob) {
                        callback(new File([blob], file.name, {
                            type: file.type,
                            lastModified: Date.now()
                        }));
                    }, file.type, 1.0); // 압축 품질 (0.0 ~ 1.0)
                };
                img.src = event.target.result;
            };
            reader.readAsDataURL(file);
        }
    </script>
<?php } ?>

<script>
    document.getElementById('editPhotoLink').addEventListener('click', function(event) {
        event.preventDefault();
        this.style.display = 'none';  // "사진 수정" 텍스트 숨기기
        document.getElementById('photoUploadText').style.display = 'block'; // "사진 업로드 및 사진 촬영" 텍스트 보이기
    });

    document.getElementById('photoUploadText').addEventListener('click', function() {
        document.getElementById('reg_mb_img').click();
    });

    document.getElementById('reg_mb_img').addEventListener('change', function(event) {
        const file = event.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('profileImage').src = e.target.result;  // 업로드된 이미지로 프로필 이미지 업데이트
            };
            reader.readAsDataURL(file);
        }
    });
</script>

<div class="profile_nick">
<input type="text" name="mb_nick" id="reg_mb_nick" required class="frm_input required nospace full_input" size="10" maxlength="20" value="<?php echo $member['mb_nick'];?>" style="border:1px solid #f1f1f1;background-color:#f9f9f9;border-radius:15px;padding:10px;margin-bottom:5px">
<!-- 간편 프로필 수정을 위해 숨김 처리 -->
	            <input type="hidden" name="mb_id" value="<?php echo $member['mb_id'] ?>" id="reg_mb_id" class="frm_input full_input <?php echo $required ?> <?php echo $readonly ?>" minlength="3" maxlength="20" <?php echo $required ?> <?php echo $readonly ?> placeholder="아이디">
	            	            <input type="hidden" id="reg_mb_name" name="mb_name" value="<?php echo get_text($member['mb_name']) ?>" <?php echo $required ?> <?php echo $readonly; ?> class="frm_input full_input <?php echo $required ?> <?php echo $readonly ?>" placeholder="이름">
                <input type="hidden" name="old_email" value="<?php echo $member['mb_email'] ?>">
                <input type="hidden" name="mb_email" value="<?php echo isset($member['mb_email'])?$member['mb_email']:''; ?>" id="reg_mb_email" required class="frm_input email required" size="50" maxlength="100" placeholder="E-mail">
</div>

<div class="password-input-wrapper">
    <div class="input-wrapper">
        <input type="password" name="mb_password" id="reg_mb_password" <?php echo $required ?> class="frm_input full_input <?php echo $required ?>" minlength="3" maxlength="20" value="<?php echo $mb_profile ?>" placeholder="비밀번호" style="border:1px solid #f1f1f1;background-color:#f9f9f9;border-radius:15px;padding:10px;margin-bottom:15px;padding-right: 40px;" oninput="syncPassword()">
        <span class="password-toggle-icon">
            <i class="fa fa-lock"></i>
        </span>
    </div>
</div>
<input type="password" name="mb_password_re" id="reg_mb_password_re" <?php echo $required ?> class="frm_input full_input <?php echo $required ?>" minlength="3" maxlength="20" placeholder="비밀번호 확인" style="display:none">

<script>
function syncPassword() {
    const password = document.getElementById('reg_mb_password').value;
    document.getElementById('reg_mb_password_re').value = password;
}
</script>

	        <?php if ($config['cf_use_profile']) { ?>
	        <li>
	            <label for="reg_mb_profile" class="sound_only">자기소개</label>
<div class="profile-textarea-wrapper">
    <textarea name="mb_profile" id="reg_mb_profile" class="<?php echo $config['cf_req_profile']?"required":""; ?> profile-textarea" <?php echo $config['cf_req_profile']?"required":""; ?> maxlength="100" placeholder="자기소개" style="resize: none;"><?php echo $member['mb_profile'] ?></textarea>
    <div class="profile-text-count"><span id="profile_text_count">0</span> / 100</div>
</div>
</li>
<?php } ?>
<!-- 
	        <?php
	        //회원정보 수정인 경우 소셜 계정 출력
	        if( $w == 'u' && function_exists('social_member_provider_manage') ){
	            social_member_provider_manage();
	        }
	        ?>
-->
</div>

<!-- 24.12.04 | https://dsclub.kr/code/1074 | 회원가입 시 캡챠 검증 안하는 오류 해결{ -->
	        <li class="is_captcha_use">
	            <span  class="frm_label">자동등록방지</span>
	            <?php echo captcha_html(); ?>
	        </li>
	    </ul>
    </div>

    <div class="btn_confirm" style="margin:20px;z-index:999999999">
        <button type="submit" id="btn_submit" class="btn_submit" accesskey="s" style="text-align:center;width:100%;padding:15px;border:none;border-radius:15px;background-color:#2589fe;font-size:13px;font-weight:520;color:#f9f9f9;max-width:650px;"><?php echo $w==''?'회원가입':'완료'; ?></button>
    </div>
    </form>

<!-- 24.12.04 | https://dsclub.kr/code/1073 | 프로필 사진&아이콘 수정 기능 추가 Ver2 (자료 외의 업데이트){ -->
<style>
#ft {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gram_fix_btn {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gram_fix_btn li {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gram_fix_btn a {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gf_btn {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gf_home {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.fa {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.sound_only {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gf_sch {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gf_wrt {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.fa-sticky-note-o {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.fprofile_img img{
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}

.gf_logout {
  height: 0;
  width: 0;
  color: #0000;
  font-size: 0;
}
</style>

<style>
  /* 이미지 편집 모달 스타일 */
  .image-editor-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.85);
    align-items: center;
    justify-content: center;
    font-family: 'Arial', sans-serif;
  }

  .image-editor-content {
    background-color: #ffffff;
    padding: 10px;
    border-radius: 20px;
    max-width: 90%;
    text-align: center;
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
    width: 90%;
    max-width: 360px;
  }

  .editor-canvas {
    border-radius: 8px;
    border: 1px solid #e6e6e6;
    width: 100%;
    height: auto;
    margin-bottom: 10px;
  }

  /* 버튼 스타일 */
  .image-editor-buttons {
    display: flex;
    justify-content: space-around;
    margin-top: 10px;
  }

  .image-editor-buttons button {
    background-color: #2589fe;
    color: #fff;
    border: none;
    border-radius: 20px;
    padding: 8px 12px;
    cursor: pointer;
    font-size: 13px;
    transition: background-color 0.3s ease;
    flex: 1;
    margin: 0 5px;
  }

  .image-editor-buttons button:hover {
    background-color: #2589fe;
  }

  /* 취소 버튼 별도 스타일 */
  #cancelEdit {
    background-color: #dbdbdb;
    color: #262626;
  }

  #cancelEdit:hover {
    background-color: #c1c1c1;
  }
</style>

<!-- 이미지 편집 모달 구조 -->
<div class="image-editor-modal" id="imageEditorModal">
  <div class="image-editor-content">
    <canvas id="editorCanvas" class="editor-canvas"></canvas>
    <div class="image-editor-buttons">
      <button type="button" id="rotateLeft">회전</button>
      <button type="button" id="applyChanges">적용</button>
      <button type="button" id="cancelEdit">취소</button>
    </div>
  </div>
</div>

<script>
  const imageEditorModal = document.getElementById('imageEditorModal');
  const editorCanvas = document.getElementById('editorCanvas');
  const ctx = editorCanvas.getContext('2d');
  let scale = 1;
  let rotation = 0;
  let img = new Image();
  let offsetX = 0;
  let offsetY = 0;
  let initialDistance = null;
  const canvasSize = 300; // 1:1 비율을 위한 고정 크기
  const snapThreshold = 5; // 중앙으로 스냅되는 거리 설정

  document.getElementById('reg_mb_img').addEventListener('change', function(event) {
    const file = event.target.files[0];
    if (file) {
      const reader = new FileReader();
      reader.onload = function(e) {
        imageEditorModal.style.display = 'flex';
        document.body.style.overflow = 'hidden'; // 모달 열릴 때 스크롤 잠금
        img.src = e.target.result;
        img.onload = function() {
          editorCanvas.width = canvasSize;
          editorCanvas.height = canvasSize;
          applyTransformations();
        };
      };
      reader.readAsDataURL(file);
    }
  });

function applyTransformations() {
  ctx.clearRect(0, 0, editorCanvas.width, editorCanvas.height);
  ctx.save();
  ctx.translate(editorCanvas.width / 2 + offsetX, editorCanvas.height / 2 + offsetY);

  // 크기 조절 스냅 기능
  if (Math.abs(scale - 1) < 0.1) {
    scale = 1;
  } else if (Math.abs(scale - 1.5) < 0.1) {
    scale = 1.5;
  } else if (Math.abs(scale - 2) < 0.1) {
    scale = 2;
  }

  ctx.scale(scale, scale);
  ctx.rotate((rotation * Math.PI) / 180);

  const imgAspect = img.width / img.height;
  const canvasAspect = editorCanvas.width / editorCanvas.height;
  let renderWidth, renderHeight;

  if (imgAspect > canvasAspect) {
    renderHeight = editorCanvas.height;
    renderWidth = img.width * (renderHeight / img.height);
  } else {
    renderWidth = editorCanvas.width;
    renderHeight = img.height * (renderWidth / img.width);
  }

  ctx.drawImage(img, -renderWidth / 2, -renderHeight / 2, renderWidth, renderHeight);
  ctx.restore();
  snapToEdges(); // 위치 자석 기능 적용
}


  function snapToEdges() {
    if (Math.abs(offsetX) < snapThreshold) {
      offsetX = 0;
    }
    if (Math.abs(offsetY) < snapThreshold) {
      offsetY = 0;
    }

    if (Math.abs(offsetX + editorCanvas.width / 2) < snapThreshold) {
      offsetX = -editorCanvas.width / 2;
    }
    if (Math.abs(offsetX - editorCanvas.width / 2) < snapThreshold) {
      offsetX = editorCanvas.width / 2;
    }
    if (Math.abs(offsetY + editorCanvas.height / 2) < snapThreshold) {
      offsetY = -editorCanvas.height / 2;
    }
    if (Math.abs(offsetY - editorCanvas.height / 2) < snapThreshold) {
      offsetY = editorCanvas.height / 2;
    }
  }

  editorCanvas.addEventListener('touchstart', function(e) {
    e.preventDefault();
    if (e.touches.length === 1) {
      lastX = e.touches[0].clientX;
      lastY = e.touches[0].clientY;
    } else if (e.touches.length === 2) {
      initialDistance = getDistance(e.touches[0], e.touches[1]);
    }
  });

  editorCanvas.addEventListener('touchmove', function(e) {
    e.preventDefault();
    if (e.touches.length === 1) {
      const deltaX = e.touches[0].clientX - lastX;
      const deltaY = e.touches[0].clientY - lastY;
      lastX = e.touches[0].clientX;
      lastY = e.touches[0].clientY;
      offsetX += deltaX;
      offsetY += deltaY;
      applyTransformations();
    } else if (e.touches.length === 2) {
      const newDistance = getDistance(e.touches[0], e.touches[1]);
      if (initialDistance) {
        const scaleChange = newDistance / initialDistance;
        scale = Math.max(0.5, Math.min(3, scale * scaleChange));
        initialDistance = newDistance;
        applyTransformations();
      }
    }
  });

  editorCanvas.addEventListener('touchend', function(e) {
    e.preventDefault();
    if (e.touches.length === 0) {
      initialDistance = null;
      applyTransformations();
    }
  });

  function getDistance(touch1, touch2) {
    const dx = touch2.clientX - touch1.clientX;
    const dy = touch2.clientY - touch1.clientY;
    return Math.sqrt(dx * dx + dy * dy);
  }

  document.addEventListener('touchmove', function(e) {
    if (imageEditorModal.style.display === 'flex') {
      e.preventDefault();
    }
  }, { passive: false });

  document.getElementById('rotateLeft').addEventListener('click', function() {
    rotation += 90;
    applyTransformations();
  });

  document.getElementById('applyChanges').addEventListener('click', function(event) {
    event.preventDefault();
    editorCanvas.toBlob(function(blob) {
      const fileInput = document.getElementById('reg_mb_img');
      const file = new File([blob], 'edited_profile.png', { type: 'image/png' });
      const dataTransfer = new DataTransfer();
      dataTransfer.items.add(file);
      fileInput.files = dataTransfer.files;

      document.getElementById('profileImage').src = editorCanvas.toDataURL();
      imageEditorModal.style.display = 'none';
      document.body.style.overflow = '';
    });
  });

// 취소 버튼 클릭 시 기본 프로필 이미지로 되돌리기
document.getElementById('cancelEdit').addEventListener('click', function(event) {
  event.preventDefault();
  
  // 모달 닫기 및 스크롤 잠금 해제
  imageEditorModal.style.display = 'none';
  document.body.style.overflow = '';

  // 파일 입력 초기화
  const fileInput = document.getElementById('reg_mb_img');
  fileInput.value = ''; // 파일 선택 초기화

  // 이전 기본 이미지 다시 설정
  const profileImage = document.getElementById('profileImage');
  profileImage.src = "<?php echo $w == 'u' && file_exists($mb_img_path) ? $mb_img_url : $config['cf_member_image_url']; ?>";

  // 상태 변수 초기화 (필요한 경우)
  offsetX = 0;
  offsetY = 0;
  scale = 1;
  rotation = 0;
});

</script>


<!-- 24.12.04 | https://dsclub.kr/code/1074 | 회원가입 시 캡챠 검증 안하는 오류 해결{ -->
    <script>
    $(function() {
        $("#reg_zip_find").css("display", "inline-block");

        <?php if($config['cf_cert_use'] && $config['cf_cert_ipin']) { ?>
        // 아이핀인증
        $("#win_ipin_cert").click(function(e) {
            if(!cert_confirm())
                return false;

            var url = "<?php echo G5_OKNAME_URL; ?>/ipin1.php";
            certify_win_open('kcb-ipin', url, e);
            return;
        });

        <?php } ?>
        <?php if($config['cf_cert_use'] && $config['cf_cert_hp']) { ?>
        // 휴대폰인증
        $("#win_hp_cert").click(function(e) {
            if(!cert_confirm())
                return false;

            <?php
            switch($config['cf_cert_hp']) {
                case 'kcb':
                    $cert_url = G5_OKNAME_URL.'/hpcert1.php';
                    $cert_type = 'kcb-hp';
                    break;
                case 'kcp':
                    $cert_url = G5_KCPCERT_URL.'/kcpcert_form.php';
                    $cert_type = 'kcp-hp';
                    break;
                case 'lg':
                    $cert_url = G5_LGXPAY_URL.'/AuthOnlyReq.php';
                    $cert_type = 'lg-hp';
                    break;
                default:
                    echo 'alert("기본환경설정에서 휴대폰 본인확인 설정을 해주십시오");';
                    echo 'return false;';
                    break;
            }
            ?>

            certify_win_open("<?php echo $cert_type; ?>", "<?php echo $cert_url; ?>", e);
            return;
        });
        <?php } ?>
    });

    // 인증체크
    function cert_confirm()
    {
        var val = document.fregisterform.cert_type.value;
        var type;

        switch(val) {
            case "ipin":
                type = "아이핀";
                break;
            case "hp":
                type = "휴대폰";
                break;
            default:
                return true;
        }

        if(confirm("이미 "+type+"으로 본인확인을 완료하셨습니다.\n\n이전 인증을 취소하고 다시 인증하시겠습니까?"))
            return true;
        else
            return false;
    }

    // submit 최종 폼체크
    function fregisterform_submit(f)
    {
        // 회원아이디 검사
        if (f.w.value == "") {
            var msg = reg_mb_id_check();
            if (msg) {
                alert(msg);
                f.mb_id.select();
                return false;
            }
        }

        if (f.w.value == '') {
            if (f.mb_password.value.length < 3) {
                alert('비밀번호를 3글자 이상 입력하십시오.');
                f.mb_password.focus();
                return false;
            }
        }

        if (f.mb_password.value != f.mb_password_re.value) {
            alert('비밀번호가 같지 않습니다.');
            f.mb_password_re.focus();
            return false;
        }

        if (f.mb_password.value.length > 0) {
            if (f.mb_password_re.value.length < 3) {
                alert('비밀번호를 3글자 이상 입력하십시오.');
                f.mb_password_re.focus();
                return false;
            }
        }

        // 이름 검사
        if (f.w.value=='') {
            if (f.mb_name.value.length < 1) {
                alert('이름을 입력하십시오.');
                f.mb_name.focus();
                return false;
            }
        }

        <?php if($w == '' && $config['cf_cert_use'] && $config['cf_cert_req']) { ?>
        // 본인확인 체크
        if(f.cert_no.value=="") {
            alert("회원가입을 위해서는 본인확인을 해주셔야 합니다.");
            return false;
        }
        <?php } ?>

        // 닉네임 검사
        if ((f.w.value == "") || (f.w.value == "u" && f.mb_nick.defaultValue != f.mb_nick.value)) {
            var msg = reg_mb_nick_check();
            if (msg) {
                alert(msg);
                f.reg_mb_nick.select();
                return false;
            }
        }

        // E-mail 검사
        if ((f.w.value == "") || (f.w.value == "u" && f.mb_email.defaultValue != f.mb_email.value)) {
            var msg = reg_mb_email_check();
            if (msg) {
                alert(msg);
                f.reg_mb_email.select();
                return false;
            }
        }

        <?php if (($config['cf_use_hp'] || $config['cf_cert_hp']) && $config['cf_req_hp']) {  ?>
        // 휴대폰번호 체크
        var msg = reg_mb_hp_check();
        if (msg) {
            alert(msg);
            f.reg_mb_hp.select();
            return false;
        }
        <?php } ?>

        if (typeof f.mb_img != "undefined") {
            if (f.mb_img.value) {
                if (!f.mb_img.value.toLowerCase().match(/.(gif|jpe?g|png)$/i)) {
                    alert("회원아이콘이 이미지 파일이 아닙니다.");
                    f.mb_img.focus();
                    return false;
                }
            }
        }

        if (typeof f.mb_img != "undefined") {
            if (f.mb_img.value) {
                if (!f.mb_img.value.toLowerCase().match(/.(gif|jpe?g|png)$/i)) {
                    alert("회원이미지가 이미지 파일이 아닙니다.");
                    f.mb_img.focus();
                    return false;
                }
            }
        }

        if (typeof(f.mb_recommend) != 'undefined' && f.mb_recommend.value) {
            if (f.mb_id.value == f.mb_recommend.value) {
                alert('본인을 추천할 수 없습니다.');
                f.mb_recommend.focus();
                return false;reg_mb_img
            }

            var msg = reg_mb_recommend_check();
            if (msg) {
                alert(msg);
                f.mb_recommend.select();
                return false;
            }
        }

        <?php echo chk_captcha_js(); ?>

        document.getElementById("btn_submit").disabled = "disabled";

        return true;
    }

	var uploadFile = $('.filebox .uploadBtn');
	uploadFile.on('change', function(){
		if(window.FileReader){
			var filename = $(this)[0].files[0].name;
		} else {
			var filename = $(this).val().split('/').pop().split('\\').pop();
		}
		$(this).siblings('.fileName').val(filename);
	});
    </script>
</div>

<!-- 하단 바 프로필 나타나는 오류 무식하게 해결{ -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    // 프로필 이미지가 포함된 부모 요소를 숨김 처리
    const profileImageContainer = document.querySelector('.fprofile_img');
    if (profileImageContainer) {
        profileImageContainer.style.display = 'none'; // 또는 'visibility: hidden;'
    }
});
</script>
<!-- 보안을 위한 개발자 도구 제한{ -->
<?php
// 개발자 도구 사용 감지
if (isset($_SERVER['HTTP_USER_AGENT']) && stripos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false && stripos($_SERVER['HTTP_USER_AGENT'], 'Edg') === false && stripos($_SERVER['HTTP_USER_AGENT'], 'Firefox') === false && stripos($_SERVER['HTTP_USER_AGENT'], 'Safari') === false) {
    // 개발자 도구 사용 시 오류 메시지 출력
    http_response_code(403);
    echo "개발자 도구 사용이 금지되어 있습니다.";
    exit;
}
?>
<script>
// F12 키 막기
document.addEventListener('keydown', function(event) {
  if (event.keyCode == 123) {
    event.preventDefault();
    return false;
  }
});

// 개발자 도구 열기 막기
document.addEventListener('contextmenu', function(e) {
  e.preventDefault();
});

// 개발자 도구 콘솔 막기
if (window.console) {
  console.log = function() {};
  console.error = function() {};
  console.warn = function() {};
  console.info = function() {};
  console.debug = function() {};
}
</script>
<?php
// 브라우저에서 JavaScript 사용 여부 확인
if (!isset($_SERVER['HTTP_USER_AGENT']) || !preg_match('/(?i)msie|trident|firefox|safari|opera|chrome/', $_SERVER['HTTP_USER_AGENT'])) {
    // JavaScript를 사용하지 않는 경우 리다이렉트
    header('Location: http://dsclub.kr');
    exit;
}
?>