<?php
session_start();
include('connect.php');

// 로그인 여부 (예: 로그인 안 했다면 로그인 페이지로 이동)
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// 게시글 목록 조회
try {
    $sql = "SELECT post_id, user_id, title, created_at FROM zb_posts ORDER BY post_id DESC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>게시판 목록</title>

    <!-- 모바일 전용 CSS -->
    <style>
        /* 전체 레이아웃 */
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
        }

        .container {
            width: 90%;
            margin: 0 auto;
            padding: 15px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            font-size: 1.2rem;
            margin-bottom: 15px;
            color: #333;
        }

        /* 테이블 스타일 */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th, td {
            text-align: left;
            padding: 10px;
            font-size: 0.9rem;
            border-bottom: 1px solid #ddd;
        }

        td:first-child {
            font-weight: bold;
            color: #555;
        }

        td:last-child {
            word-break: break-word; /* 긴 텍스트 자동 줄바꿈 */
        }

        a {
            color: #000000;
            text-decoration: none;
			font-weight: bolder;
        }

        a:hover {
            text-decoration: underline;
        }

        /* 버튼 스타일 */
        button {
            width: 100%;
            padding: 12px;
            background-color: #007BFF;
            color: #fff;
            border: none;
            border-radius: 6px;
            font-size: 1rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
            text-align: center;
        }

        button:hover {
            background-color: #0056b3;
        }

        /* 빈 행 스타일 */
        tr[style] {
            height: 10px;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>게시판 목록</h1>
    <table>

        <?php if ($posts): ?>
            <?php foreach ($posts as $post): ?>
                <!-- 글 정보 표시 -->
                <tr>
                    <td>번호</td>
                    <td><?php echo htmlspecialchars($post['post_id']); ?></td>
                </tr>
                
                <tr>
                    <td>제목</td>
                    <td>
                        <a href="board_view.php?post_id=<?php echo $post['post_id']; ?>">
                            <?php echo htmlspecialchars($post['title']); ?>
                        </a>
                    </td>
                </tr>
                
                <tr>
                    <td>작성자</td>
                    <td>
                        <?php echo htmlspecialchars($post['user_id']); ?>
                        &nbsp;&nbsp;
                        <?php echo htmlspecialchars($post['created_at']); ?>
                    </td>
                </tr>
                
                <!-- 간격(빈 행) -->
                <tr style="border:none; height:10px;">
                    <td style="border:none;"></td>
                    <td style="border:none;"></td>
                </tr>

            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="2">게시글이 없습니다.</td></tr>
        <?php endif; ?>

    </table>
    <button onclick="location.href='board_write.php'">글 작성하기</button>
</div>
</body>
</html>
