<?php
session_start();
include('connect.php');

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $post_id = $_POST['post_id'] ?? null;
    $comment = trim($_POST['comment'] ?? '');
    $user_id = $_SESSION['user_id'];

    if (!$post_id || $comment === '') {
        // 필수 데이터 부족 → 그냥 게시글 상세로 돌아감
        header("Location: board_view.php?post_id={$post_id}");
        exit;
    }

    try {
        $sql = "INSERT INTO zb_comments (post_id, user_id, comment)
                VALUES (:post_id, :user_id, :comment)";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
        $stmt->bindValue(':user_id', $user_id);
        $stmt->bindValue(':comment', $comment);
        $stmt->execute();
    } catch (Exception $e) {
        // 에러 처리(실제 서비스에선 로그를 남기거나 할 수 있음)
    }

    // 댓글 작성 후 해당 게시글로 이동
    header("Location: board_view.php?post_id={$post_id}");
    exit;
} else {
    // GET 방식 등으로 접근 시 목록으로
    header("Location: board_list.php");
    exit;
}
