<?php
session_start();
include('connect.php');

// 관리자 체크
if (!isset($_SESSION['user_id']) || $_SESSION['is_admin'] != 1) {
    // 관리자만 접근 가능
    header("Location: board_list.php");
    exit;
}

try {
    // 모든 게시글 조회 (삭제여부 상관없이)
    $sql = "SELECT post_id, user_id, title, created_at FROM zb_posts ORDER BY post_id DESC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 모든 댓글 조회
    $sqlC = "SELECT comment_id, post_id, user_id, comment, created_at FROM zb_comments ORDER BY comment_id DESC";
    $stmtC = $conn->prepare($sqlC);
    $stmtC->execute();
    $comments = $stmtC->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("관리자 대시보드 오류: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>관리자 대시보드</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .container { max-width: 800px; margin: 20px auto; background: #fff; padding: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background: #333; color: #fff; }
        h2 { margin-top: 40px; }
    </style>
</head>
<body>
<div class="container">
    <h1>관리자 대시보드</h1>
    <p><?php echo htmlspecialchars($_SESSION['user_id']); ?>님 (관리자) 안녕하세요.</p>
    <hr>

    <h2>게시글 관리</h2>
    <table>
        <thead>
            <tr>
                <th>글번호</th>
                <th>제목</th>
                <th>작성자</th>
                <th>작성일</th>
                <th>관리</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($posts): ?>
            <?php foreach($posts as $p): ?>
            <tr>
                <td><?php echo $p['post_id']; ?></td>
                <td><?php echo htmlspecialchars($p['title']); ?></td>
                <td><?php echo htmlspecialchars($p['user_id']); ?></td>
                <td><?php echo $p['created_at']; ?></td>
                <td>
                    <a href="board_view.php?post_id=<?php echo $p['post_id']; ?>">보기</a>
                    <!-- 강제 삭제 기능 예시 -->
                    <a href="board_delete.php?post_id=<?php echo $p['post_id']; ?>"
                       onclick="return confirm('정말 삭제하시겠습니까?')">삭제</a>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="5">게시글이 없습니다.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>

    <h2>댓글 관리</h2>
    <table>
        <thead>
            <tr>
                <th>댓글번호</th>
                <th>게시글ID</th>
                <th>작성자</th>
                <th>내용</th>
                <th>작성일</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($comments): ?>
            <?php foreach($comments as $c): ?>
            <tr>
                <td><?php echo $c['comment_id']; ?></td>
                <td><?php echo $c['post_id']; ?></td>
                <td><?php echo htmlspecialchars($c['user_id']); ?></td>
                <td><?php echo htmlspecialchars($c['comment']); ?></td>
                <td><?php echo $c['created_at']; ?></td>
                <!-- 댓글 별도 삭제 로직 등 구현 가능 -->
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="5">댓글이 없습니다.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
    <br>
    <button onclick="location.href='board_list.php'">게시판으로</button>
</div>
</body>
</html>
