<?php
// db 연결 파일
include('connect.php');

try {
    // zb_users 테이블 생성
    $sqlCreateUsers = "
        CREATE TABLE IF NOT EXISTS zb_users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id VARCHAR(50) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(255) UNIQUE NOT NULL,
            is_admin BOOLEAN DEFAULT FALSE,
            photo VARCHAR(255),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
    ";
    $conn->exec($sqlCreateUsers);
    echo "테이블 zb_users 생성 완료 (또는 이미 존재).<br>";

    // zb_posts 테이블 생성
    $sqlCreatePosts = "
        CREATE TABLE IF NOT EXISTS zb_posts (
            post_id INT AUTO_INCREMENT PRIMARY KEY,
            user_id VARCHAR(50) NOT NULL,
            title VARCHAR(255) NOT NULL,
            content TEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP NULL,
            CONSTRAINT fk_posts_user
                FOREIGN KEY (user_id)
                REFERENCES zb_users(user_id)
                ON DELETE CASCADE
                ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
    ";
    $conn->exec($sqlCreatePosts);
    echo "테이블 zb_posts 생성 완료 (또는 이미 존재).<br>";

    // zb_comments 테이블 생성
    $sqlCreateComments = "
        CREATE TABLE IF NOT EXISTS zb_comments (
            comment_id INT AUTO_INCREMENT PRIMARY KEY,
            post_id INT NOT NULL,
            user_id VARCHAR(50) NOT NULL,
            comment TEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP NULL,
            CONSTRAINT fk_comments_posts
                FOREIGN KEY (post_id)
                REFERENCES zb_posts(post_id)
                ON DELETE CASCADE
                ON UPDATE CASCADE,
            CONSTRAINT fk_comments_user
                FOREIGN KEY (user_id)
                REFERENCES zb_users(user_id)
                ON DELETE CASCADE
                ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
    ";
    $conn->exec($sqlCreateComments);
    echo "테이블 zb_comments 생성 완료 (또는 이미 존재).<br>";

} catch (PDOException $e) {
    echo "테이블 생성 실패: " . $e->getMessage();
}

// DB 연결 닫기
$conn = null;
