<?php
include('connect.php');

$id = $_GET['id'];
$sql = "SELECT * FROM z_users WHERE id = :id";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':id', $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $introduce = $_POST['introduce'];

    // File upload handling for image
    $imagePath = $row['image']; // Default to current image
    if (!empty($_FILES['image']['name'])) {
        $imageTargetDir = "uploads/image/";
        $imageFileName = uniqid() . "_" . basename($_FILES['image']['name']);
        $imageTargetFilePath = $imageTargetDir . $imageFileName;
        if (move_uploaded_file($_FILES['image']['tmp_name'], $imageTargetFilePath)) {
            $imagePath = $imageTargetFilePath;
        }
    }

    // File upload handling for music
    $musicPath = $row['music']; // Default to current music
    if (!empty($_FILES['music']['name'])) {
        $musicTargetDir = "uploads/music/";
        $musicFileName = uniqid() . "_" . basename($_FILES['music']['name']);
        $musicTargetFilePath = $musicTargetDir . $musicFileName;
        if (move_uploaded_file($_FILES['music']['tmp_name'], $musicTargetFilePath)) {
            $musicPath = $musicTargetFilePath;
        }
    }

    $sqlUpdate = "UPDATE z_users SET name = :name, introduce = :introduce, image = :image, music = :music WHERE id = :id";
    $stmtUpdate = $conn->prepare($sqlUpdate);
    $stmtUpdate->bindParam(':name', $name);
    $stmtUpdate->bindParam(':introduce', $introduce);
    $stmtUpdate->bindParam(':image', $imagePath);
    $stmtUpdate->bindParam(':music', $musicPath);
    $stmtUpdate->bindParam(':id', $id, PDO::PARAM_INT);

    if ($stmtUpdate->execute()) {
        echo "Record updated successfully.";
        header("Location: select.php");
        exit;
    } else {
        echo "Error updating record.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Data</title>
</head>
<body>
    <h2>Edit Data</h2>
    <form method="post" action="" enctype="multipart/form-data">
        <table>
            <tr>
                <td>Name:</td>
                <td><input type="text" name="name" value="<?php echo $row['name']; ?>" required></td>
            </tr>
            <tr>
                <td>Image:</td>
                <td><input type="file" name="image"></td>
            </tr>
            <tr>
                <td>Music:</td>
                <td><input type="file" name="music"></td>
            </tr>
            <tr>
                <td>Introduce:</td>
                <td><input type="text" name="introduce" value="<?php echo $row['introduce']; ?>" required></td>
            </tr>
            <tr>
                <td colspan="2"><input type="submit" value="Save Changes"></td>
            </tr>
        </table>
    </form>
</body>
</html>
