<?php
include('connect.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form inputs
    $name = $_POST['name'];
    $introduce = $_POST['introduce'];

    // File upload handling for image
    $imageTargetDir = "uploads/image/";
    $imageFileName = basename($_FILES['image']['name']);
    $imageTargetFilePath = $imageTargetDir . $imageFileName;
    $imageFileType = strtolower(pathinfo($imageTargetFilePath, PATHINFO_EXTENSION));

    // File upload handling for music
    $musicTargetDir = "uploads/music/";
    $musicFileName = basename($_FILES['music']['name']);
    $musicTargetFilePath = $musicTargetDir . $musicFileName;
    $musicFileType = strtolower(pathinfo($musicTargetFilePath, PATHINFO_EXTENSION));

    // Ensure upload directories exist
    if (!is_dir($imageTargetDir)) {
        mkdir($imageTargetDir, 0777, true);
    }
    if (!is_dir($musicTargetDir)) {
        mkdir($musicTargetDir, 0777, true);
    }

    // Validate and upload image file
    if (move_uploaded_file($_FILES['image']['tmp_name'], $imageTargetFilePath)) {
        $imagePath = $imageTargetFilePath;
    } else {
        echo "Error uploading image file.";
        exit;
    }

    // Validate and upload music file
    if (move_uploaded_file($_FILES['music']['tmp_name'], $musicTargetFilePath)) {
        $musicPath = $musicTargetFilePath;
    } else {
        echo "Error uploading music file.";
        exit;
    }

    // Prepare SQL query
    $sql = "INSERT INTO z_users (name, image, music, introduce) VALUES (:name, :image, :music, :introduce)";

    try {
        // Prepare statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':image', $imagePath);
        $stmt->bindParam(':music', $musicPath);
        $stmt->bindParam(':introduce', $introduce);

        // Execute the statement
        if ($stmt->execute()) {
            echo "New record created successfully.";
        } else {
            echo "Error: Could not execute query.";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    // Close the connection
    $conn = null;
}
?>
