<?php
include('connect.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form inputs
    $name = $_POST['name'];
    $introduce = $_POST['introduce'];

    // File upload handling for image
    $imageTargetDir = "uploads/image/";
    $imageFileName = basename($_FILES['image']['name']);
    $imageTargetFilePath = $imageTargetDir . $imageFileName;
    $imageFileType = strtolower(pathinfo($imageTargetFilePath, PATHINFO_EXTENSION));

    // File upload handling for music
    $musicTargetDir = "uploads/music/";
    $musicFileName = basename($_FILES['music']['name']);
    $musicTargetFilePath = $musicTargetDir . $musicFileName;
    $musicFileType = strtolower(pathinfo($musicTargetFilePath, PATHINFO_EXTENSION));
    $musicFileSize = $_FILES['music']['size'];

    // Ensure upload directories exist
    if (!is_dir($imageTargetDir)) {
        mkdir($imageTargetDir, 0777, true);
    }
    if (!is_dir($musicTargetDir)) {
        mkdir($musicTargetDir, 0777, true);
    }

    // Validate name using regex
    if (!preg_match('/^[\p{L}a-zA-Z0-9_-]+$/u', $name)) {
        echo "Error: Name can only contain Korean, English letters, numbers, underscores, and hyphens.";
        exit;
    }

    // Validate image file type
    $allowedImageExtensions = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($imageFileType, $allowedImageExtensions)) {
        echo "Error: Only JPG, JPEG, PNG, and GIF files are allowed for images.";
        exit;
    }

    // Validate music file type and size
    if ($musicFileType !== 'mp3') {
        echo "Error: Only MP3 files are allowed for music.";
        exit;
    }
    if ($musicFileSize > 10 * 1024 * 1024) { // 10 MB limit
        echo "Error: Music file size must not exceed 10MB.";
        exit;
    }

    // Validate and upload image file
    if (move_uploaded_file($_FILES['image']['tmp_name'], $imageTargetFilePath)) {
        $imagePath = $imageTargetFilePath;
    } else {
        echo "Error uploading image file.";
        exit;
    }

    // Validate and upload music file
    if (move_uploaded_file($_FILES['music']['tmp_name'], $musicTargetFilePath)) {
        $musicPath = $musicTargetFilePath;
    } else {
        echo "Error uploading music file.";
        exit;
    }

    // Prepare SQL query
    $sql = "INSERT INTO z_users (name, image, music, introduce) VALUES (:name, :image, :music, :introduce)";

    try {
        // Prepare statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':image', $imagePath);
        $stmt->bindParam(':music', $musicPath);
        $stmt->bindParam(':introduce', $introduce);

        // Execute the statement
        if ($stmt->execute()) {
            echo "New record created successfully.<br><br>";
			echo "<a href='index.php' style='display: inline-block; padding: 10px 20px; background-color: #007BFF; color: white; text-decoration: none; border-radius: 5px;'>Go to Index</a>";       
        } else {
            echo "Error: Could not execute query.";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    // Close the connection
    $conn = null;
}
?>
