<?php
// 모바일 여부 감지 함수
function isMobile() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $mobileAgents = ['iPhone', 'iPad', 'Android', 'webOS', 'BlackBerry', 'Windows Phone', 'Opera Mini', 'IEMobile'];
    foreach ($mobileAgents as $device) {
        if (stripos($userAgent, $device) !== false) {
            return true;
        }
    }
    return false;
}

// 로그인 리다이렉트
function redirectToLogin() {
    if (isMobile()) {
        header('Location: login_mobile.php'); // 모바일 로그인 페이지
    } else {
        header('Location: login_pc.php'); // PC 로그인 페이지
    }
    exit;
}

// 사용자가 이미 로그인했는지 확인 (예: 세션)
session_start();
if (isset($_SESSION['user_id'])) {
    // 로그인 상태면 대시보드나 게시판으로 이동
    header('Location: dashboard.php'); 
    exit;
}

// 리다이렉트 실행
redirectToLogin();
