<?php
session_start(); // 세션 시작
$error = ''; // 에러 메시지 초기화

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include('connect.php'); // 데이터베이스 연결

    $user_id = trim($_POST['user_id']);
    $password = trim($_POST['password']);

    // 입력값 검증
    if (empty($user_id) || empty($password)) {
        $error = "User ID와 Password를 입력하세요.";
    } else {
        // 데이터베이스에서 사용자 정보 조회
        $sql = "SELECT id, user_id, password, is_admin FROM zb_users WHERE user_id = :user_id";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':user_id', $user_id);
        $stmt->execute();
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            // 비밀번호 검증
            if (password_verify($password, $user['password'])) {
                // 세션 저장
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['is_admin'] = $user['is_admin'];
                $_SESSION['id'] = $user['id'];

                // 관리자와 일반 회원 구분
                if ($user['is_admin'] == 1) {
                    header('Location: admin_dashboard_mobile.php'); // 관리자 페이지로 이동
                } else {
                    header('Location: user_dashboard_mobile.php'); // 일반 사용자 페이지로 이동
                }
                exit;
            } else {
                $error = "비밀번호가 일치하지 않습니다.";
            }
        } else {
            $error = "User ID가 존재하지 않습니다.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MOBILE 로그인</title>
    <style>
        /* 전체 레이아웃 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f4f4f4; /* 모바일에 적합한 밝은 배경 */
        }

        /* 로고 이미지 */
        img {
            max-width: 80%; /* 모바일 화면에서 적절한 크기로 조정 */
            display: block;
            margin: 0 auto 20px; /* 아래에 여백 추가 */
        }

        /* 로그인 폼 */
        form {
            background: #ffffff;
            padding: 20px;
            border-radius: 10px; /* 둥근 모서리 */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* 은은한 그림자 */
            width: 90%; /* 모바일 화면에서 적합한 너비 */
            max-width: 360px; /* 최대 너비 제한 */
            box-sizing: border-box;
        }

        /* 폼 라벨 */
        label {
            display: block;
            margin-bottom: 10px; /* 간격 확대 */
            font-weight: bold;
            font-size: 14px; /* 모바일에 적합한 크기 */
        }

        /* 입력 필드 */
        input {
            width: 100%; /* 부모 요소에 맞게 넓이 조정 */
            padding: 12px; /* 패딩 확대 */
            margin-bottom: 20px; /* 간격 추가 */
            border: 1px solid #ddd;
            border-radius: 6px; /* 둥근 모서리 */
            font-size: 16px;
            box-sizing: border-box;
        }

        /* 버튼 */
        button {
            width: 100%;
            padding: 12px; /* 버튼 크기 조정 */
            background: #007BFF;
            color: white;
            border: none;
            border-radius: 6px; /* 둥근 모서리 */
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        button:hover {
            background: #0056b3; /* 호버 시 어두운 색 */
        }

        /* 에러 메시지 */
        .error {
            color: red;
            margin-bottom: 15px;
            font-size: 14px; /* 에러 메시지 크기 조정 */
            text-align: center;
        }

        /* 회원가입 링크 */
        .signup-link {
            margin-top: 20px;
            text-align: center;
        }

        .signup-link a {
            color: #007BFF;
            text-decoration: none;
            font-size: 14px;
        }

        .signup-link a:hover {
            text-decoration: underline;
        }

        /* 헤딩 스타일 */
        h1, h2 {
            text-align: center;
            margin: 10px 0;
            color: #333;
        }

        h1 {
            font-size: 20px; /* 타이틀 폰트 크기 */
        }

        h2 {
            font-size: 16px; /* 부제목 폰트 크기 */
            color: #666;
        }
    </style>
</head>
<body>
    <form method="POST" action="login_mobile.php">

		
<!-- images with affect effect vidoe start -->
<style>
.effect-div { width:100%; background-size:cover; overflow:hidden; position:relative; margin-top: 0px;margin-left: 0px;margin-right: 0px;margin-bottom: 0px;}
.effect-div video { width:100%; mix-blend-mode:screen; }
</style>
  
<div class=effect-div style="background-image:url('http://egis.kr/zz/images/500/u1920.png')">
    <video src="http://egis.kr/zz/video/kims/cosmic_power.mp4" autoplay loop muted></video>
</div>
     
<script>
onresize = function() {
    for (effect_div of document.getElementsByClassName("effect-div")) effect_div.style.height = effect_div.offsetWidth * 9 / 16 + "px";
}
onresize();
</script>
<!-- images with affect effect vidoe end -->

		
        <!-- 헤딩 -->
        <h1>MOBILE 로그인</h1>

        <!-- 에러 메시지 -->
        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <!-- 입력 필드 -->
        <label for="user_id">User ID:</label>
        <input type="text" id="user_id" name="user_id" required>

        <label for="password">Password:</label>
        <input type="password" id="password" name="password" required>

        <!-- 로그인 버튼 -->
        <button type="submit">로그인</button>

        <!-- 회원가입 링크 -->
        <div class="signup-link">
            <a href="signup.php">회원가입</a>
        </div>
    </form>
</body>
</html>
