<?php
session_start(); // 세션 시작
$error = ''; // 에러 메시지 초기화

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include('db/connect.php'); // 데이터베이스 연결

    $user_id = trim($_POST['user_id']);
    $password = trim($_POST['password']);

    // 입력값 검증
    if (empty($user_id) || empty($password)) {
        $error = "User ID와 Password를 입력하세요.";
    } else {
        // 데이터베이스에서 사용자 정보 조회
        $sql = "SELECT id, user_id, password, is_admin FROM zb_users WHERE user_id = :user_id";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':user_id', $user_id);
        $stmt->execute();
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            // 비밀번호 검증
            if (password_verify($password, $user['password'])) {
                // 세션 저장
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['is_admin'] = $user['is_admin'];
                $_SESSION['id'] = $user['id'];

                // 관리자와 일반 회원 구분
                if ($user['is_admin'] == 1) {
                    header('Location: admin_dashboard_pc.php'); // 관리자 페이지로 이동
                } else {
                    header('Location: user_dashboard_pc.php'); // 일반 사용자 페이지로 이동
                }
                exit;
            } else {
                $error = "비밀번호가 일치하지 않습니다.";
            }
        } else {
            $error = "User ID가 존재하지 않습니다.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>로그인</title>
    <style>
        /* 전체 레이아웃 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f2f2f2; /* 조금 더 밝은 배경색 */
        }

        /* 로고 이미지 */
        img {
            max-width: 100%;
            max-height: 150px; /* 크기를 제한하여 균형 유지 */
            display: block;
            margin: 0 auto 20px;
        }

        /* 로그인 폼 */
        form {
            background: #ffffff;
            padding: 30px; /* 여백 증가 */
            border-radius: 10px; /* 더 둥근 모서리 */
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2); /* 그림자 강조 */
            width: 100%;
            max-width: 450px; /* 더 넓은 최대 너비 */
            box-sizing: border-box;
        }

        /* 레이블 */
        label {
            display: block;
            margin-bottom: 10px; /* 간격 증가 */
            font-weight: bold;
            font-size: 16px; /* 폰트 크기 증가 */
        }

        /* 입력 필드 */
        input {
            width: 100%;
            padding: 12px; /* 패딩 증가 */
            margin-bottom: 20px; /* 하단 간격 증가 */
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
        }

        /* 버튼 */
        button {
            width: 100%;
            padding: 12px;
            background: #007BFF;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 18px; /* 버튼 폰트 크기 증가 */
            cursor: pointer;
            transition: background 0.3s ease;
        }

        button:hover {
            background: #0056b3;
        }

        /* 에러 메시지 */
        .error {
            color: red;
            margin-bottom: 20px;
            font-size: 14px;
            text-align: center; /* 에러 메시지 가운데 정렬 */
        }

        /* 회원가입 링크 */
        .signup-link {
            margin-top: 20px;
            text-align: center;
        }

        .signup-link a {
            color: #007BFF;
            text-decoration: none;
            font-size: 16px; /* 폰트 크기 증가 */
        }

        .signup-link a:hover {
            text-decoration: underline;
        }

        /* 헤딩 스타일 */
        h1, h2 {
            text-align: center;
            margin: 10px 0 20px;
            color: #333;
        }

        h1 {
            font-size: 24px; /* 큰 타이틀 폰트 크기 */
        }

        h2 {
            font-size: 20px; /* 부 타이틀 폰트 크기 */
            color: #555;
        }
    </style>
</head>
	
<body>
    <form method="POST" action="login_pc.php">
		
	
		<!-- images with affect effect vidoe start -->
<style>
.effect-div { width:100%; background-size:cover; overflow:hidden; position:relative; margin-top: 0px;margin-left: 0px;margin-right: 0px;margin-bottom: 0px;}
.effect-div video { width:100%; mix-blend-mode:screen; }
</style>
  
<div class=effect-div style="background-image:url('http://egis.kr/zz/images/500/u1920.png')">
    <video src="http://egis.kr/zz/video/kims/fog_lights.mp4" autoplay loop muted></video>
</div>
     
<script>
onresize = function() {
    for (effect_div of document.getElementsByClassName("effect-div")) effect_div.style.height = effect_div.offsetWidth * 9 / 16 + "px";
}
onresize();
</script>
<!-- images with affect effect vidoe end -->
		
		
        <h1>PC 로그인</h1>

        <!-- 에러 메시지 -->
        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <!-- 입력 필드 -->
        <label for="user_id">User ID:</label>
        <input type="text" id="user_id" name="user_id" required>

        <label for="password">Password:</label>
        <input type="password" id="password" name="password" required>

        <!-- 로그인 버튼 -->
        <button type="submit">로그인</button>

        <!-- 회원가입 링크 -->
        <div class="signup-link">
            <a href="signup.php">회원가입</a>
        </div>
    </form>
</body>
</html>
