<?php
// 데이터베이스 연결 파일 포함
include('db/connect.php');

// 에러 표시 활성화
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try {
    // 입력값 가져오기
    $user_id = trim($_POST['user_id']);
    $password = trim($_POST['password']);
    $email = trim($_POST['email']);
    $is_admin = trim($_POST['is_admin']);
    $photo = isset($_FILES['photo']) ? $_FILES['photo'] : null;

    // user_id 검증
    if (!preg_match('/^[a-zA-Z0-9_-]+$/', $user_id)) {
        die("User ID는 영문자, 숫자, '_', '-'만 사용할 수 있습니다.");
    }

    // 이메일 검증
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("유효한 이메일 주소를 입력하세요.");
    }

    // 비밀번호 해시화
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // 사진 업로드 처리
    $photoPath = null;
    if ($photo && $photo['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/photos/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $photoPath = $uploadDir .  basename($photo['name']);
        if (!move_uploaded_file($photo['tmp_name'], $photoPath)) {
            die("사진 업로드 실패.");
        }
    }

    // 데이터베이스 삽입
    $sql = "INSERT INTO zb_users (user_id, password, email, is_admin, photo) VALUES (:user_id, :password, :email, :is_admin, :photo)";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':user_id', $user_id);
    $stmt->bindValue(':password', $hashedPassword);
    $stmt->bindValue(':email', $email);
    $stmt->bindValue(':is_admin', $is_admin);
    $stmt->bindValue(':photo', $photoPath);


	    if ($stmt->execute()) {
        // 회원가입 성공 메시지 및 리다이렉트
        echo "<script>
                alert('회원가입이 완료되었습니다. 로그인 페이지로 이동합니다.');
                window.location.href = 'index.php';
              </script>";
        exit;
    } else {
        echo "회원가입 실패: " . implode(", ", $stmt->errorInfo());
    }
} catch (Exception $e) {
    echo "오류 발생: " . $e->getMessage();
}
?>
