<?php
session_start();

// 로그인 여부 확인
if (!isset($_SESSION['user_id'])) {
    // 로그인하지 않았다면 로그인 페이지로 이동
    header("Location: login.php");
    exit;
}

// DB 연결 파일 포함
include('db/connect.php');

// 에러 표시 활성화(개발 중에만 사용)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 로그인한 사용자 정보
$loggedInUserId = $_SESSION['user_id'];
$isAdmin = $_SESSION['is_admin'];  // 1이면 관리자, 0이면 일반회원

try {
    if ($isAdmin == 1) {
        // 관리자: 모든 회원 정보 조회
        $sql = "SELECT id, user_id, email, is_admin, photo, created_at
                FROM zb_users
                ORDER BY id ASC";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
    } else {
        // 일반회원: 본인 정보만 조회
        $sql = "SELECT id, user_id, email, is_admin, photo, created_at
                FROM zb_users
                WHERE user_id = :loggedInUserId
                LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':loggedInUserId', $loggedInUserId);
        $stmt->execute();
    }
    
    // 결과 세트 가져오기
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("회원 정보를 불러오는 중 오류 발생: " . $e->getMessage());
}

// DB 연결 해제 (선택적으로 수행)
$conn = null;
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>회원정보 조회</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h1.center {
            text-align: center;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            background-color: #f9f9f9;
        }
        th, td {
            text-align: left;
            padding: 8px 12px;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #007BFF;
            color: white;
        }
        img {
            max-width: 100px;
            height: auto;
        }
        .center {
            text-align: center;
        }
        .no-data {
            text-align: center;
            margin-top: 20px;
            color: #666;
        }
        /* 개인정보 수정 버튼 스타일 */
        .edit-btn {
            display: inline-block;
            padding: 6px 12px;
            margin-top: 8px;
            font-size: 14px;
            color: #fff;
            background-color: #28a745;
            text-decoration: none;
            border-radius: 4px;
        }
        .edit-btn:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>

<h1 class="center">회원정보 조회</h1>

<?php if (count($users) > 0): ?>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>User ID</th>
                <th>Email</th>
                <th>Role</th>
                <th>Photo</th>
                <th>가입일</th>
                <th>개인정보수정</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($users as $user): ?>
            <tr>
                <td><?php echo htmlspecialchars($user['id']); ?></td>
                <td><?php echo htmlspecialchars($user['user_id']); ?></td>
                <td><?php echo htmlspecialchars($user['email']); ?></td>
                <td>
                    <?php echo $user['is_admin'] ? '관리자' : '일반회원'; ?>
                </td>
                <td>
                    <?php if (!empty($user['photo'])): ?>
                        <!-- 웹에서 접근 가능한 경로와 일치해야 이미지가 표시됩니다 -->
                        <img src="<?php echo htmlspecialchars($user['photo']); ?>" alt="User Photo">
                    <?php else: ?>
                        사진 없음
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                <td>
                    <!-- 개인정보 수정 버튼: edit_info.php로 이동 -->
                    <a class="edit-btn" href="edit_info.php?user_id=<?php echo urlencode($user['user_id']); ?>">
                        수정
                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="no-data">등록된 회원이 없습니다.</div>
<?php endif; ?>

</body>
</html>
