<?php
// db 연결 파일 포함
include('connect.php');

// 에러 표시 활성화(개발 중에만 사용)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$message = '';

// (1) GET 파라미터로 삭제 처리
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $deleteId = (int)$_GET['id'];
    
    try {
        $sql = "DELETE FROM zb_users WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':id', $deleteId, PDO::PARAM_INT);
        $stmt->execute();
        
        $countDeleted = $stmt->rowCount();
        if ($countDeleted > 0) {
            $message = "회원(ID: {$deleteId})이(가) 삭제되었습니다.";
        } else {
            $message = "회원(ID: {$deleteId}) 삭제 실패 또는 존재하지 않는 회원입니다.";
        }
    } catch (Exception $e) {
        $message = "삭제 처리 중 오류 발생: " . $e->getMessage();
    }
}

// (2) 회원 목록 조회
try {
    $sql = "SELECT id, user_id, email, is_admin, photo, created_at
            FROM zb_users
            ORDER BY id ASC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("회원 정보를 불러오는 중 오류 발생: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <!-- 모바일 화면 최적화 -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>회원정보 조회(모바일)</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 10px;
            padding: 0;
            background-color: #f5f5f5;
        }
        h1.center {
            text-align: center;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }
        .message {
            text-align: center;
            color: red;
            margin-bottom: 10px;
        }
        .user-info {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin: 10px auto;
            padding: 10px;
            max-width: 500px;
            background-color: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        .user-info div {
            display: flex;
            justify-content: space-between;
            font-size: 0.9rem;
        }
        .user-info div strong {
            width: 35%;
            font-weight: bold;
        }
        .user-info div span, .user-info div img {
            width: 65%;
        }
        .user-info img {
            max-width: 100px;
            height: auto;
            border-radius: 5px;
        }
        /* 수정/삭제 버튼 영역 */
        .btn-area {
            display: flex;
            gap: 6px;
            margin-top: 5px;
        }
        a.btn {
            flex: 1; /* 한 줄에 버튼 2개 균등 분배 */
            padding: 6px 10px;
            font-size: 0.8rem;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
            text-align: center;
        }
        a.edit {
            background-color: #28a745;
        }
        a.delete {
            background-color: #dc3545;
        }
        a.edit:hover {
            background-color: #218838;
        }
        a.delete:hover {
            background-color: #c82333;
        }
    </style>
    <script>
        // 삭제 버튼 클릭 시 팝업 확인
        function confirmDelete(id) {
            if (confirm("정말로 해당 레코드를 삭제하시겠습니까?")) {
                // 확인을 누르면 현재 페이지의 ?action=delete&id=...로 이동
                window.location.href = "?action=delete&id=" + id;
            }
        }
    </script>
</head>
<body>

<h1 class="center">회원정보 조회 (모바일)</h1>

<!-- 삭제 결과 등이 있을 경우 메시지 표시 -->
<?php if (!empty($message)): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<?php if (count($users) > 0): ?>
    <?php foreach ($users as $user): ?>
        <div class="user-info">
            <div><strong>No:</strong> <span><?= htmlspecialchars($user['id']); ?></span></div>
            <div><strong>User ID:</strong> <span><?= htmlspecialchars($user['user_id']); ?></span></div>
            <div><strong>Email:</strong> <span><?= htmlspecialchars($user['email']); ?></span></div>
            <div><strong>Role:</strong>
                <span><?= $user['is_admin'] ? '관리자' : '일반회원'; ?></span>
            </div>
            <div><strong>Photo:</strong>
                <?php if (!empty($user['photo'])): ?>
                    <img src="<?= htmlspecialchars($user['photo']); ?>" alt="User Photo">
                <?php else: ?>
                    <span>사진 없음</span>
                <?php endif; ?>
            </div>
            <div><strong>가입일:</strong> <span><?= htmlspecialchars($user['created_at']); ?></span></div>
            
            <!-- 수정/삭제 버튼 영역 -->
            <div class="btn-area">
                <!-- 수정 버튼 → edit_info_checked.php?id=...  (팝업 없이 바로 이동) -->
                <a href="edit_info_checked_mobile.php?id=<?= $user['id'] ?>" class="btn edit">수정</a>
                <!-- 삭제 버튼 → confirmDelete(...) -->
                <a href="javascript:void(0)" class="btn delete" 
                   onclick="confirmDelete(<?= $user['id'] ?>)">
                   삭제
                </a>
            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="message" style="text-align:center;">등록된 회원이 없습니다.</div>
<?php endif; ?>

</body>
</html>
