<?php
// db 연결 파일 포함
include('connect.php');

// 에러 표시 활성화(개발 중에만 사용)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try {
    // zb_users 테이블에서 회원 정보 조회
    $sql = "SELECT id, user_id, email, is_admin, photo, created_at
            FROM zb_users
            ORDER BY id ASC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    
    // 결과 세트 가져오기
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("회원 정보를 불러오는 중 오류 발생: " . $e->getMessage());
}

// DB 연결 해제 (선택적으로 수행)
$conn = null;
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>회원정보 조회</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            background-color: #f9f9f9;
        }
        th, td {
            text-align: left;
            padding: 8px 12px;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #007BFF;
            color: white;
        }
        img {
            max-width: 100px;
            height: auto;
        }
        .center {
            text-align: center;
        }
        .no-data {
            text-align: center;
            margin-top: 20px;
            color: #666;
        }
    </style>
</head>
<body>

<h1 class="center">회원정보 조회</h1>

<?php if (count($users) > 0): ?>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>User ID</th>
                <th>Email</th>
                <th>Role</th>
                <th>Photo</th>
                <th>가입일</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($users as $user): ?>
            <tr>
                <td><?php echo htmlspecialchars($user['id']); ?></td>
                <td><?php echo htmlspecialchars($user['user_id']); ?></td>
                <td><?php echo htmlspecialchars($user['email']); ?></td>
                <td><?php echo $user['is_admin'] ? '관리자' : '일반회원'; ?></td>

                <td>
                    <?php if (!empty($user['photo'])): ?>
                        <!-- 실제 서버 경로 또는 URL 경로가 일치해야 이미지가 표시됩니다. -->
                        <img src="<?= htmlspecialchars($user['photo']) ?>" alt="User Photo">
                    <?php else: ?>
                        사진 없음
                    <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($user['created_at']) ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="no-data">등록된 회원이 없습니다.</div>
<?php endif; ?>
	
	<h1><a href="admin_dashboard_pc.php" class="logout">처음으로</a></h1>

</body>
</html>

