<?php
// DB 연결
include('connect.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$message = '';

// (1) GET 파라미터로 삭제 처리
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $deleteId = (int)$_GET['id'];

    try {
        $sql = "DELETE FROM zb_users WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':id', $deleteId, PDO::PARAM_INT);
        $stmt->execute();

        $countDeleted = $stmt->rowCount();
        if ($countDeleted > 0) {
            $message = "회원(ID: {$deleteId})이(가) 삭제되었습니다.";
        } else {
            $message = "회원(ID: {$deleteId}) 삭제 실패 또는 존재하지 않는 회원입니다.";
        }
    } catch (Exception $e) {
        $message = "삭제 처리 중 오류 발생: " . $e->getMessage();
    }
}

// (2) GET 파라미터 msg 있으면 표시 (다른 페이지에서 돌아온 경우)
if (isset($_GET['msg'])) {
    $message = $_GET['msg'];
}

// (3) 회원 목록 조회
try {
    $sql = "SELECT id, user_id, email, is_admin, photo, created_at 
            FROM zb_users
            ORDER BY id ASC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("회원 정보를 불러오는 중 오류 발생: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>회원정보 조회 (PC)</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            max-width: 900px;
            margin: 0 auto;
            background-color: #f9f9f9;
        }
        th, td {
            padding: 8px 12px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #007BFF;
            color: #fff;
        }
        img {
            max-width: 80px;
            height: auto;
        }
        .center {
            text-align: center;
        }
        .message {
            text-align: center;
            color: red;
            margin-bottom: 10px;
        }
        .no-data {
            margin-top: 20px;
            text-align: center;
            color: #666;
        }
        /* 수정/삭제 버튼 */
        .btn {
            display: inline-block;
            padding: 6px 12px;
            margin: 0 5px;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
            font-size: 0.9rem;
        }
        .edit {
            background-color: #28a745;
        }
        .delete {
            background-color: #dc3545;
        }
        .edit:hover {
            background-color: #218838;
        }
        .delete:hover {
            background-color: #c82333;
        }
    </style>
    <script>
        // 삭제 버튼 클릭 시 팝업 확인 후 진행
        function confirmDelete(id) {
            if (confirm("정말로 해당 레코드를 삭제하시겠습니까?")) {
                // 확인 누르면 실제 삭제 요청으로 이동
                window.location.href = "?action=delete&id=" + id;
            }
        }
    </script>
</head>
<body>

<h1 class="center">회원정보 조회 (PC)</h1>

<!-- 메시지 표시 -->
<?php if (!empty($message)): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<table>
    <thead>
        <tr>
            <th>No</th>
            <th>User ID</th>
            <th>Email</th>
            <th>Role</th>
            <th>Photo</th>
            <th>가입일</th>
            <th>수정</th>
            <th>삭제</th>
        </tr>
    </thead>
    <tbody>
    <?php if (count($users) > 0): ?>
        <?php foreach ($users as $u): ?>
            <tr>
                <td><?= htmlspecialchars($u['id']) ?></td>
                <td><?= htmlspecialchars($u['user_id']) ?></td>
                <td><?= htmlspecialchars($u['email']) ?></td>
                <td><?= $u['is_admin'] ? '관리자' : '일반회원' ?></td>
                <td>
                    <?php if (!empty($u['photo'])): ?>
                        <img src="<?= htmlspecialchars($u['photo']) ?>" alt="User Photo">
                    <?php else: ?>
                        사진 없음
                    <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($u['created_at']) ?></td>

                <!-- 수정 버튼: edit_info_checked.php?id=... -->
                <td>
                    <a class="btn edit" 
                       href="edit_info_checked_pc.php?id=<?= urlencode($u['id']) ?>">
                        수정
                    </a>
                </td>
                
                <!-- 삭제 버튼: confirmDelete(...) 함수로 이동  -->
                <td>
                    <a class="btn delete" href="javascript:void(0)"
                       onclick="confirmDelete(<?= $u['id'] ?>)">
                        삭제
                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php else: ?>
        <tr><td colspan="8" class="no-data">등록된 회원이 없습니다.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

	 <button onclick="location.href='admin_dashboard_pc.php'">관리자 대시보드</button>
	
</body>
</html>
