<?php
include_once('./_common.php');

// 로그인 여부 확인
if (!$is_member) {
    echo "로그인이 필요합니다.";
    exit;
}

// POST로 받은 데이터 sanitize
$target_mb_id = sql_real_escape_string($_POST['target_mb_id']);
$page_url = sql_real_escape_string($_POST['page_url']);

// 필수 입력값 검증
if (empty($target_mb_id) || empty($page_url)) {
    echo json_encode(['success' => false, 'message' => '잘못된 입력값입니다.']);
    exit;
}

// 받는 사람 정보 확인
$recv_mb = sql_fetch("SELECT * FROM {$g5['member_table']} WHERE mb_id = '{$target_mb_id}'");
if (!$recv_mb) {
    echo json_encode(['success' => false, 'message' => '존재하지 않는 회원입니다.']);
    exit;
}

// 보내는 사람 정보 (현재 로그인된 회원)
$send_mb = $member;

// 쪽지 내용 생성 (페이지 링크)
$memo_content = "페이지 링크를 공유합니다: " . $page_url;

// 중복 쪽지 확인
$duplicate_check = sql_fetch("SELECT COUNT(*) as cnt FROM {$g5['memo_table']} 
    WHERE me_send_mb_id = '{$send_mb['mb_id']}' 
    AND me_recv_mb_id = '{$recv_mb['mb_id']}' 
    AND me_memo = '{$memo_content}' 
    AND me_send_datetime > DATE_SUB(NOW(), INTERVAL 1 HOUR)");

if ($duplicate_check['cnt'] > 0) {
    echo json_encode([
        'success' => false, 
        'message' => '동일한 내용의 쪽지가 최근에 이미 전송되었습니다.'
    ]);
    exit;
}

// 쪽지 저장을 위한 고유 ID 생성
$me_id = sql_insert_id();

// 쪽지 저장
$sql = "INSERT INTO {$g5['memo_table']} SET 
    me_id = '{$me_id}', 
    me_recv_mb_id = '{$recv_mb['mb_id']}', 
    me_send_mb_id = '{$send_mb['mb_id']}', 
    me_send_datetime = '".G5_TIME_YMDHIS."', 
    me_memo = '{$memo_content}'";
$result = sql_query($sql);

if (!$result) {
    echo json_encode([
        'success' => false, 
        'message' => '쪽지 전송 중 오류가 발생했습니다.'
    ]);
    exit;
}

// 받는 사람의 새 쪽지 알림 표시
$sql = "UPDATE {$g5['member_table']} 
        SET mb_memo_call = 'alarm' 
        WHERE mb_id = '{$recv_mb['mb_id']}'";
sql_query($sql);

// JSON 응답 반환
echo json_encode([
    'success' => true, 
    'message' => '페이지 링크가 쪽지로 성공적으로 전송되었습니다.'
]);
?>