<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no"> <!-- 확대 방지 추가 -->
    <title>친구의 프로필을 찍어보세요!</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f8f8;
            margin: 0;
            overflow: hidden;
        }
        .scanner-container {
            position: relative;
            width: 100%;
            height: 100vh;
        }
        video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 0;
        }
        .result {
            position: absolute;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: rgba(255, 255, 251, 0.25);
            -webkit-backdrop-filter: blur(17px);
            backdrop-filter: blur(17px);
            padding: 10px 20px;
            border-radius: 15px;
            font-size: 18px;
            color: #333;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            display: none; /* 결과 메시지 숨김 */
        }
        .home-icon {
            position: absolute;
            top: 10px;
            left: 20px;
            font-size: 24px;
            color: #333;
            cursor: pointer;
        }
    </style>
</head>
<body>

<div class="scanner-container">
    <div class="home-icon" onclick="window.location.href='/'"><i class="fa fa-arrow-left"></i></div>
    <video id="preview" autoplay></video>
    <div class="result" id="result">프로필 인식</div>
</div>

<script src="https://unpkg.com/@zxing/library@latest"></script>
<script>
    const codeReader = new ZXing.BrowserQRCodeReader();
    const videoElement = document.getElementById('preview');

    // 페이지 로드 시 자동으로 카메라 사용 요청
    window.onload = () => {
        codeReader.decodeFromVideoDevice(null, videoElement, (result, err) => {
            if (result) {
                const url = result.text;
                // URL 패턴 확인
                const regex = /^https:\/\/[a-zA-Z0-9.-]+\/bbs\/profile\.php\?mb_id=\w+$/;
                if (regex.test(url)) {
                    // 현재 도메인으로 프로필 페이지로 이동
                    const memberId = new URL(url).searchParams.get('mb_id');
                    window.location.href = `/bbs/profile.php?mb_id=${memberId}`;
                } else {
                    // 다른 형식의 링크일 경우 경고 메시지 출력
                    alert("프로필 QR이 아닙니다.");
                }
            }
            if (err && !(err instanceof ZXing.NotFoundException)) {
                console.error(err);
            }
        });
    };
</script>

</body>
</html>