<?php
// emoji.php

// 실제 파일 시스템 경로 설정
$emojiDir = __DIR__;  // 현재 스크립트의 디렉토리 경로

// 웹 루트에서의 상대 경로 계산
$scriptPath = str_replace($_SERVER['DOCUMENT_ROOT'], '', $emojiDir);

// 지원할 이미지 확장자
$allowedExtensions = ['png', 'jpg', 'jpeg', 'gif', 'webp'];

// 그룹화된 이모티콘 배열 초기화
$groupedEmojis = [];

// 폴더 내의 모든 하위 디렉토리 가져오기
$subDirs = array_filter(glob($emojiDir . '/*'), 'is_dir');

foreach ($subDirs as $subDir) {
    // 전체 디렉토리 이름을 사용
    $subDirName = basename($subDir);
    
    // 파일명에 언더스코어(_)가 포함되어 있더라도 전체 이름을 그대로 사용
    $groupedEmojis[$subDirName] = [];
    
    // 하위 디렉토리 내의 파일 목록 가져오기
    $files = array_diff(scandir($subDir), ['.', '..']);
    
    foreach ($files as $file) {
        $filePath = $subDir . '/' . $file;
        if (is_file($filePath)) {
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            if (in_array($ext, $allowedExtensions)) {
                // URL 생성 시 웹 루트 기준 상대 경로 사용
                $relativePath = $scriptPath . '/' . $subDirName . '/' . $file;
                
                // 도메인과 경로를 포함한 이미지 URL 생성
                $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || 
                           $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
                $domain = $_SERVER['HTTP_HOST'];
                
                // URL에서 중복되는 'emoji' 경로를 제거
                $imageUrl = $protocol . $domain . $relativePath;
                
                // 그룹에 이미지 추가
                $groupedEmojis[$subDirName][] = $imageUrl;
            }
        }
    }
}

// 빈 그룹 제거
$groupedEmojis = array_filter($groupedEmojis);

// JSON 형식으로 출력
header('Content-Type: application/json');
header('Content-Type: application/json; charset=utf-8'); // UTF-8 인코딩 명시
echo json_encode($groupedEmojis, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
?>