<?php
include_once('./_common.php');
// 요청한 파일의 ID를 가져옵니다.
$id = isset($_GET['id']) ? $_GET['id'] : '';
// HTTP_REFERER 확인
$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
// 허용된 출처 확인
$allowed_referer = G5_BBS_URL . '/memo_form.php';
if (empty($referer) || strpos($referer, $allowed_referer) === false) {
    // 잘못된 요청이거나 직접 접근일 경우 차단
    http_response_code(403); // Forbidden
    echo "접근이 금지되었습니다. 이 페이지는 직접 접근할 수 없습니다.";
    exit;
}
// 파일 경로 검증: 디렉토리/파일명 형식
if (preg_match('/^[a-zA-Z0-9_\-\/\.]+$/', $id) === 0) {
    http_response_code(403);
    echo "잘못된 파일 요청입니다.";
    exit;
}
// 디렉토리와 파일 분리
$file_path = G5_URL . '/chat_data/data/' . $id;
$file_extension = pathinfo($file_path, PATHINFO_EXTENSION);
// id1-id2 형식에서 id1과 id2를 추출
list($id1, $id2) = explode('-', explode('/', $id)[0]);
// 현재 사용자의 mb_id 가져오기
$mb_id = $member['mb_id'];
// mb_id가 id1 또는 id2와 일치하는지 확인
if ($mb_id === $id1 || $mb_id === $id2) {
    header("Location: $file_path");
    exit;
} else {
    http_response_code(403);
    echo "접근이 금지되었습니다. 접근할 권한이 없습니다.";
    exit;
}
?>