<?php if (!defined('_GNUBOARD_')) exit;

function getNewProfileLink($mb_id) {
    $currentDomain = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    return $currentDomain . "/bbs/profile.php?mb_id=" . $mb_id;
}

function getNewFacebookShareLink($url) { return "https://www.facebook.com/sharer.php?u=" . urlencode($url); }
function getNewTwitterShareLink($url) { return "https://twitter.com/intent/tweet?url=" . urlencode($url); }
function getNewLineShareLink($url, $message) { return "https://social-plugins.line.me/lineit/share?url=" . urlencode($url) . "&text=" . urlencode($message); }

function getNewPluginImagePath() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    $port = $_SERVER['SERVER_PORT'];
    $suffix = ($port !== 80 && $port !== 443) ? ":" . $port : "";
    $url = $protocol . $host . $suffix . "/plugin/sns_share/img";
    return $url;
}

$imagePath = getNewPluginImagePath();
$profileUrl = getNewProfileLink($mb_id);
$facebookShareUrl = getNewFacebookShareLink($profileUrl);
$twitterShareUrl = getNewTwitterShareLink($profileUrl);
$lineShareUrl = getNewLineShareLink($profileUrl, "라인으로 공유합니다!");
?>

<div id='socialShare' style="display: flex; justify-content: center;">
    <a href="javascript:void(0);" id="copyProfileLink" style="margin-right: 10px;">
        <img src="<?= $imagePath ?>/url.webp" alt="프로필 링크" width='50px' height='auto'/>
    </a>

    <a href="<?= $lineShareUrl ?>" target="_blank" style="margin-right: 10px;">
        <img src="<?= $imagePath ?>/line.webp" alt="라인 공유" width='50px' height='auto'/>
    </a>
    <a href="<?= $facebookShareUrl ?>" target="_blank" style="margin-right: 10px;">
        <img src="<?= $imagePath ?>/meta.webp" alt="페이스북 공유" width='50px' height='auto'/>
    </a>
    <a href="<?= $twitterShareUrl ?>" target="_blank">
        <img src="<?= $imagePath ?>/x.webp" alt="트위터 공유" width='50px' height='auto'/>
    </a>
</div>

<script>
document.getElementById('copyProfileLink').addEventListener('click', function() {
    copyToClipboard("<?php echo $profileUrl; ?>");
    showCopyAlert();
});

function copyToClipboard(text) {
    navigator.clipboard.writeText(text);
}

function showCopyAlert() {
    // 복사 알림 요소 생성
    const copyAlert = document.createElement('div');
    copyAlert.classList.add('copy-alert');

    // 복사 아이콘 생성
    const alertIcon = document.createElement('i');
    alertIcon.classList.add('fa', 'fa-check-circle');
    copyAlert.appendChild(alertIcon);

    // 복사 메시지 생성
    const alertMessage = document.createElement('span');
    alertMessage.textContent = '⠀프로필 URL이 복사되었습니다.';
    copyAlert.appendChild(alertMessage);

    // 화면에 추가
    document.body.appendChild(copyAlert);

    // 2초 후에 숨기기
    setTimeout(() => {
        copyAlert.classList.add('hide');
        setTimeout(() => {
            document.body.removeChild(copyAlert);
        }, 500); // 애니메이션 시간
    }, 2500);
}
</script>
<style>
.copy-alert {
    position: fixed;
    top: 20px;
    left: 50%;
    transform: translateX(-50%);
    background-color: #333;
    color: #fff;
    padding: 10px 20px;
    border-radius: 4px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    display: flex;
    align-items: center;
    opacity: 1;
    transition: opacity 0.5s ease;
    z-index: 2;
    top: 70px;
}

.copy-alert i {
color:green !important
}

.copy-alert .fas {
    margin-right: 10px;
    font-size: 16px;
}

.copy-alert.hide {
    opacity: 0;
}
</style>