<?php if (!defined('_GNUBOARD_')) exit;

function getIncludedPageURL() {
    $p = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $u = $p . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    return $u;
}

function getFacebookShareLink($u) {
    $f = "https://www.facebook.com/sharer.php?u=" . urlencode($u);
    return $f;
}

function getTwitterShareLink($u) {
    $t = "https://twitter.com/intent/tweet?url=" . urlencode($u);
    return $t;
}

function getLineShareLink($u) {
    $m = "라인으로 공유합니다!";
    $l = "https://social-plugins.line.me/lineit/share?url=" . urlencode($u) . "&text=" . urlencode($m);
    return $l;
}

function getPluginImagePath() {
    $p = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $h = $_SERVER['HTTP_HOST'];
    $o = $_SERVER['SERVER_PORT'];
    $s = ($o !== 80 && $o !== 443) ? ":" . $o : "";
    $u = $p . $h . $s . "/plugin/sns_share/img";
    return $u;
}

$pi = getPluginImagePath();
$ipu = getIncludedPageURL();
$fs = getFacebookShareLink($ipu);
$ts = getTwitterShareLink($ipu);
$ls = getLineShareLink($ipu);
?>
<div id="sns">
    <a href="javascript:void(0);" id="copyLink"><img src="<?= $pi ?>/url.webp" alt="url 복사" width="50px" height="auto" /></a>
    <a href="<?= $ls ?>" target="_blank"><img src="<?= $pi ?>/line.webp" alt="라인 공유" width="50px" height="auto" /></a>

    <a href="<?= $fs ?>" target="_blank"><img src="<?= $pi ?>/meta.webp" alt="페이스북 공유" width="50px" height="auto" /></a>

    <a href="<?= $ts ?>" target="_blank"><img src="<?= $pi ?>/x.webp" alt="트위터 공유" width="50px" height="auto" /></a>
    <!-- 회원은 사이트 내 게시글 메모로 공유 가능하도록{ -->
    <?php if ($is_member) { ?>
    <img src="<?= $pi ?>/memo.webp" alt="채팅으로 보내기" width="50px" height="auto" id="memoImg"/>
    <?php } ?>
    <!-- }회원 전용 게시글 메모 공유 -->
</div>

<style>
    #sns {
        display: flex;
        justify-content: center; /* 가로 중앙 정렬 */
        margin: 5px;
        margin-bottom:20px
    }
    #sns img {
        margin-right: 5px;
    }
    .share_board_memo {
    /* 기본적으로 숨겨둠 */
    display: none;
    position: absolute;
    /* 추가적인 스타일 */
    }
</style>
<script>
    document.getElementById('copyLink').addEventListener('click', function() {
        var u = '<?= $ipu ?>';
        var t = document.createElement('input');
        t.setAttribute('value', u);
        document.body.appendChild(t);
        t.select();
        document.execCommand('copy');
        document.body.removeChild(t);
        alert('URL이 복사되었습니다.');
    });
</script>

<!-- 회원은 사이트 내 게시글 메모로 공유 가능하도록{ -->
<?php if ($is_member) { ?>
<div id="overlay" class="overlay"></div>

<div class="share_board_memo" style="display:none;">
<style>
    /* 배경에 블러 효과 추가 */
    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5); /* 반투명 검정 배경 */
        backdrop-filter: blur(5px); /* 블러 효과 */
        z-index: 999; /* 모달보다 뒤에 */
        display: none; /* 기본적으로 숨김 */
    }

    /* 타일을 중앙에 위치시키고, 3개씩 배열 */
    .mutual-followers-container {
        display: grid;
        grid-template-columns: repeat(3, 1fr); /* 3개의 열로 배열 */
        gap: 30px;
        padding: 20px;
        background-color: #fefefe;
        border-radius: 20px 20px 0 0;
        border: 1px solid #ddd;
        position: fixed;
        bottom: 60px;
        left: 50%;
        transform: translateX(-50%);
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        z-index: 1000;
        width: 100%; /* 전체 너비의 90% */
        max-width: 450px; /* 최대 너비 설정 */
    }

    .follower-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        cursor: pointer;
        text-align: center;
    }

    .follower-image {
        width: 74px;
        height: 74px;
        object-fit: cover;
        border-radius: 50%;
        border: 1px solid #f1f1f1;
        background-color: #fff;
    }

    .follower-nickname {
        margin-top: 8px;
        font-size: 14px;
        color: #333;
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
        max-width: 80px;
    }

    .follower-item:hover .follower-image {
        border-color: #007aff;
        transform: scale(1.1);
        transition: transform 0.3s ease, border-color 0.3s ease;
    }
</style>

<div id="mutual-followers-container" class="mutual-followers-container"></div>

<script>
    // 서버에서 팔로워 정보를 가져오는 함수
    async function fetchMutualFollowers(page = 1) {
        try {
            const response = await fetch('<?php echo G5_BBS_URL ?>/ajax_get-followerNfollowing.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `page=${page}&mb_id=${currentUserId}`
            });
            const data = await response.json();
            // 올바른 데이터 형식인지 확인
            if (Array.isArray(data)) {
                renderMutualFollowers(data);
            } else {
                console.error('Unexpected data format:', data);
                alert('데이터를 불러오는 데 실패했습니다.');
            }
        } catch (error) {
            console.error('Error fetching mutual followers:', error);
        }
    }

    // 팔로워 정보를 렌더링하는 함수
function renderMutualFollowers(followers) {
    const container = document.getElementById('mutual-followers-container');
    const shareBoardMemo = document.querySelector('.share_board_memo');
    const overlay = document.getElementById('overlay');
    container.innerHTML = ''; // 기존 내용을 초기화
    followers.forEach(follower => {
        const followerItem = document.createElement('div');
        followerItem.className = 'follower-item';

        // 이미지 요소 생성
        const img = document.createElement('img');
        img.className = 'follower-image';
        img.alt = `${follower.mb_nick}의 프로필`;
        // 이미지 경로 및 대체 경로 설정
        img.src = `<?php echo G5_URL ?>/data/member/${follower.mb_id.substring(0, 2)}/${follower.mb_id}.gif`;
        img.onerror = function() {
            this.src = `<?php echo G5_URL ?>/data/member_image/${follower.mb_id.substring(0, 2)}/${follower.mb_id}.gif`;
        };

        // 닉네임 요소 생성
        const nickname = document.createElement('div');
        nickname.className = 'follower-nickname';
        nickname.textContent = follower.mb_nick;

        // 클릭 이벤트
        followerItem.addEventListener('click', () => {
            // 페이지 링크 공유
            sharePage(follower.mb_id);
            
            // share_board_memo와 overlay 숨기기
            shareBoardMemo.style.display = 'none';
            overlay.style.display = 'none';
        });

        // 아이템 구성
        followerItem.appendChild(img);
        followerItem.appendChild(nickname);
        container.appendChild(followerItem);
    });
}

    // 페이지 링크를 공유하는 함수
    function sharePage(targetMemberId) {
        const currentPageUrl = window.location.href;
        // AJAX로 페이지 링크 공유
        fetch('<?php echo G5_BBS_URL ?>/ajax_send_board_memo.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `target_mb_id=${targetMemberId}&page_url=${encodeURIComponent(currentPageUrl)}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                //alert(`페이지 링크를 ${targetMemberId}에게 보냈습니다.`);
            } else {
                alert('링크 공유에 실패했습니다.');
            }
        })
        .catch(error => {
            console.error('Error sharing page:', error);
            alert('링크 공유 중 오류가 발생했습니다.');
        });
    }

    // 현재 사용자 ID
    const currentUserId = '<?php echo $mb_id; ?>';

    // 페이지 로드 시 팔로워 정보 가져오기
    document.addEventListener('DOMContentLoaded', () => {
        fetchMutualFollowers();
    });
</script>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const memoImg = document.getElementById('memoImg');
    const shareBoardMemo = document.querySelector('.share_board_memo');
    const overlay = document.getElementById('overlay');

    // memo 이미지 클릭 시 share_board_memo 보이기 및 overlay 보이기
    memoImg.addEventListener('click', function(event) {
        event.stopPropagation();  // 클릭 이벤트가 부모로 전파되는 것을 막음
        shareBoardMemo.style.display = 'block';
        overlay.style.display = 'block'; // 배경 오버레이 보이기
    });

    // 다른 요소를 클릭하면 share_board_memo와 overlay 숨기기
    document.addEventListener('click', function(event) {
        if (!shareBoardMemo.contains(event.target) && event.target !== memoImg) {
            shareBoardMemo.style.display = 'none';
            overlay.style.display = 'none'; // 배경 오버레이 숨기기
        }
    });

    // share_board_memo 내부의 클릭 이벤트는 전파되지 않도록 막기
    shareBoardMemo.addEventListener('click', function(event) {
        event.stopPropagation();
    });
});
</script>
<?php } ?>
<!-- 회원은 사이트 내 게시글 메모로 공유 가능하도록{ -->

<!--Provided by Tak2 / dsclub.kr-->
<!--본 플러그인은 상업적 이용이 가능합니다만 이미지 자체의 저작권은 각 아이콘 회사와 tak2에게 있으며 본 플러그인을 무단 재배포 할 수 없습니다.-->