<?php
include_once('../../../common.php');
// URL에서 write.php인지 확인하여 수정 모드 체크
$is_edit_mode = (strpos($_SERVER['PHP_SELF'], 'write.php') !== false && isset($_GET['w']) && $_GET['w'] === 'u');
// 제외할 게시판 테이블 이름들 (필요에 따라 수정)
$excluded_boards = array('notice'); // ex) 'notice' 쉼표로 여러개 제외 가능

if (!$is_edit_mode):
    // 쓰기 권한이 있는 게시판 목록 가져오기
    $sql = "SELECT bo_table, bo_subject, bo_admin FROM `" . $g5['board_table'] . "` WHERE bo_write_level <= '{$member['mb_level']}'";
    $result = sql_query($sql);
    
    // 게시판 목록을 배열로 저장 (제외 게시판 처리)
    $boards = array();
    while ($row = sql_fetch_array($result)) {
        // 제외 게시판 목록에 없는 경우에만 추가
        if (!in_array($row['bo_table'], $excluded_boards)) {
            // 게시판 관리자가 있고, 현재 사용자가 관리자가 아닌 경우 제외
            if (!empty($row['bo_admin']) && $row['bo_admin'] !== $member['mb_id']) {
                continue;
            }
            $boards[] = $row;
        }
    }
    // 한글/영어 정렬 함수
    function compare_korean_english($a, $b) {
        $a_first = mb_substr($a['bo_subject'], 0, 1, 'UTF-8');
        $b_first = mb_substr($b['bo_subject'], 0, 1, 'UTF-8');
        
        // 한글 범위 체크 (가~힣)
        $is_a_korean = preg_match('/[\xEA-\xED][\x80-\xBF]{2}/', $a_first);
        $is_b_korean = preg_match('/[\xEA-\xED][\x80-\xBF]{2}/', $b_first);
        
        // 둘 다 한글이거나 둘 다 영어면 일반 비교
        if (($is_a_korean && $is_b_korean) || (!$is_a_korean && !$is_b_korean)) {
            return strcmp($a['bo_subject'], $b['bo_subject']);
        }
        
        // 한글이 먼저 오도록
        return $is_a_korean ? -1 : 1;
    }
    // 게시판 목록 정렬
    usort($boards, 'compare_korean_english');
    // 현재 URL의 bo_table 추출
    $current_bo_table = isset($_GET['bo_table']) ? $_GET['bo_table'] : '';
    // 정렬된 게시판 목록으로 옵션 생성
    $board_options = '';
    foreach ($boards as $board) {
        $selected = ($board['bo_table'] === $current_bo_table) ? "selected" : "";
        $board_options .= "<option value='" . $board['bo_table'] . "' $selected>" . $board['bo_subject'] . "</option>\n";
    }
?>
<span style="padding:0 15px;font-size: 15px; font-weight:500; color: #8c8c8c">게시판을 선택해 주세요 ▽</span>
<form id="boardSelectForm" style="display: flex; flex-direction: column; align-items: center; margin-top: 5px">
    <div style="padding:0 15px;position: relative; width: 100%;padding-top:5px;">
        <select id="boardSelect" onchange="navigateToBoard()" style="padding: 10px; font-size: 16px; border-radius: 5px; border: 1px solid #ccc; color: #3c3c3c; width: 100%; background: #fff; appearance: none; -webkit-appearance: none; -moz-appearance: none;">
            <?php echo $board_options; ?>
        </select>
    </div>
</form>
<script>
    function navigateToBoard() {
        const boardSelect = document.getElementById("boardSelect");
        const selectedBoard = boardSelect.value;
        const currentUrl = window.location.href;
        // 선택한 게시판의 URL
        const targetUrl = `<?php G5_URL ?>/bbs/write.php?bo_table=${selectedBoard}`;
        // 현재 URL이 선택한 게시판의 URL과 다를 경우에만 이동
        if (selectedBoard && !currentUrl.includes(targetUrl)) {
            window.location.href = targetUrl; // 선택된 게시판 페이지로 이동
        }
    }
    // 페이지 로드 시 현재 URL에 따른 초기 값 설정
    window.onload = function() {
        const currentUrl = window.location.href;
        const boardSelect = document.getElementById("boardSelect");
        
        // 게시판 목록을 반복하며 현재 URL에 맞는 값을 찾음
        for (let i = 0; i < boardSelect.options.length; i++) {
            if (currentUrl.includes(`bo_table=${boardSelect.options[i].value}`)) {
                boardSelect.value = boardSelect.options[i].value; // 해당 값 선택
                break;
            }
        }
    };
</script>
<style>
    /* select 요소의 기본 화살표 제거 */
    select {
        background-color: #fff; /* 드롭다운 배경색 */
    }
</style>
<?php endif; ?>