<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

if (!defined('_INDEX_')) define('_INDEX_', true);

include_once(G5_THEME_MOBILE_PATH.'/head.php');
include_once(G5_CAPTCHA_PATH.'/captcha.lib.php');
include_once(G5_LIB_PATH.'/popular.lib.php');

add_javascript('<script src="'.G5_JS_URL.'/jquery.bxslider.js"></script>', 10);
?>


<!-- 콘텐츠 영역, div id는 원하는 게시판 ID+Content, 원하는 게시판 ID, 출력 개수, 글자수-->
<div id="content" style="margin-bottom:50px;">
    <div id="galleryContent" class="content">
        <?php echo latest('theme/main', 'gallery', 35, 23); ?>
    </div>
    <div id="freeContent" class="content" style="display: none;">
        <?php echo latest('theme/main', 'free', 20, 23); ?>
    </div>
    <!-- 추가 콘텐츠 영역 -->
</div>

<button type="button" id="menuButton">
    <i class="fa fa-th-list" aria-hidden="true"></i><span class="sound_only">글쓰기</span>
</button>
<!-- 메뉴 -->
<div id="menu">
    <button onclick="navigateTo('gallery')">갤러리</button>
    <button onclick="navigateTo('free')">자유게시판</button>
</div>

<script async>
    var menuVisible = false;

    // 메뉴 버튼을 클릭하면 메뉴를 토글
    document.getElementById('menuButton').addEventListener('click', function () {
        var menu = document.getElementById('menu');
        if (menuVisible) {
            menu.style.display = 'none';
        } else {
            menu.style.display = 'block';
        }
        menuVisible = !menuVisible;
    });

    // 주어진 메뉴로 이동하는 함수
    function navigateTo(menu) {
        // 모든 콘텐츠 숨기기
        var contents = document.querySelectorAll('.content');
        contents.forEach(function(content) {
            content.style.display = 'none';
        });

        // 선택한 메뉴에 해당하는 콘텐츠만 보이기
        var selectedContent = document.getElementById(menu + 'Content');
        if (selectedContent) {
            selectedContent.style.display = 'block';
        }
    }

    // 페이지 로드 시 기본적으로 갤러리 콘텐츠 보여주기
    window.onload = function() {
        navigateTo('gallery');
    };
</script>

	<style media="print" onload="this.media='all'">
	#menuButton { position: fixed; bottom: 70px; right: 15px; width: 50px; height: 50px; line-height: 50px; border: none; border-radius: 50%; background: #347cf4; color: #ffffff; text-align: center; font-size: 15px; z-index: 99; margin-right: 10px; cursor: pointer; } #menu { position: fixed; bottom: 130px; right: 15px; display: none; z-index: 100; background-color: #72a8ff; border: 1px solid #347cf4; border-radius: 5px; padding: 10px 5px} #menu button { display: block; width: 100%; background: none; border: none; padding: 5px 0; color: #ffffff; text-align: left; cursor: pointer; border-bottom: 2px solid #347cf4 } #menu button:hover { background-color: rgba(0, 0, 0, 0.2); }
	</style>
	
<?php
include_once(G5_THEME_MOBILE_PATH.'/tail.php');
?>
