<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 2;

if ($is_checkbox) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">

<?php if ($rss_href || $write_href) { ?>
<ul class="<?php echo isset($view) ? 'view_is_list btn_top' : 'btn_top top btn_bo_user';?>">
	<?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn" title="관리자"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">관리자</span></a></li><?php } ?>
    <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b03 btn" title="RSS"><i class="fa fa-rss" aria-hidden="true"></i><span class="sound_only">RSS</span></a></li><?php } ?>
    <?php if ($is_admin == 'super' || $is_auth) {  ?>
	<li>
		<button type="button" class="btn_more_opt btn_b03 btn is_list_btn" title="게시판 리스트 옵션"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트 옵션</span></button>
		<?php if ($is_checkbox) { ?>	
        <ul class="more_opt is_list_btn">
            <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"><i class="fa fa-trash-o" aria-hidden="true"></i> 선택삭제</button></li>
            <li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"><i class="fa fa-files-o" aria-hidden="true"></i> 선택복사</button></li>
            <li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"><i class="fa fa-arrows" aria-hidden="true"></i> 선택이동</button></li>
        </ul>
        <?php } ?>
	</li>
    <?php } ?>
<?php if ($write_href) { ?>
<li>
    <a href="<?php echo $write_href ?>" class="fix_btn write_btn" title="글쓰기" id="writeButton" style="width:120px;border-radius:35px !important; display:inline-block; overflow:hidden;">
        <i class="fa fa-pencil" aria-hidden="true"></i>
        <span id="writeText" style="color:#fff;font-weight:600;font-size:17px;margin-left:-10px;display:inline-block; transform: scaleX(1.75); transition: transform 1s ease-in-out;">_</span>
        <span id="writeLabel" style="color:#f9f9f9;font-size:17px;font-weight:600; transition: opacity 1s ease-in-out;"> &nbsp;글쓰기</span>
        <span class="sound_only">글쓰기</span>
    </a>
</li>
<script>
    window.addEventListener('load', function() {
        const writeButton = document.getElementById('writeButton');
        const writeText = document.getElementById('writeText');
        const writeLabel = document.getElementById('writeLabel');
        let currentWidth = 120; // Initial width
        const targetWidth = 50; // Target width
        const duration = 350; // Animation duration in ms (1.2 seconds)
        let startTime;

        setTimeout(() => {
            // Applying text transform motion
            writeText.style.transform = 'scaleX(1)';
            writeLabel.style.opacity = '0';

            // Gradually reduce width of the <a> element
            function animateWidth(timestamp) {
                if (!startTime) startTime = timestamp;
                const elapsed = timestamp - startTime;

                if (elapsed < duration) {
                    const progress = elapsed / duration;
                    currentWidth = 120 - (progress * (120 - targetWidth));
                    writeButton.style.width = currentWidth + 'px';
                    requestAnimationFrame(animateWidth);
                } else {
                    // Ensure it ends at the target width
                    writeButton.style.width = targetWidth + 'px';
                    // Remove specific styles from the <a> element
                    setTimeout(() => {
                        writeButton.style.width = '';
                        writeButton.style.borderRadius = '';
                    }, 500); // Slight delay before removing styles
                }
            }

            requestAnimationFrame(animateWidth);
        }, 1800); // Starts animation after 1.8 seconds
    });
</script>

<?php } ?>

</ul>
<?php } ?>

<div id="bo_list">
    <div class="list_01">
        <?php if ($is_checkbox) { ?>
            <div class="all_chk chk_box">
                <input type="checkbox" id="chkall" onclick="this.checked ? all_checked(true) : all_checked(false);" class="selec_chk">
                <label for="chkall">
                    <span></span>
                    <b class="sound_only">현재 페이지 게시물 전체선택</b>
                </label>
            </div>
        <?php } ?>
        <ul class="post-list">
            <?php for ($i = 0; $i < count($list); $i++) { ?>
                <li class="post-item <?php echo $list[$i]['is_notice'] ? 'bo_notice' : ''; ?>">
                    <div class="post-header">
                        <?php if ($is_checkbox) { ?>
                            <div class="bo_chk chk_box">
                                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>" class="selec_chk">
                                <label for="chk_wr_id_<?php echo $i ?>">
                                </label>   
                            </div>
                        <?php } ?>
                    </div>
                    <div class="post-info">
                        <span class="author"><?php echo $list[$i]['name']; ?></span>
                        <span class="date"><i class="fa fa-calendar-times-o" aria-hidden="true"></i> <?php echo $list[$i]['datetime2']; ?></span>
                        
                    </div>
                    <div class="post-content">
                        <div class="post-thumbnail">
                        <a href="<?php echo $list[$i]['href'] ?>" class="bo_subject">
                            <?php
                            $thumb = get_list_thumbnail($board['bo_table'], $list[$i]['wr_id'], "50", "40");
                            if ($thumb['src']) {
                                echo '<img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'" width="100%" height="100%">';
                            }
                            ?>
                            </a>
                        </div>
                        <div class="post-text">                        
                                         <a href="<?php echo $list[$i]['href'] ?>" class="bo_subject">
                            <p class="latest_subject" style="margin-bottom:5px;font-size:14px;font-weight:540;color:#2a2a2a;"><?php echo $list[$i]['subject']; ?></p>
                            <p class="latest_content"><?php echo strip_tags($list[$i]['wr_content']); ?></p>
                            </a>
                        </div>
                    </div>
                    <div class="post-meta">
                    <a href="<?php echo $list[$i]['href'] ?>" class="bo_subject">
                        <?php if ($is_good) { ?><span class="likes"><i class="fa fa-heart-o" aria-hidden="true"></i> <?php echo $list[$i]['wr_good']; ?></span><?php } ?>
                        <?php if ($is_nogood) { ?><span class="dislikes"><i class="fa fa-thumbs-o-down" aria-hidden="true"></i> <?php echo $list[$i]['wr_nogood']; ?></span><?php } ?>
                       <span class="comments"><i class="fa fa-comments-o" aria-hidden="true"></i><?php echo $view['wr_comment']; ?></span>
                       <span class="views"><i class="fa fa-align-right" aria-hidden="true" style="transform: rotate(90deg);"></i> <?php echo number_format($list[$i]['wr_hit']); ?>회</span>
                        </a>
                            </div>
                </li>
            <?php } ?>
            <?php if (count($list) == 0) { echo '<li class="empty_table">게시물이 없습니다.</li>'; } ?>
        </ul>
    </div>
</div>
</form>

<style>
#bo_list {
    font-family: Arial, sans-serif;
    width:100%;
    max-width: 850px;
    margin: 0 auto;
    border-radius: 8px;
    padding: 20px;
}

.list_01 {
    margin: 20px 0;
}

.post-list {
    list-style-type: none;
    padding: 0;
}

.post-item {
    background-color: #ffffff;
    border: 1px solid #e1e8ed;
    border-radius: 8px;
    margin-bottom: 15px;
    padding: 15px;
}

.post-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.author img {
border-radius: 50%;
width:30px;
height:30px;
}

.bo_subject {
    text-decoration: none;
    color: #3a3a3a;
    font-weight: bold;
}

.bo_subject:hover {
    text-decoration: underline;
}

.post-info {
    font-size: 14px;
    color: #657786;
    margin-top: 5px;
}

.post-content {
    display: flex;
    margin-top: 10px;
    margin-left: 30px;
}

.post-thumbnail {
    flex: 0 0 80px; /* 썸네일 크기 */
    margin-right: 10px;
}

.post-thumbnail img{
border-radius: 15px;
}

.post-text {
    flex: 1;
}

.views, .likes, .date, comments {
    margin: 5px
}

.post-meta {
    display: flex;
    font-size: 12px;
    color: #aab8c2;
    bottom: -10px;
    text-align: right;
    margin-right:10px
}

.empty_table {
    text-align: center;
    color: #657786;
    font-style: italic;
}
</style>
<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<!-- 페이지{
<?php echo $write_pages; ?>

<div id="bo_list_total">
    <span>전체 <?php echo number_format($total_count) ?>건</span>
    <?php echo $page ?> 페이지
</div>-->

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == 'copy')
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

// 게시판 리스트 관리자 옵션
jQuery(function($){
    $(".btn_more_opt.is_list_btn").on("click", function(e) {
        e.stopPropagation();
        $(".more_opt.is_list_btn").toggle();
    });
    $(document).on("click", function (e) {
        if(!$(e.target).closest('.is_list_btn').length) {
            $(".more_opt.is_list_btn").hide();
        }
    });
});
</script>
<?php } ?>
<!-- 게시판 목록 끝 -->
