<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 썸네일 크기 설정
$thumb_width = 350; // 너비
$thumb_height = 200; // 높이
?>

<div class="latest_wrap">
    <?php
    for ($i=0; $i<count($list); $i++) {
        $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

        if($thumb['src']) {
            $img = $thumb['src'];
        } else {
            $img = $latest_skin_url.'/img/noimg.png';
            $thumb['alt'] = '등록된 이미지가 없습니다.';
        }
        $img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
    ?>

    <div class="latest_item" onclick="location.href='<?php echo $list[$i]['href'] ?>';" style="cursor: pointer;">
        <div class="latest_info">
            <div class="latest_member_id">
                <?php echo $list[$i]['name'] ?>
            </div>
            <div class="latest_subject">
                <?php echo $list[$i]['subject'] ?>
            </div>
            <div class="latest_content">
                <?php echo cut_str(strip_tags($list[$i]['wr_content']), 80)?>
            </div>
        </div>
        <div class="latest_img">
            <?php echo $img_content; ?>
        </div>
    </div>

    <?php } ?>
    <?php if (count($list) == 0) { //게시물이 없을 때  ?>
    <div class="latest_item">
        <div class="latest_content">
            등록된 게시물이 없습니다.
        </div>
    </div>
    <?php } ?>

</div>

<style>
.latest_wrap {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 20px;
}

.latest_item {
    display: flex;
    align-items: center;
    background-color: #fff;
    border-radius: 10px;
    overflow: hidden;
    width: calc(100% - 40px); /* 여백을 제외한 너비 */
    max-width: 800px; /* 최대 너비 설정 */
    transition: transform 0.3s ease;
}

.latest_item:hover {
    transform: scale(1.05);
}

.latest_info {
    padding: 10px;
    flex: 1; /* 제목과 본문이 가능한 공간을 차지하도록 설정 */
}

.latest_member_id, .latest_subject {
    font-family: 'Montserrat', sans-serif;
    font-weight: bold;
    margin-bottom: 5px;
}

.latest_content {
    font-family: 'Roboto', sans-serif;
    font-size: 14px;
    color: #3a3a3a;
}

.latest_img {
    width: 350px; /* 고정된 너비 */
    height: 200px; /* 고정된 높이 */
    overflow: hidden;
}

.latest_img img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* 이미지 비율 유지 */
    border-radius: 5px;
    filter: brightness(1.1) contrast(1.1);
}

@media (max-width: 768px) {
    .latest_item {
        flex-direction: column; /* 모바일에서 세로 정렬 */
        width: 100%; /* 모바일에서 전체 너비 사용 */
    }

    .latest_img {
        width: 100%; /* 이미지가 전체 너비를 차지하도록 설정 */
        height: auto; /* 자동 높이 설정 */
    }
}
</style>

<script>
// 클릭 시 애니메이션 효과를 추가할 수 있는 자바스크립트
document.querySelectorAll('.latest_item').forEach(item => {
    item.addEventListener('click', function() {
        this.classList.add('clicked');
        setTimeout(() => {
            this.classList.remove('clicked');
        }, 300);
    });
});
</script>