<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
include_once(G5_THEME_PATH.'/head.php');
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
$thumb_width = 1000;
$thumb_height = 1000;
?>

<span style="margin-bottom:50px; margin-left:25px;font-size: 20px;font-weight:510;color:#2c2c2c">저장 게시물 목록</span>
<!-- 스크랩 목록 시작 { -->
<div id="scrap" class="new_win">
    <ul>
        <?php for ($i=0; $i<count($list); $i++) {  ?>
        <li>
            <a href="<?php echo $list[$i]['opener_href_wr_id'] ?>" target="_blank">
                <div class="scrap_image">
                    <?php
                        $thumb = get_list_thumbnail($list[$i]['bo_table'], $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);
                        if($thumb['src']) {
                            $img = $thumb['src'];
                            echo '<img src="'.$img.'" alt="'.$thumb['alt'].'" style="max-width:100px;max-height:100px;">';
                        }
                    ?>
                </div>
                <div class="scrap_info">
                    <p class="scrap_tit">
                        <?php echo $list[$i]['subject'] ?>
                    </p>
                    <span class="scrap_datetime"><i class="fa fa-clock-o" aria-hidden="true"></i> <?php echo $list[$i]['ms_datetime'] ?></span>
                </div>
            </a>
            <a href="<?php echo $list[$i]['del_href']; ?>" onclick="del(this.href); return false;" class="scrap_del"><i class="fa fa-trash-o" aria-hidden="true"></i><span class="sound_only">삭제</span></a>
        </li>
        <?php }  ?>
    </ul>
</div>

    <?php echo get_paging($config['cf_mobile_pages'], $page, $total_page, "?$qstr&amp;page="); ?>
    
<!-- } 스크랩 목록 끝 -->

<style>
/* 스크랩 목록 스타일 */
#scrap {
  padding: 20px;
}

#scrap ul {
  list-style-type: none;
  padding: 0;
  margin: 0;
}

#scrap li {
  display: flex;
  align-items: flex-start; /* 수직 정렬을 상단으로 */
  justify-content: space-between; /* 요소를 양쪽 끝으로 배치 */
  margin-bottom: 20px;
  border-bottom: 1px solid #f2f2f2;
  padding-bottom: 20px;
  background-color: #fff;
  border-radius: 10px;
  box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
  padding: 20px;
  position: relative;
}

#scrap .scrap_del {
  color: #999;
  font-size: 16px;
  margin-left: 10px; /* 왼쪽 여백 추가 */
  position: absolute; /* 절대 위치로 설정 */
  bottom: 10px; /* 아래쪽 여백 */
  right: 10px; /* 오른쪽 여백 */
}

#scrap .scrap_image {
  margin-right: 10px;
}

#scrap .scrap_image img {
  margin-right: 10px;
  border-radius: 15px;
  width: 100px; /* 고정된 너비 */
  height: 100px; /* 고정된 높이 */
  object-fit: cover; /* 이미지 비율 유지하며 클리핑 */
}

#scrap .scrap_info {
  display: flex;
  flex-direction: column;
  flex-grow: 1;
}

#scrap .scrap_info .scrap_tit {
  text-decoration: none;
  color: #333;
  font-weight: 520;
  font-size: 15px;
  margin-bottom: 5px; /* 날짜와의 간격 조정 */
}

#scrap .scrap_info .scrap_datetime {
  font-size: 14px;
  color: #666;
}
</style>