<?php

/**
 * Tiny MCE 6
 */
if (!defined('_GNUBOARD_')) {
  exit;
}
/***************************************************
 * Only these origins are allowed to upload images *
 ***************************************************/
if (!function_exists('_get_hostname')) {
  /**
   * 사이트 URL
   *
   * @return void
   */
  function _get_hostname()
  {
    if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) {
      $protocol = 'https://';
    } else {
      $protocol = 'http://';
    }
    //cloudflare 사용시 처리
    if (isset($_SERVER['HTTP_CF_VISITOR']) && $_SERVER['HTTP_CF_VISITOR']) {
      if (json_decode($_SERVER['HTTP_CF_VISITOR'])->scheme == 'https')
        $_SERVER['HTTPS'] = 'on';
      $protocol = 'https://';
    }

    $domainName = $_SERVER['HTTP_HOST'];
    return $protocol . $domainName;
  }
}

/**
 * editor_html
 *
 * @param  mixed $id
 * @param  mixed $content
 * @param  mixed $is_dhtml_editor
 * @return void
 */
function editor_html($id, $content, $is_dhtml_editor = true)
{
  global $g5, $config, $w, $board, $write;
  static $js = true;
  $hostname = _get_hostname();

  if (
    $is_dhtml_editor && $content && (
      (!$w && (isset($board['bo_insert_content']) && !empty($board['bo_insert_content'])))
      || ($w == 'u' && isset($write['wr_option']) && strpos($write['wr_option'], 'html') === false))
  ) {       //글쓰기 기본 내용 처리
    if (preg_match('/\r|\n/', $content) && $content === strip_tags($content, '<a><strong><b>')) {  //textarea로 작성되고, html 내용이 없다면
      $content = nl2br($content);
    }
  }
  //$config['cf_editor'] 는 common.php에서 처리하네.
  $editor_url = (isset($board['bo_select_editor']) && $board['bo_select_editor'] != '') ?  G5_EDITOR_URL . '/' . $board['bo_select_editor'] : G5_EDITOR_URL . '/' . $config['cf_editor'];
  $editor_path = G5_DATA_PATH . '/' . 'editor';
  if (!file_exists($editor_path)) {
    mkdir($editor_path, 0777, true);
  }

  $html = '';
  $html .= '<span class="sr-only">웹에디터 시작</span>';

  if ($is_dhtml_editor && $js) {
    $html .= '<script src="' . G5_EDITOR_URL . '/' . $config['cf_editor'] . '/tinymce-jquery.min.js"></script>';
    $html .= '<script src="' . G5_EDITOR_URL . '/' . $config['cf_editor'] . '/tinymce.min.js"></script>';
    //$html .= '<script src="' . G5_EDITOR_URL . '/' . $config['cf_editor'] . '/langs/ko_KR.js"></script>';
    //$html .= '<script src="/plugin/editor/tinymce-stand/ace-builds/src-min-noconflict/ace.js"></script>';
    $js = false;
  }

  $tinymce_class = $is_dhtml_editor ? 'tinymce-editor ' : '';
  $html .= '<textarea id="' . $id . '" name="' . $id . '" class=" form-control ' . $tinymce_class . '" maxlength="65536">' . $content . '</textarea>';
  $html .= '<span class="sr-only">웹 에디터 끝</span>';
  $html .= "
  <script>
  $(function(){
  function dataURItoBlob(dataURI) {
    var byteString = atob(dataURI.split(',')[1]);
    var mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0];
    var ab = new ArrayBuffer(byteString.length);
    var ia = new Uint8Array(ab);
    for (var i = 0; i < byteString.length; i++) {
      ia[i] = byteString.charCodeAt(i);
    }
    return new Blob([ab], {type: mimeString});
  }

  var editorUploadUrl = '{$editor_url}/image-uploader.php';
  var boUploadSize = {$board['bo_upload_size']};

  const useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
  const isSmallScreen = window.matchMedia('(max-width: 1023.5px)').matches;
  const bb_image_upload = (blobInfo, progress) => new Promise((resolve, reject) => {
    const xhr = new XMLHttpRequest();
    xhr.withCredentials = false;
    xhr.open('POST', '{$editor_url}/image-uploader.php');
 
  // 파일 크기 체크
    if (blobInfo.blob().size > boUploadSize) {
    // 실패한 이미지 삭제
      tinymce.activeEditor.execCommand('mceRemoveNode', false, tinymce.activeEditor.dom.select('img[src^=\"blob:\"]'));
      
      reject('이미지 크기가 ('+boUploadSize / (1024*1024)+' MB)를 초과합니다. 더 작은 파일을 선택해 주세요.');
      return;
      
    }

    xhr.upload.onprogress = (e) => {
      progress(e.loaded / e.total * 100);
    };
  
   xhr.onload = () => {
    if (xhr.status !== 200) {
      reject('HTTP Error: ' + xhr.status);
      return;
    }

    let json;
    try {
        json = JSON.parse(xhr.responseText);
      } catch (e) {
        reject('Invalid JSON: ' + xhr.responseText);
        return;
      }

      if (!json || typeof json.location != 'string') {
        reject('Invalid JSON: ' + xhr.responseText);
        return;
      }

      resolve(json.location);
    };
  
    xhr.onerror = () => {
      reject('Image upload failed due to a XHR Transport error. Code: ' + xhr.status);
    };
    const formData = new FormData();
    formData.append('file', blobInfo.blob(), blobInfo.filename());
    formData.append('bo_upload_size', boUploadSize);  // 이 줄을 추가

    xhr.send(formData);

  });// bb_upload




 function uploadExternalImage(src, uniqueId) {
  fetch('{$editor_url}/proxy-endpoint.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({ url: src }),
  })
  .then(response => response.json())
  .then(data => {
    if (data.success && data.url) {
      var img = tinymce.activeEditor.dom.get(uniqueId);
      if (img) {
        tinymce.activeEditor.dom.setAttrib(img, 'src', data.url);
        tinymce.activeEditor.dom.setAttrib(img, 'id', '');
        tinymce.activeEditor.dom.setAttrib(img, 'data-original-src', null);
      } else {
        tinymce.activeEditor.insertContent('<img src=\"' + data.url + '\">');
      }
      tinymce.activeEditor.notificationManager.close();
      tinymce.activeEditor.notificationManager.open({
        text: '이미지 업로드 완료',
        type: 'success'
      });
    } else {
      throw new Error(data.error || 'Unknown error');
    }
  })
  .catch(error => {
    console.error('Image upload failed:', error);
    tinymce.activeEditor.notificationManager.open({
      text: '이미지 업로드 실패: ' + error.message,
      type: 'error'
    });
    // 업로드 실패 시 로딩 이미지 제거
    var img = tinymce.activeEditor.dom.get(uniqueId);
    if (img) {
      tinymce.activeEditor.dom.remove(img);
    }
  });
}
  



  tinymce.init({
      selector: '#{$id}',
      language:'ko_KR',
      height: 600,
      skin: 'oxide',
      license_key:'gpl',
      content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',
      image_caption: true,
      quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
      noneditable_class: 'mceNonEditable',
      contextmenu: 'link image table',
      highlight_on_focus: false,
      importcss_append: true,
      images_file_types : 'jpg,png,webp,gif',
      plugins: 'preview importcss searchreplace autolink directionality code visualblocks visualchars fullscreen image link media  codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons ace',
      external_plugins: {
        'ace': '" . G5_PLUGIN_URL . "/editor/{$config['cf_editor']}/plugins/ace/plugin.js'
      },
      editimage_cors_hosts: ['picsum.photos'],
      menubar: 'file edit view insert format tools table help',
      toolbar: ' undo redo fullscreen ace | bold italic underline strikethrough table | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | preview save print | image media link anchor codesample',
      toolbar_sticky: false,
      toolbar_sticky_offset: isSmallScreen ? 102 : 108,
      image_advtab: true,
      toolbar_mode: 'sliding',
      contextmenu: 'link image table',
      table_default_attributes: {
        class: 'table table-bordered'
      }, 
      image_class_list: [{title: 'Responsive', value: 'img-fluid'}],
      mobile: {
        menubar: 'false',
        plugins: 'lists autolink image',
        toolbar: 'undo redo bold italic image | fontfamily fontsize | alignleft aligncenter alignright alignjustify'
      },
      
      content_css: [
          '" . G5_PLUGIN_URL . "/editor/{$config['cf_editor']}/bootstrap.css',
          '" . G5_PLUGIN_URL . "/editor/{$config['cf_editor']}/bootstrap-icons.css'
      ],
      
      relative_urls : false,
      remove_script_host : false,
      convert_urls : true,
      paste_data_images: true,

 

     paste_preprocess: function(plugin, args) {
    var content = args.content;
    var domain = window.location.origin;
    
    // 외부 이미지 URL 감지 (내부 이미지는 제외)
    content = content.replace(/<img[^>]+src=\"(https?:\/\/[^\"]+)\"[^>]*>/gi, function(match, url) {
      // 내부 이미지인 경우 그대로 반환
      if (url.startsWith(domain)) {
        return match;
      }
      
      // 외부 이미지인 경우 처리
      var uniqueId = 'loading-' + Date.now();
      
      // 사용자에게 알림
      tinymce.activeEditor.notificationManager.open({
        text: '외부 이미지가 감지되었습니다. 이미지를 업로드 중입니다...',
        type: 'info'
      });

      // 이미지 업로드 함수 호출
      uploadExternalImage(url, uniqueId);

      // 임시 이미지로 대체 (업로드 완료 후 교체됨)
      return '<img id=\"' + uniqueId + '\" src=\"{$editor_url}/loading.gif\" data-original-src=\"' + url + '\">';
    });

    args.content = content;
  },

  setup: function(editor) {
    editor.on('LoadContent', function(e) {
      // 임시 이미지를 실제 업로드된 이미지로 교체
      editor.dom.select('img[data-original-src]').forEach(function(img) {
        var originalSrc = img.getAttribute('data-original-src');
        var uniqueId = img.id || 'loading-' + Date.now();
        uploadExternalImage(originalSrc, uniqueId);
      });
    });
  },



      images_upload_url: '{$editor_url}/image-uploader.php',
      automatic_uploads: true,
      images_reuse_filename:false,
      images_upload_base_path : '{$editor_path}/images',
      images_upload_credentials:true,
      file_picker_types: 'file image media',
      block_unsupported_drop : true,
      images_upload_handler: bb_image_upload,
      





      //sidebar_show : 'mysidebar',
      content_style: `body{padding:1rem;} img { max-width: 100% !important; height: auto !important; }`,
      image_dimensions: false,
      image_advtab: true,
      setup: function (editor) {
        editor.on('init', function () {
            //console.log('Editor initialized');
            //console.log('Ace plugin loaded:', editor.plugins.ace !== undefined);
            //console.log('Available buttons:', editor.ui.registry.getAll().buttons);
        });
        }
      }
    );
});
</script>";

  return $html;
}

/**
 * textarea 로 값을 넘긴다. javascript 반드시 필요
 *
 * @param  mixed $id
 * @param  mixed $is_dhtml_editor
 * @return void
 */
function get_editor_js($id, $is_dhtml_editor = true)
{
  if ($is_dhtml_editor) {
    return " var {$id}_editor_data = tinymce.get('{$id}').getContent(); ";
  } else {
    return ' var ' . $id . '_editor = document.getElementById("' . $id . '"); ';
  }
}


/**
 * textarea 의 값이 비어 있는지 검사
 *
 * @param  mixed $id
 * @param  mixed $is_dhtml_editor
 * @return void
 */
function chk_editor_js($id, $is_dhtml_editor = true)
{
  if ($is_dhtml_editor) {
    return ' if (!' . $id . '_editor_data) { alert("내용을 입력해 주십시오."); tinymce.activeEditor.focus();  return false; } if (typeof(f.' . $id . ')!="undefined") f.' . $id . '.value = ' . $id . '_editor_data; ';
  } else {
    return ' if (!' . $id . '_editor.value) { alert("내용을 입력해 주십시오."); ' . $id . '_editor.focus(); return false; } ';
  }
}
