tinymce.PluginManager.add('ace', function (editor, url) {
    var scriptLoader = new tinymce.dom.ScriptLoader();

    scriptLoader.loadScript(url + '/ace-builds/src-min-noconflict/ace.js', function () {
        initAceEditor();
    });

    function initAceEditor() {
        function openAceDialog() {
            var win = editor.windowManager.open({
                title: "Ace Editor",
                size: 'large',
                body: {
                    type: 'panel',
                    items: [
                        {
                            type: 'htmlpanel',
                            html: '<div id="ace-editor" style="width: 100%; height: 400px; border: 1px solid #ccc;"></div>'
                        }
                    ]
                },
                buttons: [
                    {
                        type: 'cancel',
                        text: 'Close'
                    },
                    {
                        type: 'submit',
                        text: 'Save',
                        primary: true
                    }
                ],
                onSubmit: function (api) {
                    var content = aceEditorInstance.getValue();
                    editor.setContent(content);
                    api.close();
                },
                onClose: function () {
                    aceEditorInstance.destroy();
                    aceEditorInstance.container.remove();
                }
            });

            var aceEditorInstance = ace.edit('ace-editor');
            aceEditorInstance.setTheme("ace/theme/textmate");
            aceEditorInstance.session.setMode("ace/mode/html");
            aceEditorInstance.setValue(editor.getContent());
        }

        editor.ui.registry.addButton('ace', {
            icon: 'code',
            tooltip: 'Ace Editor',
            onAction: openAceDialog
        });

        editor.ui.registry.addMenuItem('ace', {
            icon: 'code',
            text: 'Ace Editor',
            onAction: openAceDialog
        });
    }

    return {
        getMetadata: function () {
            return {
                name: 'Ace Editor Plugin',
                url: 'https://www.ask-seo.net'
            };
        }
    };
});