<?php
// 이 파일은 새로운 파일 생성시 반드시 포함되어야 함
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

$begin_time = get_microtime();

if (!isset($g5['title'])) {
    $g5['title'] = $config['cf_title'];
    $g5_head_title = $g5['title'];
}
else {
    $g5_head_title = $g5['title']; // 상태바에 표시될 제목
    $g5_head_title .= " | ".$config['cf_title'];
}

// 현재 접속자
// 게시판 제목에 ' 포함되면 오류 발생
$g5['lo_location'] = addslashes($g5['title']);
if (!$g5['lo_location'])
    $g5['lo_location'] = addslashes(clean_xss_tags($_SERVER['REQUEST_URI']));
$g5['lo_url'] = addslashes(clean_xss_tags($_SERVER['REQUEST_URI']));
if (strstr($g5['lo_url'], '/'.G5_ADMIN_DIR.'/') || $is_admin == 'super') $g5['lo_url'] = '';

/*
// 만료된 페이지로 사용하시는 경우
header("Cache-Control: no-cache"); // HTTP/1.1
header("Expires: 0"); // rfc2616 - Section 14.21
header("Pragma: no-cache"); // HTTP/1.0
*/
?>
<!doctype html>
<html lang="ko">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="" />
<meta name="author" content="http://bootstraptaste.com" />

<title><?php echo $g5_head_title; ?></title>

<!-- css -->
<link href="<?php echo G5_THEME_CSS_URL; ?>/bootstrap.min.css" rel="stylesheet" />
<link href="<?php echo G5_THEME_CSS_URL; ?>/fancybox/jquery.fancybox.css" rel="stylesheet">
<link href="<?php echo G5_THEME_CSS_URL; ?>/jcarousel.css" rel="stylesheet" />
<link href="<?php echo G5_THEME_CSS_URL; ?>/flexslider.css" rel="stylesheet" />
<link href="<?php echo G5_THEME_CSS_URL; ?>/style.css" rel="stylesheet" />
<link href="<?php echo G5_THEME_CSS_URL; ?>/default.css" rel="stylesheet" />

<!-- Theme skin -->
<link href="<?php echo G5_THEME_URL; ?>/skins/default.css" rel="stylesheet" />

<!-- javascript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="<?php echo G5_THEME_JS_URL; ?>/jquery.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/jquery.easing.1.3.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/bootstrap.min.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/jquery.fancybox.pack.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/jquery.fancybox-media.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/google-code-prettify/prettify.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/portfolio/jquery.quicksand.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/portfolio/setting.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/jquery.flexslider.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/animate.js"></script>
<script src="<?php echo G5_THEME_JS_URL; ?>/custom.js"></script>

<!--[if lte IE 8]>
<script src="<?php echo G5_JS_URL ?>/html5.js"></script>
<![endif]-->
<script>
// 자바스크립트에서 사용하는 전역변수 선언
var g5_url       = "<?php echo G5_URL ?>";
var g5_bbs_url   = "<?php echo G5_BBS_URL ?>";
var g5_is_member = "<?php echo isset($is_member)?$is_member:''; ?>";
var g5_is_admin  = "<?php echo isset($is_admin)?$is_admin:''; ?>";
var g5_is_mobile = "<?php echo G5_IS_MOBILE ?>";
var g5_bo_table  = "<?php echo isset($bo_table)?$bo_table:''; ?>";
var g5_sca       = "<?php echo isset($sca)?$sca:''; ?>";
var g5_editor    = "<?php echo ($config['cf_editor'] && $board['bo_use_dhtml_editor'])?$config['cf_editor']:''; ?>";
var g5_cookie_domain = "<?php echo G5_COOKIE_DOMAIN ?>";
</script>

<script src="<?php echo G5_JS_URL ?>/jquery.menu.js"></script>
<script src="<?php echo G5_JS_URL ?>/common.js"></script>
<script src="<?php echo G5_JS_URL ?>/wrest.js"></script>
<?php
if(G5_IS_MOBILE) {
    echo '<script src="'.G5_JS_URL.'/modernizr.custom.70111.js"></script>'.PHP_EOL; // overflow scroll 감지
}
if(!defined('G5_IS_ADMIN'))
    echo $config['cf_add_script'];
?>
</head>
<body>
