<?php
// 이 파일은 새로운 파일 생성시 반드시 포함되어야 함
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

$begin_time = get_microtime();

if (!isset($g5['title'])) {
    $g5['title'] = $config['cf_title'];
    $g5_head_title = $g5['title'];
}
else {
    $g5_head_title = $g5['title']; // 상태바에 표시될 제목
    $g5_head_title .= " | ".$config['cf_title'];
}

// 현재 접속자
// 게시판 제목에 ' 포함되면 오류 발생
$g5['lo_location'] = addslashes($g5['title']);
if (!$g5['lo_location'])
    $g5['lo_location'] = addslashes(clean_xss_tags($_SERVER['REQUEST_URI']));
$g5['lo_url'] = addslashes(clean_xss_tags($_SERVER['REQUEST_URI']));
if (strstr($g5['lo_url'], '/'.G5_ADMIN_DIR.'/') || $is_admin == 'super') $g5['lo_url'] = '';

/*
// 만료된 페이지로 사용하시는 경우
header("Cache-Control: no-cache"); // HTTP/1.1
header("Expires: 0"); // rfc2616 - Section 14.21
header("Pragma: no-cache"); // HTTP/1.0
*/
?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<?php
if (G5_IS_MOBILE) {
    echo '<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=0,maximum-scale=10,user-scalable=yes">'.PHP_EOL;
    echo '<meta name="HandheldFriendly" content="true">'.PHP_EOL;
    echo '<meta name="format-detection" content="telephone=no">'.PHP_EOL;
} else {
    echo '<meta http-equiv="imagetoolbar" content="no">'.PHP_EOL;
    echo '<meta http-equiv="X-UA-Compatible" content="IE=edge">'.PHP_EOL;
}

if($config['cf_add_meta'])
    echo $config['cf_add_meta'].PHP_EOL;
?>
<title><?php echo $g5_head_title; ?></title>
<link rel="stylesheet" href="<?php echo G5_THEME_CSS_URL; ?>/<?php echo G5_IS_MOBILE ? 'mobile' : 'default'; ?>.css?ver=<?php echo G5_CSS_VER; ?>">

<!--[if lte IE 8]>
<script src="<?php echo G5_JS_URL ?>/html5.js"></script>
<![endif]-->
<script>
// 자바스크립트에서 사용하는 전역변수 선언
var g5_url       = "<?php echo G5_URL ?>";
var g5_bbs_url   = "<?php echo G5_BBS_URL ?>";
var g5_is_member = "<?php echo isset($is_member)?$is_member:''; ?>";
var g5_is_admin  = "<?php echo isset($is_admin)?$is_admin:''; ?>";
var g5_is_mobile = "<?php echo G5_IS_MOBILE ?>";
var g5_bo_table  = "<?php echo isset($bo_table)?$bo_table:''; ?>";
var g5_sca       = "<?php echo isset($sca)?$sca:''; ?>";
var g5_editor    = "<?php echo ($config['cf_editor'] && $board['bo_use_dhtml_editor'])?$config['cf_editor']:''; ?>";
var g5_cookie_domain = "<?php echo G5_COOKIE_DOMAIN ?>";
</script>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
<script src="<?php echo G5_JS_URL ?>/jquery.menu.js?ver=<?php echo G5_JS_VER; ?>"></script>
<script src="<?php echo G5_JS_URL ?>/common.js?ver=<?php echo G5_JS_VER; ?>"></script>
<script src="<?php echo G5_JS_URL ?>/wrest.js?ver=<?php echo G5_JS_VER; ?>"></script>
<script src="<?php echo G5_JS_URL ?>/placeholders.min.js"></script>
<!-- boostrap loader start -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
<!-- boostrap loader end -->

<!-- slider loader start -->
<link rel="stylesheet" href="<?php echo G5_THEME_URL?>/api/slider/owl.carousel/css/owl.theme.default.css">
<link rel="stylesheet" href="<?php echo G5_THEME_URL?>/api/slider/owl.carousel/css/owl.carousel.css">
<link rel="stylesheet" href="<?php echo G5_THEME_URL?>/api/slider/owl.carousel/css/owl.carousel.min.css" />
<script src="<?php echo G5_THEME_URL ?>/api/slider/owl.carousel/js/owl.carousel.js"></script>
<script src="<?php echo G5_THEME_URL ?>/api/slider/owl.carousel/js/owl.carousel.min.js"></script>
<!-- slider loader end -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<link rel="stylesheet" href="<?php echo G5_JS_URL ?>/font-awesome/css/font-awesome.min.css">
<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
<?php
if(G5_IS_MOBILE) {
    echo '<script src="'.G5_JS_URL.'/modernizr.custom.70111.js"></script>'.PHP_EOL; // overflow scroll 감지
}
if(!defined('G5_IS_ADMIN'))
    echo $config['cf_add_script'];
?>
<style>
@import url(https://fonts.googleapis.com/earlyaccess/nanumgothic.css);
body {
font-family: "Nanum Gothic", sans-serif;
background: #fff;
-webkit-transition: all 0.1s ease;
-moz-transition: all 0.1s ease;
-moz-transition: all 0.1s ease;
-o-transition: all 0.1s ease;
transition: all 0.1s ease;
}
.color-background-F0EDE3 {
background: #F0EDE3;
-webkit-transition: all 0.1s ease;
-moz-transition: all 0.1s ease;
-moz-transition: all 0.1s ease;
-o-transition: all 0.1s ease;
transition: all 0.1s ease;
}
.hd_on {
position: relative; 
width:100%; 
background: #F0EDE3; 
background-position: center;
z-index: 100;
-webkit-transition: all 0.6s ease;
-moz-transition: all 0.6s ease;
-moz-transition: all 0.6s ease;
-o-transition: all 0.6s ease;
transition: all 0.6s ease;
padding: 11px;
}
.hd_top {
position: fixed;
background: black;
z-index: 10000;
width: 100%;
top: 0px;
-webkit-transition: all 0.6s ease;
-moz-transition: all 0.6s ease;
-moz-transition: all 0.6s ease;
-o-transition: all 0.6s ease;
transition: all 0.6s ease;
padding: 0;
color: white;
}

.width-80 {
    width: 80%;
}
.width-100 {
    width: 100%;
}
.height-80 {
 height: 80%;
}
.img-responsive{
  max-width: 100%;
  height: 80%;
}
.padding-200 {
    padding-top: 200px;
    padding-bottom: 200px;
}
.padding-0 {
    padding:0 0 0 0;
}
.col-centered {
    float: none;
    display: block;
    margin: 0 auto;
}

.cols-2 {
    -webkit-box-flex: 0;
    -ms-flex: 0 0 16.6666667%;
    flex: 0 0 16.666667;
    max-width: 16.66%;
}
.cols-3 {
    -webkit-box-flex: none;
    -ms-flex: none;
    flex: none; 
    max-width: none;
}
.min-width {
    min-width: 200px;
}
.flex-none {
    -webkit-box-flex: 0;
    -ms-flex: none;
    flex: none;
}
.float-on {
    float: left;
}
.font-color {
    color: #cecece;
}
.min-width-200 {
    width: 200px; 
    height: 100%; 
    min-width: 300px; 
    min-height: 300px; 
    background: #fff;
    
    border: 1px dotted #cecece;
}
.w3-cards {
    box-shadow: 0px 2px 5px 0px rgba(0,0,0,0.16), 0px 2px 10px 0px rgba(0,0,0,0.12);
}
.cols-4 {
    -webkit-box-flex: 0;
    -ms-flex: 0 0 33.333333%;
    flex: 0 0 33.333333%;
    max-width: 33.33%;
}

@media only screen and (max-width: 1000px) {
    body {
        background-color: lightblue;
        font-size: 20px;
        -webkit-transition: all 0.1s ease;
-moz-transition: all 0.1s ease;
-moz-transition: all 0.1s ease;
-o-transition: all 0.1s ease;
transition: all 0.1s ease;
    }
    .navbar-toggler {
        font-size: 2em;
    }
    /** layout life start **/
    .cols-2 {
    -webkit-box-flex: 0;
    -ms-flex: none;
    flex: none;
    max-width: 100%;
    }
.cols-3 {
    -webkit-box-flex: 0;
    -ms-flex: none;
    flex: none;
    max-width: none;
    float: left;
}
.min-width-200 {
    width: 200px; 
    height: 100%; 
    min-width: 400px; 
    min-height: 300px;
    font-size: 1.8em;
    background: #fff;
}
.cols-4 {
    -webkit-box-flex: 0;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}
/*layout life stop */
}
@media only screen and (max-width: 1500px) {
   /** layout life start **/
    .cols-2 {
    -webkit-box-flex: 0;
    -ms-flex: none;
    flex: none;
    max-width: 100%;
    }
.cols-3 {
    -webkit-box-flex: 0;
    -ms-flex: none;
    flex: none;
    max-width: none;
    float: left;
}
/** layout life stop **/

}
</style>

<script>
    //스크롤에 의한 이벤트 처리.
    $(window).bind( "scroll", function(e) {
	var window = $(this).scrollTop();
	var divId = $('.main-start').offset();
	if (divId.top < window) {
		if($(".pos-f-t").hasClass("hd_top") === false) {
			// 속성값이 존재함.
			$(".pos-f-t").toggleClass("hd_top");
			$(".pos-f-t").removeClass("hd_on");
			}
	}else {
		if($(".pos-f-t").hasClass("hd_top") === true) {
			$(".pos-f-t").toggleClass("hd_top");
			$(".pos-f-t").toggleClass("hd_on");
		}
		}
    });
    </script>
<!-- favicon start-->
<?php include_once(G5_THEME_PATH.'/img/favicon/favicon.php');?>
<!-- favicon end -->
</head>
<body<?php echo isset($g5['body_script']) ? $g5['body_script'] : ''; ?>>