<?php
/*
 *  배너 목록
 */
include_once './_common.php';
include_once './index.php';
$asktheme_upload_url = G5_DATA_URL . "/asktheme_attach";
if (!defined('_GNUBOARD_')) {
    exit;
}
include_once G5_PLUGIN_PATH . "/asktheme/_admin/head.php";
add_stylesheet('<link rel="stylesheet" href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin['id'] . '/plugin_style.css">', 0);
$banner_config = get_plugin_config($plugin['id']);
$sql = "select * from ask_plugin_banner";
$result = sql_query($sql);
?>
<div id="container">
    <div class="ask-row grid">
        <div class="col-2-12">
            <?php include_once './banner_menu.php'; ?>
        </div>
        <div class="col-10-12">
            <?php
            if ($banner_config['pc_use'] == 0) {
                echo "<div class='alert alert-default'>배너 플러그인이 사용 중지상태입니다. 설정 메뉴에서 변경가능합니다.</div>";
            }
            ?>
            <div class="panel panel-default">
                <div class="panel-header">
                    <h1><?php echo $plugin['name'], $plugin['version']; ?> 목록</h1>
                </div>
                <div class="panel-body">
                    <div class="responsetable tb-even center">
                        <div class="caption">
                            배너 목록
                        </div>
                        <div class="tb-header">
                            <div class="tb-row">
                                <div class="tb-cell">
                                    배너종류
                                </div>
                                <div class="tb-cell">
                                    게시위치(태그)
                                </div>
                                <div class="tb-cell">
                                    내용
                                </div>
                                <div class="tb-cell">
                                    상태
                                </div>
                                <div class="tb-cell">
                                    관리
                                </div>
                            </div>
                        </div>
                        <div class="tb-body">
                            <?php for ($i = 0; $rows = sql_fetch_array($result); $i++) { ?>
                                <div class="tb-row">
                                    <div class="tb-cell">
                                        <?php echo $rows['ab_type'] ?>
                                    </div>
                                    <div class="tb-cell">
                                        <?php echo $rows['ab_tag'] ?>
                                    </div>
                                    <div class="tb-cell left">
                                        <?php
                                        if ($rows['ab_type'] == 'text') {
                                            echo "<a href='{$rows['ab_link']}'>{$rows['ab_text']}</a>";
                                        }
                                        if ($rows['ab_type'] == 'image') {
                                            $imginfo = explode("||", $rows['ab_mime']);
                                            echo "<a href='{$rows['ab_link']}' target='_blank'><img src='{$asktheme_upload_url}/{$rows['ab_banner']}' class='ab_list_img'></a>";
                                        }
                                        if ($rows['ab_type'] == 'html') {
                                            echo '<textarea name="htmlview" rows="4" class="textarea">' . $rows['ab_html'] . '</textarea>';
                                        }
                                        ?>
                                    </div>
                                    <div class="tb-cell">
                                        <?php
                                        if ($rows['ab_status'] == 1) {
                                            echo '<span class="label label-default">사용중</span>';
                                        } else {
                                            echo '<span class="label label-danger">중지됨</span>';
                                        }
                                        ?>
                                    </div>
                                    <div class="tb-cell">
                                        <div class="button-group">
                                            <a href="./banner_add.php?w=u&idx=<?php echo $rows['ab_idx'] ?>" class="button primary">수정</a>
                                            <a href="./banner_delete.php?idx=<?php echo $rows['ab_idx'] ?>" class="button danger banner-delete">삭제</a>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                            <?php if ($i == 0) { ?>
                                <div class="tb-row-group">
                                    <div class="tb-row">
                                        <div class="tb-cell empty-table">
                                            등록된 배너가 없습니다.
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">

                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        $('.banner-delete').click(function () {
            if (confirm('배너를 삭제하시겠습니까?')) {
                return true;
            } else {
                return false;
            }
        });
    });
</script>
<?php
include_once G5_PLUGIN_PATH . "/asktheme/_admin/tail.php";
