<?php
if (!defined('_GNUBOARD_'))
    exit; // 개별 페이지 접근 불가
$nick = get_sideview($mb['mb_id'], $mb['mb_nick'], $mb['mb_email'], $mb['mb_homepage']);
if ($kind == "recv") {
    $kind_str = "보낸";
    $kind_date = "받은";
} else {
    $kind_str = "받는";
    $kind_date = "보낸";
}

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/mobile/asktheme.mobile_member.css">', 0);
include G5_THEME_PATH . "/head.php";
?>

<div class='page-wrap memoform-page'>
    <div class='page-title'>
        <h1><?php echo $g5['title'] ?></h1>
    </div>

    <div class='tab-wrap'>
        <ul class="tabs tab-header" id='tabs'>
            <li class='<?php echo $active_recv ?>'><a href="./memo.php?kind=recv">받은쪽지</a></li>
            <li class='<?php echo $active_send ?>'><a href="./memo.php?kind=send">보낸쪽지</a></li>
            <li class='<?php echo $active_form ?>'><a href="./memo_form.php">쪽지쓰기</a></li>
        </ul>
        <div class='tab-contents'>
            <article>
                <header class="sound-only">
                    <h1>쪽지 내용</h1>
                </header>
                <ul class='memo-info'>
                    <li>
                        <span class="memo_view_subj"><?php echo $kind_str ?>사람</span>
                        <strong><?php echo no_popup($nick) ?></strong>
                    </li>
                    <li>
                        <span class="memo_view_subj"><?php echo $kind_date ?>시간</span>
                        <strong><?php echo $memo['me_send_datetime'] ?></strong>
                    </li>
                </ul>
                <p class="memo-contents">
                    <?php echo conv_content($memo['me_memo'], 0) ?>
                </p>
            </article>

            <div class="button-group form-action-mini">
                <?php if ($prev_link) { ?>
                    <a href="<?php echo $prev_link ?>" class="button"><i class="fa fa-chevron-left"></i> <span class='hide-425'>이전쪽지</span></a>
                <?php } ?>
                <?php if ($next_link) { ?>
                    <a href="<?php echo $next_link ?>" class='button'><span class='hide-425'>다음쪽지</span> <i class="fa fa-chevron-right"></i> </a>
                <?php } ?>
                <?php if ($kind == 'recv') { ?>
                    <a href="./memo_form.php?me_recv_mb_id=<?php echo $mb['mb_id'] ?>&amp;me_id=<?php echo $memo['me_id'] ?>" class="button"> <i class="fa fa-reply"></i> <span class='hide-425'>답장</span></a>
                <?php } ?>
                <a href="./memo.php?kind=<?php echo $kind ?>" class="button"><i class="fa fa-list"></i> <span class='hide-425'>목록</span></a>
            </div>
        </div>
    </div>
</div>
<?php
include G5_THEME_PATH . "/tail.php";
