<?php
if (!defined("_GNUBOARD_")) {
    exit;
} // 개별 페이지 접근 불가
include_once(G5_LIB_PATH . '/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/mobile/asktheme.mobile_qa.css">', 0);
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>

<div class="page-wrap">
    <div class="page-title">
        <h1><?php echo $qaconfig['qa_title']; ?></h1>
    </div>
    <!-- 게시물 상단 버튼 시작 { -->
    <div class="button-container">
        <?php
        ob_start();
        ?>
        <?php if ($prev_href || $next_href) { ?>
            <div class="button-group">
                <?php if ($prev_href) { ?><a href="<?php echo $prev_href ?>" class="button"><i class="fa fa-arrow-left"></i> <span>이전글</span></a><?php } ?>
                <?php if ($next_href) { ?><a href="<?php echo $next_href ?>" class="button"><i class="fa fa-arrow-right"></i> <span>다음글</span></a><?php } ?>
            </div>
        <?php } ?>

        <div class="button-group">
            <?php if ($update_href) { ?><a href="<?php echo $update_href ?>" class="button"><i class="fa fa-pencil"></i> <span>수정</span></a><?php } ?>
            <?php if ($delete_href) { ?><a href="<?php echo $delete_href ?>" class="button" onclick="del(this.href); return false;"><i class="fa fa-trash"></i> <span>삭제</span></a><?php } ?>
            <a href="<?php echo $list_href ?>" class="button"><i class="fa fa-list-ol"></i> <span>목록</span></a>
            <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="button"><i class="fa fa-pencil-square-o"></i> <span>글쓰기</span></a><?php } ?>
        </div>
        <?php
        $link_buttons = ob_get_contents();
        ob_end_flush();
        ?>
    </div>
    <hr>
    <article class="view-contents">
        <header class="view-info">
            <h2>
                <?php
                echo $view['category'] . ' | '; // 분류 출력 끝
                echo $view['subject']; // 글제목 출력
                ?>
            </h2>
        </header>

        <section class="view-info">
            <h2 class="sound-only">페이지 정보</h2>
            <ul>
                <li>작성자 <strong><?php echo $view['name'] ?></strong></li>
                <li><span class="sound_only">작성일</span><strong><?php echo $view['datetime']; ?></strong></li>
                <?php if ($view['email'] || $view['hp']) { ?>
                    <?php if ($view['email']) { ?>
                        <li><?php echo $view['email']; ?></li>
                    <?php } ?>
                    <?php if ($view['hp']) { ?>
                        <li><?php echo $view['hp']; ?></li>
                    <?php } ?>

                <?php } ?>
            </ul>
        </section>

        <?php if ($view['download_count']) { ?>
            <!-- 첨부파일 시작 { -->
            <section class="view-files">
                <h2 class="sound-only">첨부파일</h2>
                <ul>
                    <?php
                    // 가변 파일
                    for ($i = 0; $i < $view['download_count']; $i++) {
                        ?>
                        <li>
                            <a href="<?php echo $view['download_href'][$i]; ?>" class="view_file_download">
                                <img src="<?php echo $qa_skin_url ?>/img/icon_file.gif" alt="첨부">
                                <strong><?php echo $view['download_source'][$i] ?></strong>
                            </a>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </section>
            <!-- } 첨부파일 끝 -->
        <?php } ?>

        <section class="view-content-wrap">
            <h2 class="sound-only">본문</h2>

            <?php
            // 파일 출력
            if ($view['img_count']) {
                echo "<div id=\"bo_v_img\">\n";

                for ($i = 0; $i < $view['img_count']; $i++) {
                    //echo $view['img_file'][$i];
                    echo get_view_thumbnail($view['img_file'][$i], $qaconfig['qa_image_width']);
                }

                echo "</div>\n";
            }
            ?>

            <!-- 본문 내용 시작 { -->
            <div class="view-contents-box"><?php echo get_view_thumbnail($view['content'], $qaconfig['qa_image_width']); ?></div>
            <!-- } 본문 내용 끝 -->

            <?php if ($view['qa_type']) { ?>
                <div id="bo_v_addq"><a href="<?php echo $rewrite_href; ?>" class="button">추가질문</a></div>
            <?php } ?>

        </section>

        <?php
        // 질문글에서 답변이 있으면 답변 출력, 답변이 없고 관리자이면 답변등록폼 출력
        if (!$view['qa_type']) {
            if ($view['qa_status'] && $answer['qa_id']) {
                include_once($qa_skin_path . '/view.answer.skin.php');
            } else {
                include_once($qa_skin_path . '/view.answerform.skin.php');
            }
        }
        ?>

        <?php if ($view['rel_count']) { ?>
            <section class="relation">
                <h2 class="sub-title">연관질문</h2>
                <div class="responsetable tb-even qna-table">
                    <div class="tb-header">
                        <div class='tb-row'>
                            <div class='tb-cell'>분류</div>
                            <div class='tb-cell'>제목</div>
                            <div class='tb-cell'>상태</div>
                            <div class='tb-cell'>등록일</div>
                        </div>
                    </div>
                    <div class="tb-body">
                        <?php
                        for ($i = 0; $i < $view['rel_count']; $i++) {
                            ?>
                            <div class='tb-row'>
                                <div class='tb-cell'><?php echo get_text($rel_list[$i]['category']); ?></div>
                                <div class='tb-cell wr-subject'>
                                    <a href="<?php echo $rel_list[$i]['view_href']; ?>">
                                        <?php echo cut_str($rel_list[$i]['subject'],39); ?>
                                    </a>
                                </div>
                                <div class='tb-cell <?php echo ($list[$i]['qa_status'] ? 'txt_done' : 'txt_rdy'); ?>'><?php echo ($rel_list[$i]['qa_status'] ? '<span class="reply-ok">답변완료</span>' : '<span class="replay-wait">답변대기</span>'); ?></div>
                                <div class='tb-cell'><?php echo $rel_list[$i]['date']; ?></div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </section>
        <?php } ?>
        <hr>
        <!-- 링크 버튼 시작 { -->
        <div class="button-container">
            <?php echo $link_buttons ?>
        </div>
        <!-- } 링크 버튼 끝 -->

    </article>
    <!-- } 게시판 읽기 끝 -->

    <script type="text/javascript">
        $(function () {
            $("a.view_image").click(function () {
                window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
                return false;
            });

            // 이미지 리사이즈
            $("#bo_v_atc").viewimageresize();
        });
    </script>
</div>