<?php
/*
 * ASK THEME Plugins Admin
 * 
 */
include_once "./_common.php";
define('_INDEX_', true);
if (!defined('_GNUBOARD_')) {
    exit;
}

//플러그인 테이블 존재 검사
function ask_dbtable_exist() {
    $sql = "show tables like 'ask_plugin_config'";
    $result = sql_fetch($sql);
    $sql = "CREATE TABLE `ask_plugin_config` (
  `pc_idx` int(11) NOT NULL AUTO_INCREMENT,
  `pc_id` varchar(100) NOT NULL,
  `pc_name` varchar(200) NOT NULL,
  `pc_use` int(11) NOT NULL,
  `pc_config` text NOT NULL,
  PRIMARY KEY (`pc_id`),
  UNIQUE KEY `pc_idx` (`pc_idx`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='ASK Theme Plugin settings';";
    if (!$result) {
        sql_query($sql);
    }
}

ask_dbtable_exist();
$g5['title'] = '플러그인 관리자';
include_once(G5_PLUGIN_PATH . '/asktheme/_admin/head.php');

$dir = G5_PLUGIN_PATH . "/asktheme/plugin";
$plugin_list = scandir($dir);
?>
<div class="page-wrap">
    <div class="page-title">
        <h1><?php echo $g5['title'] ?></h1>
    </div>
    <div class="text text-default">
        사용중인 또는 설치된 플러그인 목록입니다. 플러그인별 환경설정을 해야 사용가능합니다.
    </div>
    <div class="responsetable center tb-even">
        <div class="caption">
            Plugin List
        </div>
        <div class="tb-header">
            <div class="tb-row">
                <div class="tb-cell hide-for-small-only">
                    Screen
                </div>
                <div class="tb-cell">
                    Version   
                </div>
                <div class="tb-cell">
                    Subject
                </div>
                <div class="tb-cell show-for-medium">
                    Description
                </div>
                <div class="tb-cell">
                    Status
                </div>
            </div>
        </div>
        <div class="tb-body">
            <?php
            for ($i = 0; count($plugin_list) > $i; $i++) {
                if ($plugin_list[$i] == '.' || $plugin_list[$i] == '..') {
                    continue;
                }
                $target_dir = $dir . '/' . $plugin_list[$i];
                if (file_exists($target_dir . '/index.php')) {
                    include_once $target_dir . '/index.php';
                    $plugin_config = array();
                    if ($plugin) {
                        $sql = "select * from ask_plugin_config where pc_id = '{$plugin['id']}'";
                        $result = sql_fetch($sql);
                        $plugin_config = unserialize($result['pc_config']);
                        ?>
                        <?php
                        if ($plugin_config['pc_use'] == '0') {
                            $style = "style='color:#999;'";
                        } else if (!$plugin_config) {
                            $style = "style='color:#0033ff;font-weight:600'";
                        } else {
                            $style = '';
                        }
                        ?>
                        <div class="tb-row" <?php echo $style ?>>
                            <div class="tb-cell hide-for-small-only">
                                <img src="<?php echo G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin_list[$i] . '/' . $plugin['screenshot']; ?>" width="50"/>
                            </div>
                            <div class="tb-cell">
                                <?php echo $plugin['version']; ?>
                            </div>
                            <div class="tb-cell left">
                                <?php echo $plugin['name']; ?>
                            </div>
                            <div class="tb-cell left show-for-medium">
                                <?php
                                echo $plugin['description'];
                                //print_t($plugin_config);
                                ?>
                            </div>
                            <div class="tb-cell">
                                <div class="button-group">
                                    <?php
                                    if (!$plugin_config) {
                                        echo '<a href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin_list[$i] . '/setup.php" class="button">설치</a>';
                                    } else {
                                        if ($plugin_config['pc_use'] == '1') {
                                            echo '<a href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin_list[$i] . '/setup.php?w=u&mode=stop" class="button plugin-stop" target="hiddenframe"><i class="fa fa-ban" aria-hidden="true"></i> <span class="show-for-medium">중단</span></a>';
                                        } else if ($plugin_config['pc_use'] == '0') {
                                            echo '<a href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin_list[$i] . '/setup.php?w=u&mode=start" class="button plugin-stop" target="hiddenframe"><i class="fa fa-play" aria-hidden="true"></i> <span class="show-for-medium">사용</span></a>';
                                        }
                                        echo '<a href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin_list[$i] . '/setup.php?w=u" class="button"><i class="fa fa-gear"></i> <span class="show-for-medium">설정</span></a>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
            }//for
            ?>
            <iframe name="hiddenframe" class="sound-only"></iframe>
        </div>
    </div>
</div>
<?php
include_once(G5_PLUGIN_PATH . '/asktheme/_admin/tail.php');
