<?php
/*
 *  슬라이더 위치 및 배경 등록
 *  등록후에 하위 슬라이더 페이지를 등록한다.
 */
include_once './_common.php';
set_session("ask_delete_token", $token = uniqid(time()));
include_once './index.php';
$asktheme_upload_url = G5_DATA_URL . "/asktheme_attach";

if (!defined('_GNUBOARD_')) {
    exit;
}

include_once G5_PLUGIN_PATH . "/asktheme/_admin/head.php";
add_stylesheet('<link rel="stylesheet" href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin['id'] . '/plugin_style.css">', 0);
//수정모드일때
if ($w == 'u' && $idx) {
    $sql = "select * from ask_plugin_cslider_parent where acp_idx = '{$idx}'";
    $data = sql_fetch($sql);
    if (!$data) {
        alert('데이터가 없습니다.', './slider_list.php');
    }
}
?>
<div id="container">
    <div class="row">
        <div class="small-12 medium-12 large-12 columns">
            <div class="panel panel-default">
                <div class="panel-header">
                    <h1><?php echo $plugin['name'], $plugin['version']; ?> 등록하기</h1>
                </div>
                <div class="panel-body">
                    <form class="add_banner" action="./slider_add_update.php"  onsubmit="return form_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" >
                        <?php
                        if ($w == 'u' && $idx) {
                            echo "<input type='hidden' name='w' value='u'>";
                            echo "<input type='hidden' name='acp_idx' value='{$data['acp_idx']}'>";
                        }
                        ?>
                        <input type="hidden" name="pc_id" value="<?php echo $plugin['id'] ?>"/>
                        <input type="hidden" name="pc_name" value="<?php echo $plugin['name'] ?>"/>

                        <div class="responsetable write-table">
                            <div class="tb-body">
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="ab_status">슬라이더 사용여부<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php
                                        if ($data['acp_status'] == '1') {
                                            $acp_use = "checked";
                                        } elseif ($data['acp_status'] == '0') {
                                            $acp_unuse = "checked";
                                        }
                                        ?>
                                        <label><input type="radio" name="acp_status" value="1" <?php echo $acp_use ?> class="slider-start">사용하기</label>
                                        <label><input type="radio" name="acp_status" value="0" <?php echo $acp_unuse ?> class="slider-stop">중지하기</label>
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="acp_area">슬라이더위치<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <input type="text" name="acp_area" value="<?php echo $data['acp_area'] ?>" size="60" class="input" placeholder="메인상단,그룹상단 또는 모바일메인상단, 모바일그룹상단 입력">
                                        <div class="text text-default help">
                                            &middot; 다른 슬라이더와 중복되면 안됩니다.<br/>
                                            &middot; 슬라이더가 출력될 위치명을 입력하세요. 해당 위치에 아래의 코드를 넣으면 됩니다.<br/>
                                            &middot; 동일한 위치명으로 등록된 슬라이더 페이지를 순서대로 출력합니다.<br/>
                                            <?php if ($w == 'u') { ?>
                                                <span class="code">&lt;?php echo plugin_run('<?php echo $data['acp_area'] ?>', '[[parallaxcontentslider]]', false, '<?php echo $data['acp_area'] ?>');?&gt;</span>
                                            <?php } else { ?>
                                                <span class="code">&lt;?php echo plugin_run('슬라이더위치', '[[parallaxcontentslider]]', false, '슬라이더위치');?&gt;</span><br/><br/>
                                                <h4>PC버전은 아래 코드가 미리 출력될 페이지에 입력되어 있음</h4>
                                                <span class="code">&lt;?php echo plugin_run('메인상단', '[[parallaxcontentslider]]', false, '메인상단');?&gt;</span><br/>
                                                <span class="code">&lt;?php echo plugin_run('그룹상단', '[[parallaxcontentslider]]', false, '그룹상단');?&gt;</span>
                                                <br/><br/>
                                                <h4>모바일은 아래 코드가 미리 출력될 페이지에 입력되어 있음</h4>
                                                <span class="code">&lt;?php echo plugin_run('모바일메인상단', '[[parallaxcontentslider]]', false, '모바일메인상단');?&gt;</span><br/>
                                                <span class="code">&lt;?php echo plugin_run('모바일그룹상단', '[[parallaxcontentslider]]', false, '모바일그룹상단');?&gt;</span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="tb-row">
                                    <div class="tb-cell"><label for="">배경선택<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <script>
                                                $(function () {
                                                    setTimeout(function () {
                                                        $('input[name=acp_bg][value="<?php echo $data['acp_bg'] ?>"]').attr('chekced', true).trigger('click');
                                                    }, 300);
                                                    $('input[name=acp_bg][value="<?php echo $data['acp_bg'] ?>"]').attr('chekced', true).trigger('click');
                                                });
                                            </script>
                                        <?php } ?>
                                        <div class="acp_bg">
                                            <label>
                                                <input type="radio" name="acp_bg" value="bg1.png">
                                                <img src='./images/bg1.png' width="100px">
                                            </label>
                                            <label>
                                                <input type="radio" name="acp_bg" value="bg2.png">
                                                <img src='./images/bg2.png' width="100px">
                                            </label>
                                            <label>
                                                <input type="radio" name="acp_bg" value="bg3.png">
                                                <img src='./images/bg3.png' width="100px">
                                            </label>
                                            <label>
                                                <input type="radio" name="acp_bg" value="bg4.png">
                                                <img src='./images/bg4.png' width="100px">
                                            </label>
                                            <div class="text text-default help">배경 : <a href='http://subtlepatterns.com/' target="_blank">추가 배경 얻기</a></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell show-for-medium">

                                    </div>
                                    <div class="tb-cell clearfix">
                                        <div class="button-group float-left">
                                            <button type="submit" class="button submit"><i class="fa fa-check"></i> 확인</button>
                                            <button type="button" class="button alert cancel"><i class="fa fa-ban"></i> 취소</button>
                                        </div>
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <div class="button-group float-right">
                                                <a href='./slider_delete.php?idx=<?php echo $data['acp_idx'] ?>&type=parent&amp;token=<?php echo $token?>' class="button alert delete"><i class="fa fa-trash"></i> 삭제</a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--responsetable-->
                    </form>
                </div>
                <!-- 슬라이더 페이지 목록 -->
                <?php
                if ($w == 'u' && $idx) {
                    ?>
                    <div class="panel-body">
                        <div class="button-group">
                            <a href='./slider_child_add.php?parent_idx=<?php echo $idx ?>' class="button"><i class="fa fa-check"></i> 페이지 등록하기</a>
                        </div>
                        <?php
                        $banner_config = get_plugin_config($plugin['id']);
                        $sql = "select * from ask_plugin_cslider where ac_parent_idx = '{$idx}' order by ac_sort";
                        $result = sql_query($sql);
                        ?>


                        <?php
                        if ($banner_config['pc_use'] == 0) {
                            echo "<div class='alert alert-default'>배너 플러그인이 사용 중지상태입니다. 설정 메뉴에서 변경가능합니다.</div>";
                        }
                        ?>

                        <div class="responsetable tb-even center">
                            <div class="caption">
                                슬라이더 목록
                            </div>
                            <div class="tb-header">
                                <div class="tb-row">
                                    <div class="tb-cell">
                                        제목, 내용, 링크
                                    </div>
                                    <div class="tb-cell">
                                        이미지
                                    </div>
                                    <div class="tb-cell">
                                        상태
                                    </div>
                                    <div class="tb-cell">
                                        관리
                                    </div>
                                </div>
                            </div>
                            <div class="tb-body">
                                <?php for ($i = 0; $rows = sql_fetch_array($result); $i++) { ?>
                                    <div class="tb-row">
                                        <div class="tb-cell left cs-contents">
                                            <?php
                                            echo "<span class='text-subject'>" . $rows['ac_subject'] . "</span><br/>";
                                            echo cut_str($rows['ac_content'], 30, '...');
                                            echo "<br/>";
                                            echo $rows['ac_link'];
                                            ?>
                                        </div>
                                        <div class="tb-cell">
                                            <?php
                                            $imginfo = explode("||", $rows['ac_mime']);
                                            echo "<a href='{$rows['ac_link']}' target='_blank'><img src='{$asktheme_upload_url}/{$rows['ac_image_name']}' class='ac_list_img'></a>";
                                            ?>
                                        </div>
                                        <div class="tb-cell">
                                            <?php
                                            if ($rows['ac_status']) {
                                                echo '<i class="fa fa-toggle-on"></i>';
                                            } else {
                                                echo '<i class="fa fa-toggle-off"></i>';
                                            }
                                            ?>
                                        </div>
                                        <div class="tb-cell">
                                            <div class="button-group nowrap">
                                                <a href="./slider_child_add.php?w=u&idx=<?php echo $rows['ac_idx'] ?>" class="button"><i class="fa fa-pencil"></i></a>
                                                <!-- <a href="./slider_delete.php?idx=<?php echo $rows['ac_idx'] ?>&type=child" class="button danger  button-sm child-delete"><i class="fa fa-trash"></i></a> -->
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if ($i == 0) { ?>
                                    <div class="tb-row-group">
                                        <div class="tb-row">
                                            <div class="tb-cell empty-table">
                                                등록된 슬라이더가 없습니다.
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>


                        <script type="text/javascript">
                            $(function () {
                                $('.child-delete').click(function () {
                                    if (confirm('페이지를 삭제하시겠습니까?')) {
                                        return true;
                                    } else {
                                        return false;
                                    }
                                });
                            });
                        </script>
                    </div>

                <?php } ?>
                <div class="panel-footer">
                    <img src='./images/sample.png' width="100%">
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        $('.cancel').click(function () {
            if (confirm('취소하시겠습니까?')) {
                location.href = history.go(-1);
            } else {
                return false;
            }
        });
        $('.delete').click(function () {
            if (confirm('슬라이더를 삭제하면 하위 페이지가 모두 삭제됩니다. \n\n삭제하시겠습니까?')) {
                return true;
            } else {
                return false;
            }
        });
    });
    function form_submit(f) {
        //console.log(f);
        var use_slider = $('input[name=acp_status]:checked').val();
        if (use_slider === undefined) {
            alert('컨텐츠 슬라이더 사용여부를 선택하세요');
            return false;
        }
        if ($('input[name=acp_area]').val() === '') {
            alert('슬라이더위치를 입력하세요.');
            $('input[name=acp_slider]').css('background-color', '#faff6d');
            return false;
        }

        var use_bg = $('input[name=acp_bg]:checked').val();
        if (use_bg === undefined) {
            alert('배경을 선택하세요.');
            return false;
        }

        return true;
    }
</script>
<?php
include_once G5_PLUGIN_PATH . "/asktheme/_admin/tail.php";

