(function ($) {
    //심플 슬라이더
    $.fn.askSimpleSlider = function (opt) {
        return this.each(function () {
            var $el = $(this);

            var slideCount = $($el).find('ul li').length;
            var slideWidth = $($el).find('ul li').width();
            var slideHeight = $($el).find('ul li').height();
            var sliderUlWidth = slideCount * slideWidth;
            $($el).css({width: slideWidth, height: slideHeight});
            $($el).find('ul').css({width: sliderUlWidth, marginLeft: -slideWidth});
            $($el).find('ul li:last-child').prependTo($($el).find('ul'));

            function moveLeft(element) {
                $(element).find('ul').animate({
                    left: +slideWidth
                }, 200, function () {
                    $(element).find('ul li:last-child').prependTo($(element).find('ul'));
                    $(element).find('ul').css('left', '');
                });
            }

            function moveRight(element) {
                $(element).find('ul').animate({
                    left: -slideWidth
                }, 200, function () {
                    $(element).find('ul li:first-child').appendTo($(element).find('ul'));
                    $(element).find('ul').css('left', '');
                });
            }

            $($el).find('a.control_prev').click(function () {
                moveLeft($el);
            });
            $($el).find('a.control_next').click(function () {
                moveRight($el);
            });
        });
    };
})(jQuery);
(function ($) {
    $.fn.askSlideMenu = function (opt) {
        return this.each(function () {
            var $el = $(this);
            $($el).on('click', function (e) {
                var status = $(this).attr('data-status');
                var targetItem = '.' + $(this).data('target');

                //열려있는건 다 닫는다.
                var openTarget = $('[data-status="open"]').data('target');
                $('[data-status="open"]').attr('data-status', 'close').removeClass('open-slide-icon');
                $("." + openTarget).slideUp('fast');

                if (status === 'open') { //닫기
                    $(this).removeClass('open-slide-icon').attr('data-status', 'close');
                    $(targetItem).slideUp('fast');
                } else {//열기
                    $(this).addClass('open-slide-icon').attr('data-status', 'open');
                    $(targetItem).slideDown('fast');
                }
            });
        });
    };
})(jQuery);


;
(function ($) {

    'use strict';

    $.fn.fitVids = function (options) {
        var settings = {
            customSelector: null,
            ignore: null
        };

        if (!document.getElementById('fit-vids-style')) {
            // appendStyles: https://github.com/toddmotto/fluidvids/blob/master/dist/fluidvids.js
            var head = document.head || document.getElementsByTagName('head')[0];
            var css = '.fluid-width-video-wrapper{width:100%;position:relative;padding:0;}.fluid-width-video-wrapper iframe,.fluid-width-video-wrapper object,.fluid-width-video-wrapper embed {position:absolute;top:0;left:0;width:100%;height:100%;}';
            var div = document.createElement("div");
            div.innerHTML = '<p>x</p><style id="fit-vids-style">' + css + '</style>';
            head.appendChild(div.childNodes[1]);
        }

        if (options) {
            $.extend(settings, options);
        }

        return this.each(function () {
            var selectors = [
                'iframe[src*="player.vimeo.com"]',
                'iframe[src*="youtube.com"]',
                'iframe[src*="youtube-nocookie.com"]',
                'iframe[src*="kickstarter.com"][src*="video.html"]',
                'object',
                'embed'
            ];

            if (settings.customSelector) {
                selectors.push(settings.customSelector);
            }

            var ignoreList = '.fitvidsignore';

            if (settings.ignore) {
                ignoreList = ignoreList + ', ' + settings.ignore;
            }

            var $allVideos = $(this).find(selectors.join(','));
            $allVideos = $allVideos.not('object object'); // SwfObj conflict patch
            $allVideos = $allVideos.not(ignoreList); // Disable FitVids on this video.

            $allVideos.each(function (count) {
                var $this = $(this);
                if ($this.parents(ignoreList).length > 0) {
                    return; // Disable FitVids on this video.
                }
                if (this.tagName.toLowerCase() === 'embed' && $this.parent('object').length || $this.parent('.fluid-width-video-wrapper').length) {
                    return;
                }
                if ((!$this.css('height') && !$this.css('width')) && (isNaN($this.attr('height')) || isNaN($this.attr('width'))))
                {
                    $this.attr('height', 9);
                    $this.attr('width', 16);
                }
                var height = (this.tagName.toLowerCase() === 'object' || ($this.attr('height') && !isNaN(parseInt($this.attr('height'), 10)))) ? parseInt($this.attr('height'), 10) : $this.height(),
                        width = !isNaN(parseInt($this.attr('width'), 10)) ? parseInt($this.attr('width'), 10) : $this.width(),
                        aspectRatio = height / width;
                if (!$this.attr('id')) {
                    var videoID = 'fitvid' + count;
                    $this.attr('id', videoID);
                }
                $this.wrap('<div class="fluid-width-video-wrapper"></div>').parent('.fluid-width-video-wrapper').css('padding-top', (aspectRatio * 100) + '%');
                $this.removeAttr('height').removeAttr('width');
            });
        });
    };
// Works with either jQuery or Zepto
})(window.jQuery || window.Zepto);

(function ($) {

    $.fn.fitText = function (kompressor, options) {

        // Setup options
        var compressor = kompressor || 1,
                settings = $.extend({
                    'minFontSize': Number.NEGATIVE_INFINITY,
                    'maxFontSize': Number.POSITIVE_INFINITY
                }, options);

        return this.each(function () {

            // Store the object
            var $this = $(this);

            // Resizer() resizes items based on the object width divided by the compressor * 10
            var resizer = function () {
                $this.css('font-size', Math.max(Math.min($this.width() / (compressor * 10), parseFloat(settings.maxFontSize)), parseFloat(settings.minFontSize)));
            };

            // Call once to set.
            resizer();

            // Call on resize. Opera debounces their resize by default.
            $(window).on('resize.fittext orientationchange.fittext', resizer);

        });

    };

})(jQuery);

;
(function ($) {

    $.fn.equalize = function (options) {
        var $containers = this, // this is the jQuery object
                children = false,
                reset = false,
                equalize,
                type;

        // when options are an object
        if ($.isPlainObject(options)) {
            equalize = options.equalize || 'height';
            children = options.children || false;
            reset = options.reset || false;
        } else { // otherwise, a string was passed in or default to height
            equalize = options || 'height';
        }

        if (!$.isFunction($.fn[equalize])) {
            return false;
        }

        // determine if the height or width is being equalized
        type = (equalize.indexOf('eight') > 0) ? 'height' : 'width';

        return $containers.each(function () {
            // when children exist, equalize the passed in child elements, otherwise equalize the children
            var $children = (children) ? $(this).find(children) : $(this).children(),
                    max = 0; // reset for each container

            $children.each(function () {
                var $element = $(this),
                        value;
                if (reset) {
                    $element.css(type, '');
                } // remove existing height/width dimension
                value = $element[equalize]();          // call height(), outerHeight(), etc.
                if (value > max) {
                    max = value;
                }      // update max
            });

            $children.css(type, max + 'px'); // add CSS to children
        });
    };

}(jQuery));

/** @preserve
 *
 * slippry v1.3.1 - Responsive content slider for jQuery
 * http://slippry.com
 *
 * Authors: Lukas Jakob Hafner - @saftsaak
 *          Thomas Hurd - @SeenNotHurd
 *
 * Copyright 2015, booncon oy - http://booncon.com
 *
 *
 * Released under the MIT license - http://opensource.org/licenses/MIT
 */

(function ($) {
    "use strict";
    var defaults;

    defaults = {
        // general elements & wrapper
        slippryWrapper: '<div class="sy-box" />', // wrapper to wrap everything, including pager
        slideWrapper: '<div class="sy-slides-wrap" />', // wrapper to wrap sildes & controls
        slideCrop: '<div class="sy-slides-crop" />', //additional wrapper around just the slides
        boxClass: 'sy-list', // class that goes to original element
        elements: 'li', // elments cointaining slide content
        activeClass: 'sy-active', // class for current slide
        fillerClass: 'sy-filler', // class for element that acts as intrinsic placholder
        loadingClass: 'sy-loading',
        // options
        adaptiveHeight: true, // height of the sliders adapts to current slide
        start: 1, // num (starting from 1), random
        loop: true, // first -> last & last -> first arrows
        captionsSrc: 'img', // img, el [img takes caption from alt or title, el from title of slide element]
        captions: 'overlay', // Position: overlay, below, custom, false
        captionsEl: '.sy-caption', // $ selector for captions wrapper
        initSingle: true, // initialise even if there is only one slide
        responsive: true,
        preload: 'visible', // visible, all | resources to wait for until showing slider

        // pager
        pager: true,
        pagerClass: 'sy-pager',
        // controls
        controls: true,
        controlClass: 'sy-controls',
        prevClass: 'sy-prev',
        prevText: 'Previous',
        nextClass: 'sy-next',
        nextText: 'Next',
        hideOnEnd: true,
        // transitions
        transition: 'fade', // fade, horizontal, vertical, kenburns, false
        kenZoom: 120, // max zoom for kenburns (in %)
        slideMargin: 0, // spacing between slides (in %)
        transClass: 'transition', // [Class applied to [element] while a transition is taking place.]
        speed: 800, // time the transition takes (ms)
        easing: 'swing', // easing to use in the animation [(see... [jquery www])]
        continuous: true, // seamless first/ last transistion, only works with loop
        useCSS: true, // true, false -> fallback to js if no browser support

        //slideshow
        auto: true,
        autoDirection: 'next',
        autoHover: true,
        autoHoverDelay: 100,
        autoDelay: 500,
        pause: 4000,
        // callback functions
        onSliderLoad: function () { // when slider loaded
            return this;
        },
        onSlideBefore: function () { // before page transition starts
            return this;
        },
        onSlideAfter: function () {  // after page transition happened
            return this;
        }
    };

    $.fn.slippry = function (options) {
        var slip, el, prepareFiller, getFillerProportions, init, updateCaption, initPager, initControls, ready, transitionDone, whichTransitionEvent,
                initCaptions, updatePager, setFillerProportions, doTransition, updateSlide, openSlide, updateControls, updatePos, supports, preload, start, elFromSel, doKens;

        // reference to the object calling the function
        el = this;

        // if no elements just stop
        if (el.length === 0) {
            return this;
        }
        // support mutltiple elements
        if (el.length > 1) {
            el.each(function () {
                $(this).slippry(options);
            });
            return this;
        }

        // variable to access the slider settings across the plugin
        slip = {};
        slip.vars = {};

        whichTransitionEvent = function () { // Thanks! http://stackoverflow.com/a/18672988
            var t, div, transitions;
            div = document.createElement('div');
            transitions = {
                'WebkitTransition': 'webkitTransitionEnd',
                'MozTransition': 'transitionend',
                'MSTransition': 'msTransitionEnd',
                'OTransition': 'oTransitionEnd',
                'transition': 'transitionEnd transitionend'
            };
            for (t in transitions) {
                if (div.style[t] !== undefined) {
                    return transitions[t];
                }
            }
        };

        supports = (function () {  // Thanks! http://net.tutsplus.com/tutorials/html-css-techniques/quick-tip-detect-css-support-in-browsers-with-javascript/
            var div = document.createElement('div'),
                    vendors = ['Khtml', 'Ms', 'O', 'Moz', 'Webkit'],
                    len = vendors.length;
            return function (prop) {
                if (prop in div.style) {
                    return true;
                }
                prop = prop.replace(/^[a-z]/, function (val) {
                    return val.toUpperCase();
                });
                while (len--) {
                    if (vendors[len] + prop in div.style) {
                        return true;
                    }
                }
                return false;
            };
        }());

        elFromSel = function (sel, prop) {
            var props, newelement, id, className;
            props = prop.split('.');
            newelement = $(sel);
            id = '';
            className = '';
            $.each(props, function (i, val) {
                if (val.indexOf('#') >= 0) {
                    id += val.replace(/^#/, '');
                } else {
                    className += val + ' ';
                }
            });
            if (id.length) {
                newelement.attr('id', id);
            }
            if (className.length) {
                newelement.attr('class', $.trim(className));
            }
            return newelement;
        };

        doKens = function () {
            var kenStart, kenTime, animProp, cssProp;
            animProp = {};
            cssProp = {};
            kenStart = 100 - slip.settings.kenZoom;
            cssProp.width = slip.settings.kenZoom + '%';
            if (slip.vars.active.index() % 2 === 0) {
                cssProp.left = kenStart + '%';
                cssProp.top = kenStart + '%';
                animProp.left = '0%';
                animProp.top = '0%';
            } else {
                cssProp.left = '0%';
                cssProp.top = '0%';
                animProp.left = kenStart + '%';
                animProp.top = kenStart + '%';
            }
            kenTime = slip.settings.pause + slip.settings.speed * 2;
            slip.vars.active.css(cssProp);
            slip.vars.active.animate(animProp, {duration: kenTime, easing: slip.settings.easing, queue: false});
        };

        ready = function () {
            if (slip.vars.fresh) {
                slip.vars.slippryWrapper.removeClass(slip.settings.loadingClass);
                slip.vars.fresh = false;
                if (slip.settings.auto) {
                    el.startAuto();
                }
                if (!slip.settings.useCSS && slip.settings.transition === 'kenburns') {
                    doKens();
                }
                slip.settings.onSliderLoad.call(undefined, slip.vars.active.index());
            } else {
                $('.' + slip.settings.fillerClass, slip.vars.slideWrapper).addClass('ready');
            }
        };

        setFillerProportions = function (width, height) {
            var ratio, p_top, $filler;
            ratio = width / height;
            p_top = 1 / ratio * 100 + '%';  //cool intrinsic trick: http://alistapart.com/article/creating-intrinsic-ratios-for-video
            $filler = $('.' + slip.settings.fillerClass, slip.vars.slideWrapper);
            $filler.css({paddingTop: p_top}); // resizing without the need of js, true responsiveness :)
            ready();
        };

        // gets the aspect ratio of the filler element
        getFillerProportions = function ($slide) {
            var width, height;
            if (($('img', $slide).attr("src") !== undefined)) {
                $("<img />").load(function () {
                    width = $slide.width();
                    height = $slide.height();
                    setFillerProportions(width, height);
                }).attr("src", $('img', $slide).attr("src"));
            } else {
                width = $slide.width();
                height = $slide.height();
                setFillerProportions(width, height);
            }
        };

        // prepares a div to occupy the needed space
        prepareFiller = function () {
            if ($('.' + slip.settings.fillerClass, slip.vars.slideWrapper).length === 0) {
                slip.vars.slideWrapper.append($('<div class="' + slip.settings.fillerClass + '" />'));
            }
            if (slip.settings.adaptiveHeight === true) {  // if the slides shoud alwas adapt to their content
                getFillerProportions($('.' + slip.settings.activeClass, el));  // set the filler height on the active element
            } else {  // otherwise get the highest element
                var $highest, height, loop;
                height = 0;
                loop = 0;
                $(slip.vars.slides).each(function () {
                    if ($(this).height() > height) {
                        $highest = $(this);
                        height = $highest.height();
                    }
                    loop = loop + 1;
                    if (loop === slip.vars.count) {
                        if ($highest === undefined) {
                            $highest = $($(slip.vars.slides)[0]);
                        }
                        getFillerProportions($highest);
                    }
                });
            }
        };

        updatePager = function () {
            if (slip.settings.pager) {
                $('.' + slip.settings.pagerClass + ' li', slip.vars.slippryWrapper).removeClass(slip.settings.activeClass);
                $($('.' + slip.settings.pagerClass + ' li', slip.vars.slippryWrapper)[slip.vars.active.index()]).addClass(slip.settings.activeClass);
            }
        };

        updateControls = function () {
            if (!slip.settings.loop && slip.settings.hideOnEnd) {
                $('.' + slip.settings.prevClass, slip.vars.slippryWrapper)[slip.vars.first ? 'hide' : 'show']();
                $('.' + slip.settings.nextClass, slip.vars.slippryWrapper)[slip.vars.last ? 'hide' : 'show']();
            }
        };

        updateCaption = function () {
            var caption, wrapper;
            if (slip.settings.captions !== false) {
                if (slip.settings.captionsSrc !== 'img') {
                    caption = slip.vars.active.attr('title');
                } else {
                    caption = $('img', slip.vars.active).attr('title') !== undefined ? $('img', slip.vars.active).attr('title') : $('img', slip.vars.active).attr('alt');
                }
                if (slip.settings.captions !== 'custom') {
                    wrapper = $(slip.settings.captionsEl, slip.vars.slippryWrapper);
                } else {
                    wrapper = $(slip.settings.captionsEl);
                }
                if ((caption !== undefined) && (caption !== '')) {
                    wrapper.html(caption).show();
                } else {
                    wrapper.hide();
                }
            }
        };

        el.startAuto = function () {
            if ((slip.vars.timer === undefined) && (slip.vars.delay === undefined)) {
                slip.vars.delay = window.setTimeout(function () {
                    slip.vars.autodelay = false;
                    slip.vars.timer = window.setInterval(function () {
                        slip.vars.trigger = 'auto';
                        openSlide(slip.settings.autoDirection);
                    }, slip.settings.pause);
                }, slip.vars.autodelay ? slip.settings.autoHoverDelay : slip.settings.autoDelay);
                if (slip.settings.autoHover) {
                    slip.vars.slideWrapper.unbind('mouseenter').unbind('mouseleave').bind('mouseenter', function () {
                        if (slip.vars.timer !== undefined) {
                            slip.vars.hoverStop = true;
                            el.stopAuto();
                        } else {
                            slip.vars.hoverStop = false;
                        }
                    }).bind('mouseleave', function () {
                        if (slip.vars.hoverStop) {
                            slip.vars.autodelay = true;
                            el.startAuto();
                        }
                    });
                }
            }
        };

        el.stopAuto = function () {
            window.clearInterval(slip.vars.timer);
            slip.vars.timer = undefined;
            window.clearTimeout(slip.vars.delay);
            slip.vars.delay = undefined;
        };

        // refreshes the already initialised slider
        el.refresh = function () {
            slip.vars.slides.removeClass(slip.settings.activeClass);
            slip.vars.active.addClass(slip.settings.activeClass);
            if (slip.settings.responsive) {
                prepareFiller();
            } else {
                ready();
            }
            updateControls();
            updatePager();
            updateCaption();
        };

        updateSlide = function () {
            el.refresh();
        };

        transitionDone = function () {
            slip.vars.moving = false;
            slip.vars.active.removeClass(slip.settings.transClass);
            if (!slip.vars.fresh) {
                slip.vars.old.removeClass('sy-ken');
            }
            slip.vars.old.removeClass(slip.settings.transClass);
            slip.settings.onSlideAfter.call(undefined, slip.vars.active, slip.vars.old.index(), slip.vars.active.index());
            if (slip.settings.auto) {
                if (!slip.vars.hoverStop || slip.vars.hoverStop === undefined) {
                    el.startAuto();
                }
            }
        };

        doTransition = function () {
            var pos, jump, old_left, old_pos, kenTime, ref, cssProp;
            slip.settings.onSlideBefore.call(undefined, slip.vars.active, slip.vars.old.index(), slip.vars.active.index());
            if (slip.settings.transition !== false) {
                slip.vars.moving = true;
                if ((slip.settings.transition === 'fade') || (slip.settings.transition === 'kenburns')) {
                    if (slip.vars.fresh) {
                        if (slip.settings.useCSS) {
                            slip.vars.slides.css({transitionDuration: slip.settings.speed + 'ms', opacity: 0});
                        } else {
                            slip.vars.slides.css({opacity: 0});
                        }
                        slip.vars.active.css('opacity', 1);
                        if (slip.settings.transition === 'kenburns') {
                            if (slip.settings.useCSS) {
                                kenTime = slip.settings.pause + slip.settings.speed * 2;
                                slip.vars.slides.css({animationDuration: kenTime + 'ms'});
                                slip.vars.active.addClass('sy-ken');
                            }
                        }
                        transitionDone();
                    } else {
                        if (slip.settings.useCSS) {
                            slip.vars.old.addClass(slip.settings.transClass).css('opacity', 0);
                            slip.vars.active.addClass(slip.settings.transClass).css('opacity', 1);
                            if (slip.settings.transition === 'kenburns') {
                                slip.vars.active.addClass('sy-ken');
                            }
                            $(window).off('focus').on('focus', function () { // bugfix for safari 7 which doesn't always trigger ontransitionend when switching tab
                                if (slip.vars.moving) {
                                    slip.vars.old.trigger(slip.vars.transition);
                                }
                            });
                            slip.vars.old.one(slip.vars.transition, function () {
                                transitionDone();
                                return this;
                            });
                        } else {
                            if (slip.settings.transition === 'kenburns') {
                                doKens();
                            }
                            slip.vars.old.addClass(slip.settings.transClass).animate({
                                opacity: 0
                            }, slip.settings.speed, slip.settings.easing, function () {
                                transitionDone();
                            });
                            slip.vars.active.addClass(slip.settings.transClass).css('opacity', 0).animate({
                                opacity: 1
                            }, slip.settings.speed, slip.settings.easing);
                        }
                    }
                    updateSlide();
                } else if ((slip.settings.transition === 'horizontal') || (slip.settings.transition === 'vertical')) {
                    ref = (slip.settings.transition === 'horizontal') ? 'left' : 'top';
                    pos = '-' + slip.vars.active.index() * (100 + slip.settings.slideMargin) + '%';
                    if (slip.vars.fresh) {
                        el.css(ref, pos);
                        transitionDone();
                    } else {
                        cssProp = {};
                        if (slip.settings.continuous) {
                            if (slip.vars.jump && ((slip.vars.trigger === 'controls') || (slip.vars.trigger === 'auto'))) {
                                jump = true;
                                old_pos = pos;
                                if (slip.vars.first) {
                                    old_left = 0;
                                    slip.vars.active.css(ref, slip.vars.count * (100 + slip.settings.slideMargin) + '%');
                                    pos = '-' + slip.vars.count * (100 + slip.settings.slideMargin) + '%';
                                } else {
                                    old_left = (slip.vars.count - 1) * (100 + slip.settings.slideMargin) + '%';
                                    slip.vars.active.css(ref, -(100 + slip.settings.slideMargin) + '%');
                                    pos = (100 + slip.settings.slideMargin) + '%';
                                }
                            }
                        }
                        slip.vars.active.addClass(slip.settings.transClass);
                        if (slip.settings.useCSS) {
                            cssProp[ref] = pos;
                            cssProp.transitionDuration = slip.settings.speed + 'ms';
                            el.addClass(slip.settings.transition);
                            el.css(cssProp);
                            $(window).off('focus').on('focus', function () { // bugfix for safari 7 which doesn't always trigger ontransitionend when switching tab
                                if (slip.vars.moving) {
                                    el.trigger(slip.vars.transition);
                                }
                            });
                            el.one(slip.vars.transition, function () {
                                el.removeClass(slip.settings.transition);
                                if (jump) {
                                    slip.vars.active.css(ref, old_left);
                                    cssProp[ref] = old_pos;
                                    cssProp.transitionDuration = '0ms';
                                    el.css(cssProp);
                                }
                                transitionDone();
                                return this;
                            });
                        } else {
                            cssProp[ref] = pos;
                            el.stop().animate(cssProp, slip.settings.speed, slip.settings.easing, function () {
                                if (jump) {
                                    slip.vars.active.css(ref, old_left);
                                    el.css(ref, old_pos);
                                }
                                transitionDone();
                                return this;
                            });
                        }
                    }
                    updateSlide();
                }
            } else {
                updateSlide();
                transitionDone();
            }
        };

        updatePos = function (slide) {
            slip.vars.first = slip.vars.last = false;
            if ((slide === 'prev') || (slide === 0)) {
                slip.vars.first = true;
            } else if ((slide === 'next') || (slide === slip.vars.count - 1)) {
                slip.vars.last = true;
            }
        };

        openSlide = function (slide) {
            var current, direction;
            if (!slip.vars.moving) {
                if (slip.vars.trigger !== 'auto') {
                    el.stopAuto();
                }
                current = slip.vars.active.index();
                if (slide === 'prev') {
                    direction = slide;
                    if (current > 0) {
                        slide = current - 1;
                    } else if (slip.settings.loop) {
                        slide = slip.vars.count - 1;
                    }
                } else if (slide === 'next') {
                    direction = slide;
                    if (current < slip.vars.count - 1) {
                        slide = current + 1;
                    } else if (slip.settings.loop) {
                        slide = 0;
                    }
                } else {
                    slide = slide - 1;
                    direction = slide < current ? 'prev' : 'next';
                }
                slip.vars.jump = false;
                if ((slide !== 'prev') && (slide !== 'next') && ((slide !== current) || (slip.vars.fresh))) {
                    updatePos(slide);
                    slip.vars.old = slip.vars.active;
                    slip.vars.active = $(slip.vars.slides[slide]);
                    if (((current === 0) && (direction === 'prev')) || ((current === slip.vars.count - 1) && (direction === 'next'))) {
                        slip.vars.jump = true;
                    }
                    doTransition();
                }
            }
        };

        el.goToSlide = function (slide) {
            slip.vars.trigger = 'external';
            openSlide(slide);
        };

        el.goToNextSlide = function () {
            slip.vars.trigger = 'external';
            openSlide('next');
        };

        el.goToPrevSlide = function () {
            slip.vars.trigger = 'external';
            openSlide('prev');
        };

        initPager = function () {
            if ((slip.settings.pager) && (slip.vars.count > 1)) {
                var count, loop, pager;
                count = slip.vars.slides.length;
                pager = $('<ul class="' + slip.settings.pagerClass + '" />');
                for (loop = 1; loop < count + 1; loop = loop + 1) {
                    pager.append($('<li />').append($('<a href="#' + loop + '">' + loop + '</a>')));
                }
                slip.vars.slippryWrapper.append(pager);
                $('.' + slip.settings.pagerClass + ' a', slip.vars.slippryWrapper).click(function () {
                    slip.vars.trigger = 'pager';
                    openSlide(parseInt(this.hash.split('#')[1], 10));
                    return false;
                });
                updatePager();
            }
        };

        initControls = function () {
            if ((slip.settings.controls) && (slip.vars.count > 1)) {
                slip.vars.slideWrapper.append(
                        $('<ul class="' + slip.settings.controlClass + '" />')
                        .append('<li class="' + slip.settings.prevClass + '"><a href="#prev">' + slip.settings.prevText + '</a></li>')
                        .append('<li class="' + slip.settings.nextClass + '"><a href="#next">' + slip.settings.nextText + '</a></li>')
                        );
                $('.' + slip.settings.controlClass + ' a', slip.vars.slippryWrapper).click(function () {
                    slip.vars.trigger = 'controls';
                    openSlide(this.hash.split('#')[1]);
                    return false;
                });
                updateControls();
            }
        };

        initCaptions = function () {
            if (slip.settings.captions !== false) {
                if (slip.settings.captions === 'overlay') {
                    slip.vars.slideWrapper.append($('<div class="sy-caption-wrap" />').html(elFromSel('<div />', slip.settings.captionsEl)));
                } else if (slip.settings.captions === 'below') {
                    slip.vars.slippryWrapper.append($('<div class="sy-caption-wrap" />').html(elFromSel('<div />', slip.settings.captionsEl)));
                }
            }
        };

        // actually show the first slide
        start = function () {
            openSlide(slip.vars.active.index() + 1);
        };

        // wait for images, iframes to be loaded
        preload = function (slides) {
            var count, loop, elements, container;
            container = (slip.settings.preload === 'all') ? slides : slip.vars.active;
            elements = $('img, iframe', container);
            count = elements.length;
            if (count === 0) {
                start();
                return;
            }
            loop = 0;
            elements.each(function () {
                $(this).one('load error', function () {
                    if (++loop === count) {
                        start();
                    }
                }).each(function () {
                    if (this.complete) {
                        $(this).load();
                    }
                });
            });
        };

        el.getCurrentSlide = function () {
            return slip.vars.active;
        };

        el.getSlideCount = function () {
            return slip.vars.count;
        };

        el.destroySlider = function () {
            if (slip.vars.fresh === false) {
                el.stopAuto();
                slip.vars.moving = false;
                slip.vars.slides.each(function () {
                    if ($(this).data("sy-cssBckup") !== undefined) {
                        $(this).attr("style", $(this).data("sy-cssBckup"));
                    } else {
                        $(this).removeAttr('style');
                    }
                    if ($(this).data("sy-classBckup") !== undefined) {
                        $(this).attr("class", $(this).data("sy-classBckup"));
                    } else {
                        $(this).removeAttr('class');
                    }
                });
                if (el.data("sy-cssBckup") !== undefined) {
                    el.attr("style", el.data("sy-cssBckup"));
                } else {
                    el.removeAttr('style');
                }
                if (el.data("sy-classBckup") !== undefined) {
                    el.attr("class", el.data("sy-classBckup"));
                } else {
                    el.removeAttr('class');
                }
                slip.vars.slippryWrapper.before(el);
                slip.vars.slippryWrapper.remove();
                slip.vars.fresh = undefined;
            }
        };

        el.reloadSlider = function () {
            el.destroySlider();
            init();
        };

        // initialises the slider, creates needed markup
        init = function () {
            var first;
            slip.settings = $.extend({}, defaults, options);
            slip.vars.slides = $(slip.settings.elements, el);
            slip.vars.count = slip.vars.slides.length;
            if (slip.settings.useCSS) { // deactivate css transitions on unsupported browsers
                if (!supports('transition')) {
                    slip.settings.useCSS = false;
                }
                slip.vars.transition = whichTransitionEvent();
            }
            el.data('sy-cssBckup', el.attr('style'));
            el.data('sy-classBackup', el.attr('class'));
            el.addClass(slip.settings.boxClass).wrap(slip.settings.slippryWrapper).wrap(slip.settings.slideWrapper).wrap(slip.settings.slideCrop);
            slip.vars.slideWrapper = el.parent().parent();
            slip.vars.slippryWrapper = slip.vars.slideWrapper.parent().addClass(slip.settings.loadingClass);
            slip.vars.fresh = true;
            slip.vars.slides.each(function () {
                $(this).addClass('sy-slide ' + slip.settings.transition);
                if (slip.settings.useCSS) {
                    $(this).addClass('useCSS');
                }
                if (slip.settings.transition === 'horizontal') {
                    $(this).css('left', $(this).index() * (100 + slip.settings.slideMargin) + '%');
                } else if (slip.settings.transition === 'vertical') {
                    $(this).css('top', $(this).index() * (100 + slip.settings.slideMargin) + '%');
                }
            });
            if ((slip.vars.count > 1) || (slip.settings.initSingle)) {
                if ($('.' + slip.settings.activeClass, el).index() === -1) {
                    if (slip.settings.start === 'random') {
                        first = Math.round(Math.random() * (slip.vars.count - 1));
                    } else if (slip.settings.start > 0 && slip.settings.start <= slip.vars.count) {
                        first = slip.settings.start - 1;
                    } else {
                        first = 0;
                    }
                    slip.vars.active = $(slip.vars.slides[first]).addClass(slip.settings.activeClass);
                } else {
                    slip.vars.active = $('.' + slip.settings.activeClass, el);
                }
                initControls();
                initPager();
                initCaptions();
                preload(slip.vars.slides);
            } else {
                return this;
            }
        };

        init(); // on startup initialise the slider

        return this;
    };
}(jQuery));

function get_ie_version() {

    var word;
    var version = "N/A";

    var agent = navigator.userAgent.toLowerCase();
    var name = navigator.appName;

    // IE old version ( IE 10 or Lower ) 
    if (name == "Microsoft Internet Explorer")
        word = "msie ";

    else {
        // IE 11 
        if (agent.search("trident") > -1)
            word = "trident/.*rv:";

        // Microsoft Edge  
        else if (agent.search("edge/") > -1)
            word = "edge/";
    }

    var reg = new RegExp(word + "([0-9]{1,})(\\.{0,}[0-9]{0,1})");

    if (reg.exec(agent) != null)
        version = RegExp.$1 + RegExp.$2;

    return version;
}


/*!
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <jevin9@gmail.com> wrote this file. As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return. Jevin O. Sewaruth
 * ----------------------------------------------------------------------------
 *
 * Autogrow Textarea Plugin Version v3.0
 * http://www.technoreply.com/autogrow-textarea-plugin-3-0
 * 
 * THIS PLUGIN IS DELIVERD ON A PAY WHAT YOU WHANT BASIS. IF THE PLUGIN WAS USEFUL TO YOU, PLEASE CONSIDER BUYING THE PLUGIN HERE :
 * https://sites.fastspring.com/technoreply/instant/autogrowtextareaplugin
 *
 * Date: October 15, 2012
 */

jQuery.fn.autoGrow = function (options) {
    return this.each(function () {
        var settings = jQuery.extend({
            extraLine: true,
        }, options);

        var createMirror = function (textarea) {
            jQuery(textarea).after('<div class="autogrow-textarea-mirror"></div>');
            return jQuery(textarea).next('.autogrow-textarea-mirror')[0];
        }

        var sendContentToMirror = function (textarea) {
            mirror.innerHTML = String(textarea.value)
                    .replace(/&/g, '&amp;')
                    .replace(/"/g, '&quot;')
                    .replace(/'/g, '&#39;')
                    .replace(/</g, '&lt;')
                    .replace(/>/g, '&gt;')
                    .replace(/ /g, '&nbsp;')
                    .replace(/\n/g, '<br />') +
                    (settings.extraLine ? '.<br/>.' : '')
                    ;

            if (jQuery(textarea).height() != jQuery(mirror).height())
                jQuery(textarea).height(jQuery(mirror).height());
        }

        var growTextarea = function () {
            sendContentToMirror(this);
        }

        // Create a mirror
        var mirror = createMirror(this);

        // Style the mirror
        mirror.style.display = 'none';
        mirror.style.wordWrap = 'break-word';
        mirror.style.whiteSpace = 'normal';
        mirror.style.padding = jQuery(this).css('paddingTop') + ' ' +
                jQuery(this).css('paddingRight') + ' ' +
                jQuery(this).css('paddingBottom') + ' ' +
                jQuery(this).css('paddingLeft');

        mirror.style.width = jQuery(this).css('width');
        mirror.style.fontFamily = jQuery(this).css('font-family');
        mirror.style.fontSize = jQuery(this).css('font-size');
        mirror.style.lineHeight = jQuery(this).css('line-height');

        // Style the textarea
        this.style.overflow = "hidden";
        this.style.minHeight = this.rows + "em";

        // Bind the textarea's event
        this.onkeyup = growTextarea;

        // Fire the event for text already present
        sendContentToMirror(this);

    });
};

$(function () {
    $('textarea').autoGrow();


    $('.ask-slide-menu').askSlideMenu(); //슬라이드 메뉴
    //브라우저 디바이스 체크
    var is_mobile = false;
    $.browser.device = (/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(navigator.userAgent.toLowerCase()));
    if ($.browser.device) {
        is_mobile = true;
    }

    //모바일 슬라이드 하위메뉴
    $('.ask-submenu').toggle(function () {
        $(this).children('i').addClass('rotate');
        $(this).siblings('.dropdown').slideDown();
    }, function () {
        $(this).children('i').removeClass('rotate');
        $(this).siblings('.dropdown').slideUp();
    });

    //jQuery Media query
    $(window).resize(function () {
        /*
         //모바일 슬라이드메뉴 페이지 리사이즈시 초기화 -- 문제있음. 모바일 키보드 나타날때 동작함.
         $('.ask-mobile-menu, .search-box').slideUp('fast');
         $('.open-mobile-menu, .open-search, .open-mobile-search').data('status', 'close');
         
         setTimeout(function () {
         $('.open-mobile-menu').removeClass('rotate');
         }, 500);
         */
        if ($('#wrapper').width() >= 800) {

        }
        if ($('#wrapper').width() < 960) {

        }
        if ($('#wrapper').width() < 640) {

        }
        if ($('#wrapper').width() < 1100) {

        }
    });

    //Header Fixed. 모바일은 고정하지 않는다.
    //if (is_mobile === false) {
    $(window).scroll(function () {
        var height = $(document).scrollTop();
        if ($(window).scrollTop() > 100) {
            $("#header").before($("#header").addClass("animateIt"));
            $("body").toggleClass("down", ($(window).scrollTop() > 87));
        } else if ($(window).scrollTop() === 0) {
            $("#header").before($("#header").removeClass("animateIt"));
            $("body").removeClass('down');
        }
    });
    //}

    //부드럽게 스크롩
    $('#gotop').click(function () {
        $('html,body').animate({
            scrollTop: 0
        },
                'slow');
        return false;
    });
    //scroll top
    $(window).scroll(function () {
        if ($(window).scrollTop() > 100) {
            $('#gotop').fadeIn("slow", function () {
                $(this).css({
                    "top": $(window).height() - 100 + 'px'
                });
            });
        } else {
            $('#gotop').fadeOut("slow");
        }
    });
});

/* jFeed : jQuery feed parser plugin
 * Copyright (C) 2007 Jean-François Hovinne - http://www.hovinne.com/
 * Dual licensed under the MIT (MIT-license.txt)
 * and GPL (GPL-license.txt) licenses.
 */

jQuery.getFeed = function (options) {

    options = jQuery.extend({
        url: null,
        data: null,
        cache: true,
        success: null,
        failure: null,
        error: null,
        global: true

    }, options);

    if (options.url) {

        if (jQuery.isFunction(options.failure) && jQuery.type(options.error) === 'null') {
            // Handle legacy failure option
            options.error = function (xhr, msg, e) {
                options.failure(msg, e);
            }
        } else if (jQuery.type(options.failure) === jQuery.type(options.error) === 'null') {
            // Default error behavior if failure & error both unspecified
            options.error = function (xhr, msg, e) {
                window.console && console.log('getFeed failed to load feed', xhr, msg, e);
            }
        }

        return $.ajax({
            type: 'GET',
            url: options.url,
            data: options.data,
            cache: options.cache,
            dataType: (jQuery.browser.msie) ? "text" : "xml",
            success: function (xml) {
                var feed = new JFeed(xml);
                if (jQuery.isFunction(options.success))
                    options.success(feed);
            },
            error: options.error,
            global: options.global
        });
    }
};

function JFeed(xml) {
    if (xml)
        this.parse(xml);
}
;

JFeed.prototype = {
    type: '',
    version: '',
    title: '',
    link: '',
    description: '',
    parse: function (xml) {

        if (jQuery.browser.msie) {
            var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
            xmlDoc.loadXML(xml);
            xml = xmlDoc;
        }

        if (jQuery('channel', xml).length == 1) {

            this.type = 'rss';
            var feedClass = new JRss(xml);

        } else if (jQuery('feed', xml).length == 1) {

            this.type = 'atom';
            var feedClass = new JAtom(xml);
        }

        if (feedClass)
            jQuery.extend(this, feedClass);
    }
};

function JRss(xml) {
    this._parse(xml);
}
;

JRss.prototype = {
    _parse: function (xml) {

        if (jQuery('rss', xml).length == 0)
            this.version = '1.0';
        else
            this.version = jQuery('rss', xml).eq(0).attr('version');

        var channel = jQuery('channel', xml).eq(0);

        this.title = jQuery(channel).find('title:first').text();
        this.link = jQuery(channel).find('link:first').text();
        this.description = jQuery(channel).find('description:first').text();
        this.language = jQuery(channel).find('language:first').text();
        this.updated = jQuery(channel).find('lastBuildDate:first').text();

        this.items = new Array();

        var feed = this;

        jQuery('item', xml).each(function () {

            var item = new JFeedItem();

            item.title = jQuery(this).find('title').eq(0).text();
            item.link = jQuery(this).find('link').eq(0).text();
            item.description = jQuery(this).find('description').eq(0).text();
            item.updated = jQuery(this).find('pubDate').eq(0).text();
            item.id = jQuery(this).find('guid').eq(0).text();

            feed.items.push(item);
        });
    }
};
function JFeedItem() {}
;

JFeedItem.prototype = {
    title: '',
    link: '',
    description: '',
    updated: '',
    id: ''
};
function JAtom(xml) {
    this._parse(xml);
}
;

JAtom.prototype = {
    _parse: function (xml) {

        var channel = jQuery('feed', xml).eq(0);

        this.version = '1.0';
        this.title = jQuery(channel).find('title:first').text();
        this.link = jQuery(channel).find('link:first').attr('href');
        this.description = jQuery(channel).find('subtitle:first').text();
        this.language = jQuery(channel).attr('xml:lang');
        this.updated = jQuery(channel).find('updated:first').text();

        this.items = new Array();

        var feed = this;

        jQuery('entry', xml).each(function () {

            var item = new JFeedItem();

            item.title = jQuery(this).find('title').eq(0).text();
            item.link = jQuery(this).find('link').eq(0).attr('href');
            item.description = jQuery(this).find('content').eq(0).text();
            item.updated = jQuery(this).find('updated').eq(0).text();
            item.id = jQuery(this).find('id').eq(0).text();

            feed.items.push(item);
        });
    }
};
//anchor smooth scroll
$(function () {
    $('a[href*="#"]:not([href="#"])').click(function () {
        if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
            var target = $(this.hash);
            target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
            if (target.length) {
                $('html, body').animate({
                    scrollTop: target.offset().top
                }, 1000);
                return false;
            }
        }
    });
});

//mobile slide menu
jQuery(document).ready(function ($) {
    //open navigation clicking the menu icon
    $('.open-mobile-menu').on('click', function (event) {
        $('.ask-mobile-menu').show();
        event.preventDefault();
        toggleNav(true);
    });
    //close the navigation
    $('.cd-close-nav, .cd-overlay').on('click', function (event) {
        event.preventDefault();
        toggleNav(false);
    });
    /*
    //select a new section
    $('.cd-nav li').on('click', function (event) {
        event.preventDefault();
        var target = $(this),
                //detect which section user has chosen
                sectionTarget = target.data('menu');
        if (!target.hasClass('cd-selected')) {
            //if user has selected a section different from the one alredy visible
            //update the navigation -> assign the .cd-selected class to the selected item
            target.addClass('cd-selected').siblings('.cd-selected').removeClass('cd-selected');
            //load the new section
            //loadNewContent(sectionTarget);
        } else {
            // otherwise close navigation
            toggleNav(false);
        }
    });
*/
    function toggleNav(bool) {
        $('.cd-nav-container, .cd-overlay').toggleClass('is-visible', bool);
        $('main').toggleClass('scale-down', bool);
    }

    function loadNewContent(newSection) {
        //create a new section element and insert it into the DOM
        var section = $('<section class="cd-section ' + newSection + '"></section>').appendTo($('main'));
        //load the new content from the proper html file
        section.load(newSection + '.html .cd-section > *', function (event) {
            //add the .cd-selected to the new section element -> it will cover the old one
            section.addClass('cd-selected').on('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
                //close navigation
                toggleNav(false);
            });
            section.prev('.cd-selected').removeClass('cd-selected');
        });

        $('main').on('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
            //once the navigation is closed, remove the old section from the DOM
            section.prev('.cd-section').remove();
        });

        if ($('.no-csstransitions').length > 0) {
            //if browser doesn't support transitions - don't wait but close navigation and remove old item
            toggleNav(false);
            section.prev('.cd-section').remove();
        }
    }
});