<?php
if (!defined('_GNUBOARD_')) {
    exit;
}
/*
 * ASKTHEME - Foundation 
 * 모바일용 스와이프 갤러리
 * 썸네일 반응형.
 * 
 */
$ask_img = array('width' => 300, 'height' => 225);

add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/mobile/asktheme.latest_swipe_gallery.css">', 0);
?>
<div class="latest-swipe-gallery-wrap">
    <div class="latest-header">
        <h3 class="latest-title">
            <a href="<?php echo G5_BBS_URL ?>/board.php?bo_table=<?php echo $bo_table ?>"><?php echo $bo_subject; ?></a>
        </h3>
    </div>
    <div class="latest-body">
        <div class="swiper-container <?php echo $bo_table ?>">
            <div class="swiper-wrapper">
                <?php
                for ($i = 0; $i < count($list); $i++) {
                    $thumb['small'] = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $ask_img['width'], $ask_img['height']);
                    $thumb['medium'] = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $ask_img['width'] * 2, $ask_img['height'] * 2);
                    $thumb['large'] = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $ask_img['width'] * 3, $ask_img['height'] * 3);
                    ?>
                    <div class='swiper-slide' data-hash="<?php echo $bo_table . '_' . $i ?>">
                        <?php
                        echo "<div class='gallery-photo'><a href='{$list[$i]['href']}' class='img-link'>";
                        echo "<div class='webzine-icons'>";
                        if (isset($list[$i]['icon_new'])) {
                            if ($list[$i]['icon_new']) {
                                echo '<i class="textcon textcon-new">N</i> ';
                            }
                        }
                        if (isset($list[$i]['icon_hot'])) {
                            if ($list[$i]['icon_hot']) {
                                echo '<i class="textcon textcon-hot">Hot</i> ';
                            }
                        }
                        if (isset($list[$i]['icon_file'])) {
                            if ($list[$i]['icon_file']) {
                                echo '<i class="textcon textcon-file">F</i> ';
                            }
                        }
                        if (isset($list[$i]['icon_link'])) {
                            if ($list[$i]['icon_link']) {
                                echo '<i class="textcon textcon-link">L</i> ';
                            }
                        }
                        if (isset($list[$i]['icon_secret'])) {
                            if ($list[$i]['icon_secret']) {
                                echo '<i class="textcon textcon-new"><i class="fa fa-unlock-alt" aria-hidden="true"></i></i> ';
                            }
                        }
                        if ($list[$i]['is_notice']) {
                            echo '<i class="textcon textcon-notice">Notice</i> ';
                        }
                        if ($list[$i]['comment_cnt']) {
                            echo "<i class='textcon textcon-default'>" . $list[$i]['comment_cnt'] . "</i>";
                        }
                        echo "</div>";
                        if ($thumb) {
                            echo "<img data-interchange='[{$thumb['small']['src']}, small], [{$thumb['medium']['src']}, medium], [{$thumb['large']['src']}, large]' class='swiper-lazy'>";
                            echo '<div class="swiper-lazy-preloader"></div>';
                        } else {
                            echo "<img src='{$latest_skin_url}/img/noimage.png'>";
                        }
                        echo "</a></div>";
                        echo "<a href='{$list[$i]['href']}' class='latest-link'>";
                        echo $list[$i]['subject'];
                        echo "</a>";

                        // if ($list[$i]['link']['count']) { echo "[{$list[$i]['link']['count']}]"; }
                        // if ($list[$i]['file']['count']) { echo "<{$list[$i]['file']['count']}>"; }
                        ?>
                    </div>
                <?php } ?>
                <?php if (count($list) == 0) { //게시물이 없을 때   ?>
                    <div class='center'>게시물이 없습니다.</div>
                <?php } ?>
            </div>
            <!-- Add Arrows
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            -->
        </div>
    </div>
    <div class="latest-footer">
        <!-- Add Pagination -->
        <div class="swiper-pagination <?php echo $bo_table ?>"></div>
    </div>
</div>

<!-- Initialize Swiper -->
<script>
    $(function () {
        var swiper_<?php echo $bo_table ?> = new Swiper('.swiper-container.<?php echo $bo_table ?>', {
            pagination: '.swiper-pagination.<?php echo $bo_table ?>',
            //autoplay: 2500,
            paginationClickable: true,
            /*paginationBulletRender: function (index, className) {
             return '<span class="' + className + '">' + (index + 1) + '</span>';
             },*/
            //nextButton: '.swiper-button-next',
            //prevButton: '.swiper-button-prev',
            spaceBetween: 10,
            centeredSlides: true,
            //autoplay: 2500,
            //autoplayDisableOnInteraction: false,
            hashnav: false,
            lazyLoading: true,
            preloadImages: false,
            observer: true,
            observeParents: true
        });
        /*
         // Later add callback
         swiper_<?php echo $bo_table ?>.on('slideChangeStart', function () {
         console.log('slide change start');
         });
         // Add one more handler for this event
         swiper_<?php echo $bo_table ?>.on('slideChangeStart', function () {
         console.log('slide change start 2');
         });
         // Add handler that will be executed only once
         swiper_<?php echo $bo_table ?>.once('sliderMove', function () {
         console.log('slider moved');
         });
         */
        $('.tab-header li a').click(function (e) {
            e.preventDefault();
            swiper_<?php echo $bo_table ?>.update();
        });
    });
</script>