<?php
/*
 * ASKTHEME Time Line형 리스트 게시판.
 * 
 */
if (!defined('_GNUBOARD_')) {
    exit;
} // 개별 페이지 접근 불가
// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) {
    $colspan++;
}
if ($is_good) {
    $colspan++;
}
if ($is_nogood) {
    $colspan++;
}
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/asktheme.board_timeline.css">', 0);
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/slider.css">', 0);

include_once(G5_LIB_PATH . '/thumbnail.lib.php');
?>
<script type="text/javascript">
    $(function () {
        //전체 체크
        $('#chkall').click(function () {
            var target = $(this);
            if (target.attr('checked') == 'checked') {
                $('input[name="chk_wr_id[]"]').attr("checked", true);
            } else {
                $('input[name="chk_wr_id[]"]').attr("checked", false);
            }
        });
    });

</script>
<!-- 게시판 목록 시작 { -->
<div class="page-wrap board-basic-list" style="width:<?php echo $width; ?>">
    <div class="page-title">
        <h1><?php echo $board['bo_subject'] ?><span class="sound-only"> 목록</span></h1>
        <?php if ($rss_href || $write_href) { ?>
            <ul class="bo-menu">
                <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01"><i class="fa fa-rss"></i></a></li><?php } ?>
                <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin"><i class="fa fa-cog"></i></a></li><?php } ?>
                <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02"><i class="fa fa-pencil"></i> 글쓰기</a></li><?php } ?>
            </ul>
        <?php } ?>
    </div>
    <div class="bo-header">
        <?php if ($is_category) { ?>
            <nav class="bo-cate">
                <h2 class="sound-only"><?php echo $board['bo_subject'] ?> 카테고리</h2>
                <ul class="bo-cate-list">
                    <?php echo $category_option ?>
                </ul>
            </nav>
        <?php } ?>
        <div class="bo-info">
            <?php if ($is_checkbox) { ?>
                <label for="chkall" class="sound-only">현재 페이지 게시물 전체</label>
                <input type="checkbox" id="chkall">
            <?php } ?>
            <span>Total <?php echo number_format($total_count) ?>건</span>
            <?php echo $page ?> 페이지
        </div>
    </div><!--.bo-header -->

    <?php
    //게시위치, 플러그인태그, 텍스트리턴, 변수전달
    echo plugin_run('게시판목록상단', '[[banner]]', false, '게시판목록상단');
    ?>

    <form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
        <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
        <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
        <input type="hidden" name="stx" value="<?php echo $stx ?>">
        <input type="hidden" name="spt" value="<?php echo $spt ?>">
        <input type="hidden" name="sca" value="<?php echo $sca ?>">
        <input type="hidden" name="sst" value="<?php echo $sst ?>">
        <input type="hidden" name="sod" value="<?php echo $sod ?>">
        <input type="hidden" name="page" value="<?php echo $page ?>">
        <input type="hidden" name="sw" value="">
        <section id="cd-timeline" class="cd-container">
            <?php
            for ($i = 0; $i < count($list); $i++) {
                $notice_class = "";
                if ($list[$i]['is_notice']) {
                    $notice_class = "bo_notice";
                }
                $list[$i]['name'] = no_popup($list[$i]['name']);
                ?>
                <div class="cd-timeline-block">
                    <div class="cd-timeline-img cd-picture">
                        <?php
                        if ($list[$i]['is_notice']) { // 공지사항
                            echo '<strong>공지</strong>';
                        } else if ($wr_id == $list[$i]['wr_id']) {
                            echo "<i class='fa fa-book'></i>";
                        } else {
                            echo $list[$i]['num'];
                        }
                        ?>
                    </div>

                    <div class="cd-timeline-content">
                        <h2>
                            <?php if ($is_checkbox) { ?>
                                <label for="chk_wr_id_<?php echo $i ?>" class="sound-only"><?php echo $list[$i]['subject'] ?></label>
                                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
                            <?php } ?>
                            <?php
                            echo $list[$i]['icon_reply'];
                            if ($is_category && $list[$i]['ca_name']) {
                                ?>
                                <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="category-link"><?php echo $list[$i]['ca_name'] ?></a>
                            <?php } ?>
                            <a href="<?php echo $list[$i]['href'] ?>" class="subject-link">
                                <?php echo $list[$i]['subject'] ?>
                                <?php if ($list[$i]['comment_cnt']) { ?><span class="sound-only">댓글</span><span class='comment_count'><?php echo $list[$i]['comment_cnt']; ?></span><span class="sound-only">개</span><?php } ?>
                            </a>
                            <?php
                            // if ($list[$i]['link']['count']) { echo '['.$list[$i]['link']['count']}.']'; }
                            // if ($list[$i]['file']['count']) { echo '<'.$list[$i]['file']['count'].'>'; }
                            if (isset($list[$i]['icon_new'])) {
                                if ($list[$i]['icon_new']) {
                                    echo '<i class="textcon textcon-new">New</i> ';
                                }
                            }
                            if (isset($list[$i]['icon_hot'])) {
                                if ($list[$i]['icon_hot']) {
                                    echo '<i class="textcon textcon-hot">Hot</i> ';
                                }
                            }
                            if (isset($list[$i]['icon_file'])) {
                                if ($list[$i]['icon_file']) {
                                    echo '<i class="textcon textcon-file">File</i> ';
                                }
                            }
                            if (isset($list[$i]['icon_link'])) {
                                if ($list[$i]['icon_link']) {
                                    echo '<i class="textcon textcon-link">Link</i> ';
                                }
                            }
                            if (isset($list[$i]['icon_secret'])) {
                                if ($list[$i]['icon_secret']) {
                                    echo '<i class="textcon textcon-new"><i class="fa fa-unlock-alt" aria-hidden="true"></i></i> ';
                                }
                            }
                            if ($list[$i]['is_notice']) {
                                echo '<i class="textcon textcon-notice">Notice</i> ';
                            }
                            ?>
                        </h2>
                        <?php
                        //첨부 5개, 에디터 삽입 5개의 이미지를 썸네일로 가져오게 됨. 썸네일 슬라이드용.
                        $thumb = ask_list_thumbnail($board['bo_table'], $list[$i]['wr_id'], $board['bo_gallery_width'], $board['bo_gallery_height']);
                        if ($thumb) {
                            $thumb_count = count($thumb);
                            if ($thumb_count > 1) {
                                $img_content = "<div class='thumb-slider'>";
                                $img_content .= "<ul>";
                                for ($a = 0; count($thumb) > $a; $a++) {
                                    $img_content .= "<li><a href='{$list[$i]['href']}' class='img-link'>";
                                    $img_content .= "<img src='{$thumb[$a]['src']}' alt='{$thumb[$a]['alt']}' width='100%'>";
                                    $img_content .= "</a></li>";
                                }
                                $img_content .= "</ul></div>";
                            } else {
                                $img_content = "<a href='{$list[$i]['href']}' class='img-link'>";
                                $img_content .= "<img src='{$thumb['0']['src']}' alt='{$thumb['0']['alt']}' width='100%'>";
                                $img_content .= "</a>";
                            }
                        }
                        if ($thumb) {
                            ?>
                            <div class="list-image">
                                <div class='image-wrap'>
                                    <?php
                                    echo $img_content;
                                    ?>
                                </div>
                            </div><!-- .list-image -->
                        <?php } ?>
                        <p>
                            <?php echo cut_str(strip_tags($list[$i]['content']), 120) ?>
                        </p>
                        <i class="fa fa-user" aria-hidden="true"></i> <?php echo $list[$i]['name'] ?>
                        <i class="fa fa-book" aria-hidden="true"></i> <?php echo $list[$i]['wr_hit'] ?>
                        <?php if ($is_good) { ?> <i class="fa fa-thumbs-o-up"></i> <?php echo $list[$i]['wr_good'] ?><?php } ?>
                        <?php if ($is_nogood) { ?> <i class="fa fa-thumbs-o-down"></i> <?php echo $list[$i]['wr_nogood'] ?><?php } ?>
                        <span class="cd-date"> <i class="fa fa-clock-o" aria-hidden="true"></i> <?php echo $list[$i]['datetime2'] ?></span>
                    </div> 
                </div>
            <?php } ?>

            <?php if (count($list) == 0) { ?>
                <div class="cd-timeline-block">
                    <div class="cd-timeline-img cd-picture">
                        0
                    </div>

                    <div class="cd-timeline-content">
                        <h2>게시물이 없습니다.</h2>
                    </div>
                </div>
            <?php } ?>
        </section>
        <div class="button-container list-buttons">
            <?php if ($list_href || $is_checkbox || $write_href) { ?>
                <div class="list-footer row">
                    <div class="small-8 columns">
                        <?php if ($is_checkbox) { ?>
                            <div class="button-group">
                                <script type="text/javascript">
                                    $(function () {
                                        $('.sel-delete').click(function () {
                                            $('.submit-delete').trigger('click');
                                        });
                                        $('.sel-copy').click(function () {
                                            $('.submit-copy').trigger('click');
                                        });
                                        $('.sel-move').click(function () {
                                            $('.submit-move').trigger('click');
                                        });
                                    });
                                </script>

                                <input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed = this.value" class="submit-delete hide">
                                <input type="submit" name="btn_submit" value="선택복사" onclick="document.pressed = this.value" class="submit-copy hide">
                                <input type="submit" name="btn_submit" value="선택이동" onclick="document.pressed = this.value" class="submit-move hide">

                                <a href="#delete" class="button alert sel-delete"><i class="fa fa-trash"></i> <span class="show-for-large">선택삭제</span></a>
                                <a href="#copy" class="button sel-copy"><i class="fa fa-file-o"></i> <span class="show-for-large">선택복사</span></a>
                                <a href="#move" class="button sel-move"><i class="fa fa-scissors"></i> <span class="show-for-large">선택이동</span></a>
                            </div>
                        <?php } ?>
                    </div>

                    <?php if ($list_href || $write_href) { ?>
                        <div class="small-4 columns">
                            <div class="button-group right">
                                <?php if ($list_href) { ?><a href="<?php echo $list_href ?>" class="button"><i class="fa fa-list-ol"></i> 목록 </a><?php } ?>
                                <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="button"><i class="fa fa-pencil-square-o"></i> 글쓰기 </a><?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </form>

    <?php if ($is_checkbox) { ?>
        <noscript>
        <p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
        </noscript>
    <?php } ?>

    <div class="paging-wrap">
        <?php echo $write_pages; ?>
    </div>

    <div class="search-wrap">
        <form name="fsearch" method="get">
            <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
            <input type="hidden" name="sca" value="<?php echo $sca ?>">
            <input type="hidden" name="sop" value="and">
            <label for="sfl" class="sound-only">검색대상</label>
            <div class="row">
                <div class="small-12 medium-3 large-3 columns">
                    <select name="sfl" id="sfl">
                        <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
                        <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
                        <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
                        <option value="mb_id,1"<?php echo get_selected($sfl, 'mb_id,1'); ?>>회원아이디</option>
                        <option value="mb_id,0"<?php echo get_selected($sfl, 'mb_id,0'); ?>>회원아이디(코)</option>
                        <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
                        <option value="wr_name,0"<?php echo get_selected($sfl, 'wr_name,0'); ?>>글쓴이(코)</option>
                    </select>
                </div>
                <div class="small-12 medium-9 large-9 columns">
                    <label for="stx" class="sound-only">검색어<strong class="sound-only"> 필수</strong></label>
                    <div class="input-group">
                        <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="required input-group-field" size="15" maxlength="20" placeholder="검색어 입력..">
                        <div class="input-group-button">
                            <button type="submit" class="button"><span class='show-for-large'>검색</span><span class='hide-for-large'><i class="fa fa-search"></i></span></button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <?php
//게시위치, 플러그인태그, 텍스트리턴, 변수전달
    echo plugin_run('게시판목록하단', '[[banner]]', false, '게시판목록하단');
    ?>

    <?php if ($is_checkbox) { ?>
        <script type="text/javascript">
            function all_checked(sw) {
                var f = document.fboardlist;

                for (var i = 0; i < f.length; i++) {
                    if (f.elements[i].name == "chk_wr_id[]")
                        f.elements[i].checked = sw;
                }
            }

            function fboardlist_submit(f) {
                var chk_count = 0;

                for (var i = 0; i < f.length; i++) {
                    if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
                        chk_count++;
                }

                if (!chk_count) {
                    alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
                    return false;
                }

                if (document.pressed == "선택복사") {
                    select_copy("copy");
                    return;
                }

                if (document.pressed == "선택이동") {
                    select_copy("move");
                    return;
                }

                if (document.pressed == "선택삭제") {
                    if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
                        return false;

                    f.removeAttribute("target");
                    f.action = "./board_list_update.php";
                }

                return true;
            }

            // 선택한 게시물 복사 및 이동
            function select_copy(sw) {
                var f = document.fboardlist;

                if (sw == "copy")
                    str = "복사";
                else
                    str = "이동";

                var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

                f.sw.value = sw;
                f.target = "move";
                f.action = "./move.php";
                f.submit();
            }
        </script>
    <?php } ?>
    <!-- } 게시판 목록 끝 -->

</div><!--.board-wrap-->


<script type="text/javascript">
    $(function () {
        $('.thumb-slider').slippry({
            auto: false,
            transition: 'horizontal',
            speed: 800
        });
        //ie9,10 에서 슬라이드 로딩 안될경우 대비.
        var ieVersion = parseInt(get_ie_version());
        if (ieVersion === 10 || ieVersion === 9) {
            setTimeout(function () {
                $('.thumb-slider').slippry({
                    auto: false,
                    transition: 'horizontal',
                    speed: 800
                });
            }, 100);
        }
    });
    jQuery(document).ready(function ($) {
        var timelineBlocks = $('.cd-timeline-block'),
                offset = 0.8;

        //hide timeline blocks which are outside the viewport
        hideBlocks(timelineBlocks, offset);

        //on scolling, show/animate timeline blocks when enter the viewport
        $(window).on('scroll', function () {
            (!window.requestAnimationFrame)
                    ? setTimeout(function () {
                        showBlocks(timelineBlocks, offset);
                    }, 100)
                    : window.requestAnimationFrame(function () {
                        showBlocks(timelineBlocks, offset);
                    });
        });

        function hideBlocks(blocks, offset) {
            blocks.each(function () {
                ($(this).offset().top > $(window).scrollTop() + $(window).height() * offset) && $(this).find('.cd-timeline-img, .cd-timeline-content').addClass('is-hidden');
            });
        }

        function showBlocks(blocks, offset) {
            blocks.each(function () {
                ($(this).offset().top <= $(window).scrollTop() + $(window).height() * offset && $(this).find('.cd-timeline-img').hasClass('is-hidden')) && $(this).find('.cd-timeline-img, .cd-timeline-content').removeClass('is-hidden').addClass('bounce-in');
            });
        }
    });
</script>