<?php
/*
 * ASKTHEME Time Line형 리스트 게시판.
 * 
 */
if (!defined("_GNUBOARD_")) {
    exit;
} // 개별 페이지 접근 불가
include_once(G5_LIB_PATH . '/thumbnail.lib.php');

add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/asktheme.board.css">', 0);
if ($category_name) {
    $category = '[' . $view['ca_name'] . ']';
} // 분류 출력 끝
$subject = cut_str(get_text($view['wr_subject']), 70); // 글제목 출력
?>
<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>
<div class="page-wrap">
    <!-- 게시물 읽기 시작 { -->
    <div class="page-title"><h1><?php echo $board['bo_subject'] . " - " . $category . $subject; ?> </h1></div>
    <article class="view-contents" style="width:<?php echo $width; ?>">
        <header class="view-info">
            <h2 class="sound-only">페이지 정보</h2>
            <ul>
                <li>
                    <i class="fa fa-user"></i> <?php echo no_popup($view['name']) ?>
                </li>
                <?php
                if ($is_ip_view) {
                    echo "<li>";
                    echo "<i class='fa fa-globe'></i> {$ip}";
                    echo "</li>";
                }
                ?>
                <li>
                    <i class="fa fa-calendar"></i> <span class="sound-only">작성일</span><?php echo date("y-m-d H:i", strtotime($view['wr_datetime'])) ?>
                </li>
                <li>
                    <i class="fa fa-book"></i> <span class="mobi-hide">조회</span>  <?php echo number_format($view['wr_hit']) ?><span class="mobi-hide">회</span>
                </li>
                <li>
                    <i class="fa fa-comment"></i> <span class="mobi-hide">댓글</span>  <?php echo number_format($view['wr_comment']) ?><span class="mobi-hide">건</span>
                </li>
            </ul>            
        </header>

        <?php
        ob_start();
        ?>
        <div class="button-container view-button">
            <div class="button-group float-left">
                <?php if ($search_href) { ?><a href="<?php echo $search_href ?>" class="button"><i class="fa fa-search"></i> <span class="show-for-medium">검색</span></a><?php } ?>
                <a href="<?php echo $list_href ?>" class="button"><i class="fa fa-list-ol"></i> <span class="show-for-medium">목록</span></a>
                <?php if ($prev_href || $next_href) { ?>

                    <?php if ($prev_href) { ?><a href="<?php echo $prev_href ?>" class="button"><i class="fa fa-arrow-left"></i> <span class="show-for-medium">이전글</span></a><?php } ?>
                    <?php if ($next_href) { ?><a href="<?php echo $next_href ?>" class="button"><i class="fa fa-arrow-right"></i> <span class="show-for-medium">다음글</span></a><?php } ?>

                <?php } ?>


                <?php if ($update_href) { ?><a href="<?php echo $update_href ?>" class="button"><i class="fa fa-pencil"></i> <span class="show-for-medium">수정</span></a><?php } ?>
                <?php if ($delete_href) { ?><a href="<?php echo $delete_href ?>" class="button alert danger" onclick="del(this.href); return false;"><i class="fa fa-trash"></i> <span class="show-for-medium">삭제</span></a><?php } ?>


                <?php if ($copy_href) { ?><a href="<?php echo $copy_href ?>" class="button danger" onclick="board_move(this.href); return false;"><i class="fa fa-files-o"></i> <span class="show-for-medium">복사</span></a><?php } ?>
                <?php if ($move_href) { ?><a href="<?php echo $move_href ?>" class="button danger" onclick="board_move(this.href); return false;"><i class="fa fa-scissors"></i> <span class="show-for-medium">이동</span></a><?php } ?>
            </div>
            <div class="button-group float-right">
                <?php if ($reply_href) { ?><a href="<?php echo $reply_href ?>" class="button"><i class="fa fa-reply"></i> <span class="show-for-medium">답변</span></a><?php } ?>
                <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="button primary"><i class="fa fa-pencil-square-o"></i> <span class="show-for-medium">글쓰기</span></a><?php } ?>
            </div>
        </div>
        <?php
        $link_buttons = ob_get_contents();
        ob_end_flush();
        ?>
        <?php
        echo plugin_run('게시판내용상단', '[[banner]]', false, '게시판내용상단');
        ?>
        <?php
        if ($view['file']['count']) {
            $cnt = 0;
            for ($i = 0; $i < count($view['file']); $i++) {
                if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) {
                    $cnt++;
                }
            }
        }
        ?>

        <?php if ($cnt) { ?>
            <!-- 첨부파일 시작 { -->
            <section class="view-files">
                <h2 class="sound-only">첨부파일</h2>
                <ul>
                    <?php
                    // 가변 파일
                    for ($i = 0; $i < count($view['file']); $i++) {
                        if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) {
                            ?>
                            <li>
                                <a href="<?php echo $view['file'][$i]['href']; ?>" class="view_file_download">
                                    <i class="fa fa-files-o"></i>
                                    <?php echo $view['file'][$i]['source'] ?>
                                    <?php echo $view['file'][$i]['content'] ?> (<?php echo $view['file'][$i]['size'] ?>)
                                </a>
                                <span class="file-info"><?php echo $view['file'][$i]['download'] ?>회 다운로드</span>
                                <span class="file-info">DATE : <?php echo $view['file'][$i]['datetime'] ?></span>
                            </li>
                            <?php
                        }
                    }
                    ?>
                </ul>
            </section>
            <!-- } 첨부파일 끝 -->
        <?php } ?>

        <?php
        if ($view['link'][0] || $view['link'][1]) {
            ?>
            <!-- 관련링크 시작 { -->
            <section class="view-links">
                <h2 class="sound-only">관련링크</h2>
                <ul>
                    <?php
                    // 링크
                    $cnt = 0;
                    for ($i = 1; $i <= count($view['link']); $i++) {
                        if ($view['link'][$i]) {
                            $cnt++;
                            $link = cut_str($view['link'][$i], 70);
                            ?>
                            <li>
                                <a href="<?php echo $view['link_href'][$i] ?>" target="_blank">
                                    <i class="fa fa-link"></i>
                                    <?php echo cut_str($link, 51); ?>
                                </a>
                                <span class="link-info"><?php echo $view['link_hit'][$i] ?>회 연결</span>
                            </li>
                            <?php
                        }
                    }
                    ?>
                </ul>
            </section>
            <!-- } 관련링크 끝 -->
        <?php } ?>

        <section class="view-content-wrap">
            <h2 class="sound-only">본문</h2>

            <?php
            // 파일 출력
            $v_img_count = count($view['file']);
            if ($v_img_count) {
                echo "<div class='view-images'>\n";

                for ($i = 0; $i <= count($view['file']); $i++) {
                    if ($view['file'][$i]['view']) {
                        //Tag 생성 
                        $img_contents = "<img src='{$view['file'][$i]['path']}/{$view['file'][$i]['file']}'>";

                        echo ask_view_thumbnail($view['file'][$i]['view']);
                    }
                }

                echo "</div>\n";
            }
            ?>

            <!-- 본문 내용 시작 { -->
            <div class="view-contents-box">
                <?php echo ask_view_thumbnail($view['content']); ?>
            </div>
            <?php //echo $view['rich_content']; // {이미지:0} 과 같은 코드를 사용할 경우   ?>
            <!-- } 본문 내용 끝 -->

            <?php if ($is_signature) { ?><div class="view-sign"><?php echo $signature ?></div><?php } ?>

            <!-- 스크랩 추천 비추천 시작 { -->
            <?php if ($scrap_href || $good_href || $nogood_href) { ?>
                <div class="board-actions">
                    <?php if ($scrap_href) { ?>
                    <a href="<?php echo $scrap_href; ?>" class="button secondary" onclick="window.name = 'win_scrap'"><i class="fa fa-bookmark"></i> <span class="show-for-medium">스크랩</span> </a>
                    <?php } ?>
                    <?php if ($good_href) { ?>
                        <a href="<?php echo $good_href . '&amp;' . $qstr ?>" id="good_button" class="button secondary"><i class="fa fa-thumbs-o-up"></i> <span class="show-for-medium">추천</span> <?php echo number_format($view['wr_good']) ?></a>
                        <b id="bo_v_act_good"></b>
                    <?php } ?>
                    <?php if ($nogood_href) { ?>
                        <a href="<?php echo $nogood_href . '&amp;' . $qstr ?>" id="nogood_button" class="button secondary"><i class="fa fa-thumbs-o-down"></i> <span class="show-for-medium">비추천</span>  <?php echo number_format($view['wr_nogood']) ?></a>
                        <b id="bo_v_act_nogood"></b>

                    <?php } ?>
                </div>
                <?php
            } else {
                if ($board['bo_use_good'] || $board['bo_use_nogood']) {
                    ?>
                    <div class="view-good center">
                        <?php if ($board['bo_use_good']) { ?><span class="button secondary disabled "><i class="fa fa-thumbs-o-up"></i> <span class="show-for-medium"> 추천 </span><strong><?php echo number_format($view['wr_good']) ?></strong></span><?php } ?>
                        <?php if ($board['bo_use_nogood']) { ?><span class="button secondary disabled "><i class="fa fa-thumbs-o-down"></i><span class="show-for-medium"> 비추천 </span> <?php echo number_format($view['wr_nogood']) ?></strong></span><?php } ?>
                    </div>
                    <?php
                }
            }
            ?>
            <!-- } 스크랩 추천 비추천 끝 -->
            <?php
            //배너 플러그인 태그,배너ID,텍스트리턴여부
            echo plugin_run('게시판내용하단', '[[banner]]', false, '게시판내용하단');
            ?>
        </section>

        <?php
        include_once(G5_SNS_PATH . "/view.sns.skin.php");
        ?>

        <?php
// 코멘트 입출력
        include_once(G5_BBS_PATH . '/view_comment.php');
        ?>

        <!-- 링크 버튼 시작 { -->
        <div class="bottom-button">
            <?php echo $link_buttons ?>
        </div>
        <!-- } 링크 버튼 끝 -->

    </article>
    <!-- } 게시판 읽기 끝 -->

    <script type="text/javascript">
<?php
echo plugin_run('메타태그', '[[metatag]]', false, 'script');
?>
<?php if ($board['bo_download_point'] < 0) { ?>
            $(function () {
                $("a.view_file_download").click(function () {
                    if (!g5_is_member) {
                        alert("다운로드 권한이 없습니다.\n회원이시라면 로그인 후 이용해 보십시오.");
                        return false;
                    }

                    var msg = "파일을 다운로드 하시면 포인트가 차감(<?php echo number_format($board['bo_download_point']) ?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?";

                    if (confirm(msg)) {
                        var href = $(this).attr("href") + "&js=on";
                        $(this).attr("href", href);

                        return true;
                    } else {
                        return false;
                    }
                });
            });
<?php } ?>

        function board_move(href)
        {
            window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
        }
    </script>

    <script type="text/javascript">
        $(function () {
            $(".view-contents-box").fitVids(); //responsive video

            $("a.view_image").click(function () {
                window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
                return false;
            });

            // 추천, 비추천
            $("#good_button, #nogood_button").click(function () {
                var $tx;
                if (this.id == "good_button")
                    $tx = $("#bo_v_act_good");
                else
                    $tx = $("#bo_v_act_nogood");

                excute_good(this.href, $(this), $tx);
                return false;
            });

            // 이미지 리사이즈
            $("#bo_v_atc").viewimageresize();
        });

        function excute_good(href, $el, $tx)
        {
            $.post(
                    href,
                    {js: "on"},
                    function (data) {
                        if (data.error) {
                            alert(data.error);
                            return false;
                        }

                        if (data.count) {
                            $el.find("strong").text(number_format(String(data.count)));
                            if ($tx.attr("id").search("nogood") > -1) {
                                $tx.text("이 글을 비추천하셨습니다.");
                                $tx.fadeIn(200).delay(2500).fadeOut(200);
                            } else {
                                $tx.text("이 글을 추천하셨습니다.");
                                $tx.fadeIn(200).delay(2500).fadeOut(200);
                            }
                        }
                    }, "json"
                    );
        }
    </script>
    <!-- } 게시글 읽기 끝 -->
</div>
<hr>