<?php
if (!defined('_GNUBOARD_')) {
    exit;
} // 개별 페이지 접근 불가
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/asktheme.member.css">', 0);

//배열 페이징
if (G5_IS_MOBILE) {
    $rows = $config['cf_mobile_pages'];
} else {
    $rows = $config['cf_write_pages'];
}
if ($page < 1) {
    $page = 1;
} // 페이지가 없으면 첫 페이지 (1 페이지)
$total_page = ceil(count($list) / $rows);  // 전체 페이지 계산
$from_record = ($page - 1) * $rows; // 시작 열을 구함
$write_pages = get_paging($rows, $page, $total_page, './memo.php?kind=' . $kind . $qstr . '&amp;page=');
$list = array_slice($list, $from_record, $rows);

include G5_THEME_PATH . "/head.php";
?>

<!-- 쪽지 목록 시작 { -->
<div class='page-wrap memo-page'>
    <div class='page-title'>
        <h1><?php echo $g5['title'] ?></h1>
    </div>
    <p class="help-text">
        쪽지 보관일수는 최장 <strong><?php echo $config['cf_memo_del'] ?></strong>일 입니다.
    </p>
    <?php
    if (!$kind || $kind == 'recv') {
        $active_recv = "active";
    } else {
        $active_send = "active";
    }
    ?>
    <div class='tab-wrap'>
        <ul class="tabs tab-header" id='tabs'>
            <li class='<?php echo $active_recv ?>'><a href="./memo.php?kind=recv">받은쪽지</a></li>
            <li class='<?php echo $active_send ?>'><a href="./memo.php?kind=send">보낸쪽지</a></li>
            <li class='<?php echo $active_form ?>'><a href="./memo_form.php">쪽지쓰기</a></li>
        </ul>
        <div class='tab-contents'>
            <div class='responsetable tb-even'>
                <div class='caption'>
                    전체 <?php echo $kind_title ?>쪽지 <?php echo $total_count ?>통
                </div>
                <div class='tb-header'>
                    <div class='tb-row'>
                        <div class='tb-cell'><?php echo ($kind == "recv") ? "보낸사람" : "받는사람"; ?></div>
                        <div class='tb-cell'>보낸시간</div>
                        <div class='tb-cell'>읽은시간</div>
                        <div class='tb-cell'>관리</div>
                    </div>
                </div>
                <div class='tb-body'>
                    <?php for ($i = 0; $i < count($list); $i++) { ?>
                        <div class='tb-row'>
                            <div class='tb-cell'><i class="fa fa-user"></i> <?php echo no_popup($list[$i]['name']) ?></div>
                            <div class='tb-cell'><a href="<?php echo $list[$i]['view_href'] ?>"><?php echo $list[$i]['send_datetime'] ?></a></div>
                            <div class='tb-cell'><a href="<?php echo $list[$i]['view_href'] ?>"><?php echo $list[$i]['read_datetime'] ?></a></div>
                            <div class='tb-cell'><a href="<?php echo $list[$i]['del_href'] ?>" onclick="del(this.href); return false;" class="button danger"><i class="fa fa-trash"></i></a></div>
                        </div>
                    <?php } ?>
                    <?php
                    if ($i == 0) {
                        echo "<div class='tb-row'><div class='tb-cell'>자료가 없습니다.</div></div>";
                    }
                    ?>
                </div>
            </div>
        </div>
    </div><!--.tab-wrap -->

    <div class="paging-wrap">
        <?php echo $write_pages ?>
    </div>
</div>
<!-- } 쪽지 목록 끝 -->
<?php
include G5_THEME_PATH . "/tail.php";
