<?php
/*
 * qa list skin
 */
if (!defined('_GNUBOARD_')) {
    exit;
} // 개별 페이지 접근 불가
// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 6;

if ($is_checkbox) {
    $colspan++;
}

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/asktheme.qa.css">', 0);
?>
<div class="page-wrap qna">
    <div class="page-title">
        <h1>1:1 문의</h1>
    </div>
    <div class="bo-header">
        <?php if ($category_option) { ?>
            <!-- 카테고리 시작 { -->
            <nav aria-label="You are here:" role="navigation">
                <h2 class="sound-only"><?php echo $qaconfig['qa_title'] ?> 카테고리</h2>
                <ul class="breadcrumbs">
                    <?php echo $category_option ?>
                </ul>
            </nav>
            <!-- } 카테고리 끝 -->
        <?php } ?>
    </div>
    <hr>
    <div id="bo_list">
        <!-- 게시판 페이지 정보 및 버튼 시작 { -->
        <div class="button-container">
            <?php if ($admin_href || $write_href) { ?>
                <div class="button-group">
                    <?php if ($admin_href) { ?><a href="<?php echo $admin_href ?>" class="button"><i class="fa fa-cog"></i> 관리자</a><?php } ?>
                    <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="button primary"><i class="fa fa-pencil-square-o"></i> 문의등록</a><?php } ?>
                </div>
            <?php } ?>
        </div>
        <!-- } 게시판 페이지 정보 및 버튼 끝 -->

        <form name="fqalist" id="fqalist" action="./qadelete.php" onsubmit="return fqalist_submit(this);" method="post">
            <input type="hidden" name="stx" value="<?php echo $stx; ?>">
            <input type="hidden" name="sca" value="<?php echo $sca; ?>">
            <input type="hidden" name="page" value="<?php echo $page; ?>">

            <div class="responsetable tb-even qna-table">
                <div class="caption">
                    Total <?php echo number_format($total_count) ?>건 <?php echo $page ?> 페이지
                </div>
                <div class="tb-header">
                    <div class='tb-row'>
                        <div class='tb-cell'>번호</div>
                        <?php if ($is_checkbox) { ?>
                            <div class='tb-cell'>
                                <label for="chkall" class="sound_only">현재 페이지 게시물 전체</label>
                                <input type="checkbox" id="chkall" onclick="if (this.checked)
                                            all_checked(true);
                                        elseall_checked(false);">
                            </div>
                        <?php } ?>
                        <div class='tb-cell'>분류</div>
                        <div class='tb-cell'>제목</div>
                        <div class='tb-cell show-for-medium'>글쓴이</div>
                        <div class='tb-cell show-for-medium'>상태</div>
                        <div class='tb-cell show-for-medium'>등록일</div>
                    </div>
                </div>
                <div class="tb-body">
                    <?php
                    for ($i = 0; $i < count($list); $i++) {
                        ?>
                        <div class='tb-row'>
                            <div class="tb-cell"><?php echo $list[$i]['num']; ?></div>
                            <?php if ($is_checkbox) { ?>
                                <div class="tb-cell">
                                    <label for="chk_qa_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject']; ?></label>
                                    <input type="checkbox" name="chk_qa_id[]" value="<?php echo $list[$i]['qa_id'] ?>" id="chk_qa_id_<?php echo $i ?>">
                                </div>
                            <?php } ?>
                            <div class="tb-cell"><?php echo $list[$i]['category']; ?></div>
                            <div class="tb-cell wr-subject list-subejct">
                                <a href="<?php echo $list[$i]['view_href']; ?>">
                                    <?php echo cut_str($list[$i]['subject'], 39); ?>
                                </a>
                                <?php echo $list[$i]['icon_file']; ?>

                                <!-- mobile -->
                                <ul class="hide-for-medium breadcrumbs mobile-wrinfo">
                                    <li class="info-writer"><i class="fa fa-user"></i> <?php echo $list[$i]['name'] ?></li>
                                    <li <?php echo ($list[$i]['qa_status'] ? 'txt_done' : 'txt_rdy'); ?>"><?php echo ($list[$i]['qa_status'] ? '<span class="reply-ok">답변완료</span>' : '<span class="reply-wait">답변대기</span>'); ?></li>
                                    <li class="info-date"><i class="fa fa-calendar"></i> <?php echo $list[$i]['date'] ?></li>
                                </ul>

                            </div>
                            <div class="tb-cell show-for-medium"><?php echo $list[$i]['name']; ?></div>
                            <div class="tb-cell show-for-medium" <?php echo ($list[$i]['qa_status'] ? 'txt_done' : 'txt_rdy'); ?>"><?php echo ($list[$i]['qa_status'] ? '<span class="reply-ok">답변완료</span>' : '<span class="reply-wait">답변대기</span>'); ?></div>
                            <div class="tb-cell show-for-medium"><?php echo $list[$i]['date']; ?></div>
                        </div>
                        <?php
                    }
                    ?>

                    <?php
                    if ($i == 0) {
                        echo "<div class='tb-row-group'><div class='tb-row'><div class='tb-cell'>게시물이 없습니다.</div></div></div>";
                    }
                    ?>
                </div>
            </div>

            <div class="button-container">
                <?php if ($is_checkbox) { ?>
                    <div class="button-group float-left">
                        <script type="text/javascript">
                            $(function () {
                                $('.sel-delete').click(function () {
                                    $('.submit-delete').trigger('click');
                                });

                            });
                        </script>

                        <a href="#delete" class="button sel-delete"><i class="fa fa-trash"></i> <span class="show-for-medium">선택삭제</span></a>
                        <input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed = this.value" class="submit-delete hide">
                    </div>
                <?php } ?>

                <div class="button-group float-right">
                    <?php if ($list_href) { ?><a href="<?php echo $list_href ?>" class="button"><i class="fa fa-list-ol"></i> <span class="show-for-medium">목록</span></a><?php } ?>
                    <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="button primary"><i class="fa fa-pencil-square-o"></i> <span class="show-for-medium">문의등록</span></a><?php } ?>
                </div>
            </div>
        </form>
    </div>

    <?php if ($is_checkbox) { ?>
        <noscript>
        <p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
        </noscript>
    <?php } ?>

    <div class="paging-wrap">
        <?php echo $list_pages; ?>
    </div>

    <!-- 게시판 검색 시작 { -->
    <div class="search-wrap">
        <legend class="sound-only">게시물 검색</legend>
        <form name="fsearch" method="get">
            <input type="hidden" name="sca" value="<?php echo $sca ?>">
            <div class='row'>
                <div class="small-12 medium-8 large-6 medium-centered large-centered">
                    <div class="input-group">
                        <label for="stx" class="sound-only">검색어<strong class="sound-only"> 필수</strong></label>
                        <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" id="stx" required  class="required nput-group-field" size="15" maxlength="15" placeholder="검색어 입력">
                        <div class="input-group-button">
                            <button type="submit" class="button"><i class="fa fa-search"></i> 검색</button>
                        </div>                
                    </div>  
                </div>
            </div>
        </form>
    </div>
    <!-- } 게시판 검색 끝 -->

    <?php if ($is_checkbox) { ?>
        <script>
            function all_checked(sw) {
                var f = document.fqalist;

                for (var i = 0; i < f.length; i++) {
                    if (f.elements[i].name == "chk_qa_id[]")
                        f.elements[i].checked = sw;
                }
            }

            function fqalist_submit(f) {
                var chk_count = 0;

                for (var i = 0; i < f.length; i++) {
                    if (f.elements[i].name == "chk_qa_id[]" && f.elements[i].checked)
                        chk_count++;
                }

                if (!chk_count) {
                    alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
                    return false;
                }

                if (document.pressed == "선택삭제") {
                    if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다"))
                        return false;
                }

                return true;
            }
        </script>
    <?php } ?>
</div>