<?php
/*
 *  배너 등록
 */
include_once './_common.php';
include_once './index.php';
$asktheme_upload_url = G5_DATA_URL . "/asktheme_attach";

if (!defined('_GNUBOARD_')) {
    exit;
}
include_once G5_PLUGIN_PATH . "/asktheme/_admin/head.php";
add_stylesheet('<link rel="stylesheet" href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin['id'] . '/plugin_style.css">', 0);
//수정모드일때
if ($w == 'u' && $idx) {
    $sql = "select * from ask_plugin_banner where ab_idx = '{$idx}'";
    $data = sql_fetch($sql);
    if (!$data) {
        alert('데이터가 없습니다.', './banner_list.php');
    }
}
?>
<div id="container">
    <div class="row">
        <div class="small-12 medium-12 large-12 columns">
            <div class="panel panel-default">
                <div class="panel-header">
                    <h1><?php echo $plugin['name'], $plugin['version']; ?> 등록하기</h1>
                </div>
                <div class="panel-body">
                    <form class="add_banner" action="./banner_add_update.php"  onsubmit="return form_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" >
                        <?php
                        if ($w == 'u' && $idx) {
                            echo "<input type='hidden' name='w' value='u'>";
                            echo "<input type='hidden' name='ab_idx' value='{$data['ab_idx']}'>";
                        }
                        ?>
                        <input type="hidden" name="pc_id" value="<?php echo $plugin['id'] ?>"/>
                        <input type="hidden" name="pc_name" value="<?php echo $plugin['name'] ?>"/>

                        <div class="responsetable write-table">
                            <div class="tb-body">
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="ab_status">배너사용여부<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php
                                        if ($data['ab_status'] == '1') {
                                            $ab_use = "checked";
                                        } elseif ($data['ab_status'] == '0') {
                                            $ab_unuse = "checked";
                                        }
                                        ?>
                                        <label><input type="radio" name="ab_status" value="1" <?php echo $ab_use ?> class="banner-start">사용하기</label>
                                        <label><input type="radio" name="ab_status" value="0" <?php echo $ab_unuse ?> class="banner-stop">중지하기</label>
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="ab_tag">배너 태그<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <script>
                                                $(function () {
                                                    var tag_val = $('select[name=ab_tag] option[value="<?php echo $data['ab_tag'] ?>"]').val();
                                                    if (tag_val !== undefined) {
                                                        $('select[name=ab_tag]').val('<?php echo $data['ab_tag'] ?>');
                                                        $('input[name=ab_tag_custom]').attr('checked', false);
                                                        $('select[name=ab_tag]').attr("disabled", false).show();
                                                        $('input[name=ab_tag]').attr("disabled", true);
                                                    } else {
                                                        $('input[name=ab_tag]').val('<?php echo $data['ab_tag'] ?>');
                                                        $('input[name=ab_tag_custom]').attr('checked', true);
                                                        $('select[name=ab_tag]').attr("disabled", true).hide();
                                                        $('input[name=ab_tag]').attr("disabled", false);
                                                    }
                                                });
                                            </script>
                                        <?php } ?>
                                        <select name="ab_tag" class="input">
                                            <option value="">배너위치선택</option>
                                            <optgroup label="PC">
                                                <option value="메인상단">메인상단</option>
                                                <option value="메인하단">메인하단</option>
                                                <option value="메인사이드">메인사이드</option>
                                                <option value="전체사이드">전체사이드</option>
                                                <option value="그룹메인상단">그룹메인상단</option>
                                                <option value="그룹메인하단">그룹메인하단</option>
                                                <option value="게시판목록상단">게시판목록상단</option>
                                                <option value="게시판목록하단">게시판목록하단</option>
                                                <option value="게시판내용상단">게시판내용상단</option>
                                                <option value="게시판내용하단">게시판내용하단</option>
                                                <option value="게시판댓글상단">게시판댓글상단</option>
                                                <option value="게시판댓글하단">게시판댓글하단</option>
                                            </optgroup>
                                            <optgroup label="Mobile">
                                                <option value="모바일메인상단">모바일메인상단</option>
                                                <option value="모바일메인하단">모바일메인하단</option>
                                                <option value="모바일그룹메인상단">모바일그룹메인상단</option>
                                                <option value="모바일그룹메인하단">모바일그룹메인하단</option>
                                                <option value="모바일게시판목록상단">모바일게시판목록상단</option>
                                                <option value="모바일게시판목록하단">모바일게시판목록하단</option>
                                                <option value="모바일게시판내용상단">모바일게시판내용상단</option>
                                                <option value="모바일게시판내용하단">모바일게시판내용하단</option>
                                                <option value="모바일게시판댓글상단">모바일게시판댓글상단</option>
                                                <option value="모바일게시판댓글하단">모바일게시판댓글하단</option>
                                            </optgroup>
                                        </select>
                                        <label><input type="checkbox" name="ab_tag_custom" value="">사용자지정</label>
                                        <input type="text" name="ab_tag" value="" class="input" disabled="disabled">
                                        <div class="text text-default help">
                                            배너의 위치를 선택하세요. <br/>사용자지정 위치를 사용하려면 아래의 php 코드를 배너가 게시되길 원하는 위치에 삽입하세요.<br/>
                                            <?php if ($w == 'u') { ?>
                                                <span class="code">&lt;?php echo plugin_run('<?php echo $data['ab_tag'] ?>', '[[banner]]', false, '<?php echo $data['ab_tag'] ?>');?&gt;</span>
                                            <?php } else { ?>
                                                <span class="code">&lt;?php echo plugin_run('사용자지정배너태그', '[[banner]]', false, '사용자지정배너태그');?&gt;</span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="ab_type">종류선택<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <script>
                                                $(function () {
                                                    setTimeout(function () {
                                                        $('input[name=ab_type][value="<?php echo $data['ab_type'] ?>"]').attr('chekced', true).trigger('click');
                                                    }, 300);
                                                    $('input[name=ab_type][value="<?php echo $data['ab_type'] ?>"]').attr('chekced', true).trigger('click');
                                                });
                                            </script>
                                        <?php } ?>
                                        <label><input type="radio" name="ab_type" value="text" class="type-text">텍스트배너</label>
                                        <label><input type="radio" name="ab_type" value="image" class="type-image">이미지배너</label>
                                        <label><input type="radio" name="ab_type" value="html" class="type-html">HTML배너</label>
                                    </div>
                                </div>
                                <div class="tb-row banner-text">
                                    <div class="tb-cell"><label for="ab_subject">배너텍스트<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <input type="text" name="ab_subject" value="<?php echo $data['ab_subject'] ?>" size="50" class="input" placeholder="배너텍스트"/>
                                    </div>
                                </div>
                                <div class="tb-row banner-image">
                                    <div class="tb-cell"><label for="ab_banner_image">배너이미지<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <input type="file" name="ab_banner_image" value="" class="input" accept="image/*"/>
                                        <?php if ($data['ab_banner']) { ?>
                                            <div class="text text-default">
                                                <img src="<?php echo "{$asktheme_upload_url}/{$data['ab_banner']}"; ?>" class="banner-image"/>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="tb-row banner-html">
                                    <div class="tb-cell"><label for="ab_html">html 배너<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <textarea name="ab_html" id="ab_html" class="input textarea" placeholder="html 배너 또는 스크립트, Adsense"><?php echo $data['ab_html'] ?></textarea>
                                    </div>
                                </div>
                                <div class="tb-row banner-link">
                                    <div class="tb-cell"><label for="ab_link">배너링크<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <input type="url" name="ab_link" value="<?php echo $data['ab_link'] ?>" size="50" class="input" placeholder="http를 포함한 전체주소를 넣으세요." />
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell show-for-medium">

                                    </div>
                                    <div class="tb-cell">
                                        <div class="button-group">
                                            <button type="submit" class="button primary submit"><i class="fa fa-check"></i> 확인</button>
                                            <button type="button" class="button danger cancel"><i class="fa fa-ban"></i> 취소</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--responsetable-->
                    </form>
                </div>
                <div class="panel-footer">

                    * 배너태그는 배너의 위치입니다.<br/>
                    * 같은 배너태그를 사용하는 배너를 여러개 등록하면 새로고침시 랜덤 출력됩니다.
                    * 배너용 스타일은 아래와 같이 클래스로 정의하여 사용하세요.
                    <pre>
.ask_banner_text{}
.ask_banner_text_link{}
.ask_banner_image{}
.ask_banner_image_link{}
.ask_banner_html{}
                    </pre>

                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        $('.cancel').click(function () {
            if (confirm('취소하시겠습니까?')) {
                location.href = history.go(-1);
            } else {
                return false;
            }
        });
        $('input[name=ab_tag_custom]').click(function () {
            if ($(this).attr('checked') === 'checked') {
                $('select[name=ab_tag]').attr("disabled", true).css('background-color', '#ddd').hide();
                $('input[name=ab_tag]').attr("disabled", false);
            } else {
                $('select[name=ab_tag]').attr("disabled", false).css('background-color', '#fff').show();
                $('input[name=ab_tag]').attr("disabled", true);
            }
        });
        $('.banner-text, .banner-image, .banner-link, .banner-html').css('display', 'none');
        $('input[name=ab_type]').on('click', function () {
            var type_banner = $('input[name=ab_type]:checked').val();
            if (type_banner === 'text') {
                $('.banner-text, .banner-link').css('display', 'table-row');
                $('.banner-image, .banner-html').css('display', 'none');
            }
            if (type_banner === 'image') {
                $('.banner-image, .banner-link').css('display', 'table-row');
                $('.banner-text, .banner-html').css('display', 'none');
            }
            if (type_banner === 'html') {
                $('.banner-html').css('display', 'table-row');
                $('.banner-text, .banner-image, .banner-link').css('display', 'none');
            }
        });
    });
    function validateURL(textval) {
        var urlregex = /^(https?|http):\/\/([a-zA-Z0-9.-]+(:[a-zA-Z0-9.&%$-]+)*@)*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])){3}|([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))(:[0-9]+)*(\/($|[a-zA-Z0-9.,?'\\+&%$#=~_-]+))*$/;
        return urlregex.test(textval);
    }
    function form_submit(f) {
        //console.log(f);
        var use_banner = $('input[name=ab_status]:checked').val();
        if (use_banner === undefined) {
            alert('배너 사용여부를 선택하세요');
            return false;
        }
        //배너태그 선택
        if ($('input[name=ab_tag_custom]').prop("checked") === true) {
            var banner_tags = $('input[name=ab_tag]').val();
        } else {
            var banner_tags = $('select[name=ab_tag]').val();
        }
        if (banner_tags === '') {
            alert('배너 태그를 선택 또는 입력하세요.');
            return false;
        }

        //배너종류
        var type_banner = $('input[name=ab_type]:checked').val();
        if (type_banner === undefined) {
            alert('배너 종류를 선택하세요.');
            return false;
        }
        if (type_banner === 'text') {
            if ($('input[name=ab_subject]').val() === '') {
                alert('배너 텍스트를 등록하세요.');
                $('input[name=ab_subject]').css('background-color', '#faff6d');
                return false;
            }
            if ($('input[name=ab_link]').val() === '' || validateURL($('input[name=ab_link]').val()) === false) {
                alert('배너 링크를 등록하세요.');
                $('input[name=ab_link]').css('background-color', '#faff6d');
                return false;
            }
        }
        if (type_banner === 'image') {
            if (!$('input[name=w]')) {
                if ($('input[name=ab_banner_image]').val() === '') {
                    alert('배너 이미지를 등록하세요.');
                    $('input[name=ab_banner_image]').css('background-color', '#faff6d');
                    return false;
                }
            }
            if ($('input[name=ab_link]').val() === '') {
                alert('배너 링크를 등록하세요.');
                $('input[name=ab_link]').css('background-color', '#faff6d');
                return false;
            }
        }
        if (type_banner === 'html') {
            if ($('textarea[name=ab_html]').val() === '') {
                alert('HTML 또는 스크립트 배너를 등록하세요.');
                $('textarea[name=ab_html]').css('background-color', '#faff6d');
                return false;
            }
        }
        return true;
    }
</script>
<?php
include_once G5_PLUGIN_PATH . "/asktheme/_admin/tail.php";
